/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class IntervalType
extends DTIType {
    public final boolean defaultPrecision;
    public final boolean isYearMonth;
    public static final NumberType factorType = NumberType.getNumberType(3, 40L, 9);

    private IntervalType(int n2, int n3, long l2, int n4, int n5, int n6, boolean bl) {
        super(n2, n3, l2, n4, n5, n6);
        if (n6 != 106 && n4 != 0) {
            throw Error.error(3406);
        }
        switch (n5) {
            case 101: 
            case 102: {
                this.isYearMonth = true;
                break;
            }
            default: {
                this.isYearMonth = false;
            }
        }
        this.defaultPrecision = bl;
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 101: {
                return (int)this.precision + 1;
            }
            case 107: {
                return (int)this.precision + 4;
            }
            case 102: {
                return (int)this.precision + 1;
            }
            case 103: {
                return (int)this.precision + 1;
            }
            case 108: {
                return (int)this.precision + 4;
            }
            case 109: {
                return (int)this.precision + 7;
            }
            case 110: {
                return (int)this.precision + 10 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 104: {
                return (int)this.precision + 1;
            }
            case 111: {
                return (int)this.precision + 4;
            }
            case 112: {
                return (int)this.precision + 7 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 105: {
                return (int)this.precision + 1;
            }
            case 113: {
                return (int)this.precision + 4 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 106: {
                return (int)this.precision + 1 + (this.scale == 0 ? 0 : this.scale + 1);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return IntervalMonthData.class;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalSecondData.class;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String getJDBCClassName() {
        return this.getJDBCClass().getName();
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 10;
    }

    @Override
    public String getNameString() {
        return "INTERVAL " + IntervalType.getQualifier(this.typeCode);
    }

    public static String getQualifier(int n2) {
        switch (n2) {
            case 101: {
                return "YEAR";
            }
            case 107: {
                return "YEAR TO MONTH";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 108: {
                return "DAY TO HOUR";
            }
            case 109: {
                return "DAY TO MINUTE";
            }
            case 110: {
                return "DAY TO SECOND";
            }
            case 104: {
                return "HOUR";
            }
            case 111: {
                return "HOUR TO MINUTE";
            }
            case 112: {
                return "HOUR TO SECOND";
            }
            case 105: {
                return "MINUTE";
            }
            case 113: {
                return "MINUTE TO SECOND";
            }
            case 106: {
                return "SECOND";
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 2L && (this.endIntervalType != 106 || this.scale == 6)) {
            return this.getNameString();
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("INTERVAL").append(' ');
        stringBuilder.append(IntervalType.getQualifier(this.startIntervalType));
        if (this.typeCode == 106) {
            stringBuilder.append('(');
            stringBuilder.append(this.precision);
            if (this.scale != 6) {
                stringBuilder.append(',');
                stringBuilder.append(this.scale);
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        if (this.precision != 2L) {
            stringBuilder.append('(');
            stringBuilder.append(this.precision);
            stringBuilder.append(')');
        }
        if (this.startIntervalType != this.endIntervalType) {
            stringBuilder.append(' ');
            stringBuilder.append("TO");
            stringBuilder.append(' ');
            stringBuilder.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
            if (this.endIntervalType == 106 && this.scale != 6) {
                stringBuilder.append('(');
                stringBuilder.append(this.scale);
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isIntervalType() {
        return true;
    }

    @Override
    public boolean isIntervalYearMonthType() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIntervalDaySecondType() {
        switch (this.typeCode) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.endIntervalType == 106;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            if (this.precision >= type.precision && this.scale >= type.scale) {
                return this;
            }
            if (this.precision <= type.precision && this.scale <= type.scale) {
                return type;
            }
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isIntervalType()) {
            throw Error.error(5562);
        }
        int n2 = ((IntervalType)type).startIntervalType > this.startIntervalType ? this.startIntervalType : ((IntervalType)type).startIntervalType;
        int n3 = ((IntervalType)type).endIntervalType > this.endIntervalType ? ((IntervalType)type).endIntervalType : this.endIntervalType;
        int n4 = IntervalType.getCombinedIntervalType(n2, n3);
        long l2 = this.precision > type.precision ? this.precision : type.precision;
        int n5 = this.scale > type.scale ? this.scale : type.scale;
        try {
            return IntervalType.getIntervalType(n4, n2, n3, l2, n5, false);
        }
        catch (RuntimeException runtimeException) {
            throw Error.error(5562);
        }
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        switch (n2) {
            case 34: {
                if (!type.isNumberType()) break;
                return IntervalType.getIntervalType(this, 9L, this.scale);
            }
            case 35: {
                if (type.isNumberType()) {
                    return this;
                }
                if (!type.isIntervalType()) break;
                IntervalType intervalType = (IntervalType)type;
                if (this.isYearMonth != intervalType.isYearMonth) break;
                return this.isYearMonth ? Type.SQL_BIGINT : factorType;
            }
            case 32: {
                if (type.isDateTimeType()) {
                    return type.getCombinedType(session, this, n2);
                }
                if (!type.isIntervalType()) break;
                IntervalType intervalType = (IntervalType)this.getAggregateType(type);
                return IntervalType.getIntervalType(intervalType, 9L, 0);
            }
            default: {
                return this.getAggregateType(type);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return ((IntervalMonthData)object).compareTo((IntervalMonthData)object2);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return ((IntervalSecondData)object).compareTo((IntervalSecondData)object2);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData) {
            IntervalMonthData intervalMonthData = (IntervalMonthData)object;
            if ((long)intervalMonthData.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        } else if (object instanceof IntervalSecondData) {
            IntervalSecondData intervalSecondData = (IntervalSecondData)object;
            if (intervalSecondData.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        }
        return object;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                if (object instanceof BigDecimal && NumberType.compareToLongLimits((BigDecimal)object) != 0) {
                    throw Error.error(3435);
                }
                long l2 = ((Number)object).longValue();
                switch (this.endIntervalType) {
                    case 101: {
                        return IntervalMonthData.newIntervalYear(l2, this);
                    }
                    case 102: {
                        return IntervalMonthData.newIntervalMonth(l2, this);
                    }
                    case 103: {
                        return IntervalSecondData.newIntervalDay(l2, this);
                    }
                    case 104: {
                        return IntervalSecondData.newIntervalHour(l2, this);
                    }
                    case 105: {
                        return IntervalSecondData.newIntervalMinute(l2, this);
                    }
                    case 106: {
                        int n2 = 0;
                        if (this.scale > 0) {
                            if (object instanceof BigDecimal) {
                                n2 = (int)NumberType.scaledDecimal(object, 9);
                            } else if (object instanceof Double) {
                                double d2 = (Double)object;
                                d2 -= (double)((long)d2);
                                n2 = (int)(d2 * 1.0E9);
                            }
                        }
                        return new IntervalSecondData(l2, n2, this);
                    }
                }
                throw Error.error(5561);
            }
            case 101: {
                long l3 = (long)(((IntervalMonthData)object).units / 12) * 12L;
                return new IntervalMonthData(l3, this);
            }
            case 102: 
            case 107: {
                long l4 = ((IntervalMonthData)object).units;
                return new IntervalMonthData(l4, this);
            }
            case 103: {
                long l5 = ((IntervalSecondData)object).units;
                l5 = l5 / (long)DTIType.yearToSecondFactors[2] * (long)DTIType.yearToSecondFactors[2];
                return new IntervalSecondData(l5, 0, this);
            }
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                long l6 = ((IntervalSecondData)object).units;
                l6 = l6 / (long)DTIType.yearToSecondFactors[this.endPartIndex] * (long)DTIType.yearToSecondFactors[this.endPartIndex];
                return new IntervalSecondData(l6, 0, this);
            }
            case 106: 
            case 110: 
            case 112: 
            case 113: {
                long l7 = ((IntervalSecondData)object).units;
                int n3 = ((IntervalSecondData)object).nanos;
                n3 = this.scale == 0 ? 0 : n3 / DTIType.nanoScaleFactors[this.scale] * DTIType.nanoScaleFactors[this.scale];
                return new IntervalSecondData(l7, n3, this);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.convertToType(sessionInterface, object, Type.SQL_VARCHAR);
        }
        if (object instanceof Integer) {
            return this.convertToType(sessionInterface, object, Type.SQL_INTEGER);
        }
        if (object instanceof Long) {
            return this.convertToType(sessionInterface, object, Type.SQL_BIGINT);
        }
        if (object instanceof BigDecimal) {
            return this.convertToType(sessionInterface, object, Type.SQL_DECIMAL);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        TimestampData timestampData = this.convertJavaTimeObject(sessionInterface, object);
        if (timestampData != null) {
            return timestampData;
        }
        return this.convertToDefaultType(sessionInterface, object);
    }

    TimestampData convertJavaTimeObject(SessionInterface sessionInterface, Object object) {
        return null;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return this.intervalMonthToString(object);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return this.intervalSecondToString(object);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("INTERVAL").append(' ');
        stringBuilder.append('\'').append(this.convertToString(object)).append('\'').append(' ');
        stringBuilder.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.startPartIndex]);
        if (this.startPartIndex != this.endPartIndex) {
            stringBuilder.append(' ');
            stringBuilder.append("TO");
            stringBuilder.append(' ');
            stringBuilder.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (type.isNumberType()) {
            return true;
        }
        if (!type.isIntervalType()) {
            return false;
        }
        return this.isIntervalYearMonthType() == type.isIntervalYearMonthType();
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? 0 : -1;
        }
        if (!type.isIntervalType()) {
            return -1;
        }
        if (this.isYearMonth == ((IntervalType)type).isYearMonth) {
            if (this.scale < type.scale) {
                return -1;
            }
            if (this.endPartIndex >= ((IntervalType)type).endPartIndex) {
                if (this.precision >= type.precision && this.startPartIndex <= ((IntervalType)type).startPartIndex) {
                    return 0;
                }
                return 1;
            }
        }
        return -1;
    }

    @Override
    public int compareToTypeRange(Object object) {
        long l2;
        long l3 = precisionLimits[(int)this.precision];
        if (object instanceof IntervalMonthData) {
            l2 = ((IntervalMonthData)object).units;
        } else if (object instanceof IntervalSecondData) {
            l2 = ((IntervalSecondData)object).units;
        } else {
            return 0;
        }
        if (l2 >= l3) {
            return 1;
        }
        if (l2 < 0L && -l2 >= l3) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object absolute(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData ? ((IntervalMonthData)object).units < 0 : ((IntervalSecondData)object).units < 0L || ((IntervalSecondData)object).nanos < 0) {
            return this.negate(object);
        }
        return object;
    }

    @Override
    public Object negate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData) {
            long l2 = ((IntervalMonthData)object).units;
            return new IntervalMonthData(-l2, this);
        }
        long l3 = ((IntervalSecondData)object).units;
        int n2 = ((IntervalSecondData)object).nanos;
        return new IntervalSecondData(-l3, -n2, this, true);
    }

    @Override
    public boolean isNegative(Object object) {
        if (object instanceof IntervalMonthData) {
            return ((IntervalMonthData)object).units < 0;
        }
        long l2 = ((IntervalSecondData)object).units;
        if (l2 < 0L) {
            return true;
        }
        if (l2 == 0L) {
            return ((IntervalSecondData)object).nanos < 0;
        }
        return false;
    }

    @Override
    public Object add(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                long l2 = ((IntervalMonthData)object).units + ((IntervalMonthData)object2).units;
                return new IntervalMonthData(l2, this);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                long l3 = ((IntervalSecondData)object).units + ((IntervalSecondData)object2).units;
                long l4 = ((IntervalSecondData)object).nanos + ((IntervalSecondData)object2).nanos;
                return new IntervalSecondData(l3, l4, this, true);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public Object subtract(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                if (object instanceof IntervalMonthData && object2 instanceof IntervalMonthData) {
                    long l2 = ((IntervalMonthData)object).units - ((IntervalMonthData)object2).units;
                    return new IntervalMonthData(l2, this);
                }
                if (object instanceof TimestampData && object2 instanceof TimestampData) {
                    boolean bl = this.typeCode == 101;
                    long l3 = DateTimeType.subtractMonths(session, (TimestampData)object, (TimestampData)object2, bl);
                    return new IntervalMonthData(l3, this);
                }
                throw Error.runtimeError(201, "IntervalType");
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                if (object instanceof IntervalSecondData && object2 instanceof IntervalSecondData) {
                    long l4 = ((IntervalSecondData)object).units - ((IntervalSecondData)object2).units;
                    long l5 = ((IntervalSecondData)object).nanos - ((IntervalSecondData)object2).nanos;
                    return new IntervalSecondData(l4, l5, this, true);
                }
                if (object instanceof TimeData && object2 instanceof TimeData) {
                    long l6 = ((TimeData)object).getSeconds();
                    long l7 = ((TimeData)object2).getSeconds();
                    long l8 = ((TimeData)object).getNanos() - ((TimeData)object2).getNanos();
                    return this.subtract(session, l6, l7, l8);
                }
                if (!(object instanceof TimestampData) || !(object2 instanceof TimestampData)) break;
                long l9 = ((TimestampData)object).getSeconds();
                long l10 = ((TimestampData)object2).getSeconds();
                long l11 = ((TimestampData)object).getNanos() - ((TimestampData)object2).getNanos();
                return this.subtract(session, l9, l10, l11);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    private IntervalSecondData subtract(Session session, long l2, long l3, long l4) {
        if (this.endIntervalType != 106) {
            l2 = HsqlDateTime.getTruncatedPart(session.getCalendarGMT(), l2 * 1000L, this.endIntervalType) / 1000L;
            l3 = HsqlDateTime.getTruncatedPart(session.getCalendarGMT(), l3 * 1000L, this.endIntervalType) / 1000L;
            l4 = 0L;
        }
        return new IntervalSecondData(l2 - l3, l4, this, true);
    }

    @Override
    public Object multiply(Object object, Object object2) {
        return this.multiplyOrDivide(object, object2, false);
    }

    @Override
    public Object divide(Session session, Object object, Object object2) {
        return this.multiplyOrDivide(object, object2, true);
    }

    private Object multiplyOrDivide(Object object, Object object2, boolean bl) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof Number) {
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        boolean bl2 = object2 instanceof Number;
        if (bl && (bl2 ? NumberType.isZero(object2) : (this.isYearMonth ? ((IntervalMonthData)object2).units == 0 : ((IntervalSecondData)object2).units == 0L))) {
            throw Error.error(3432);
        }
        BigDecimal bigDecimal3 = (BigDecimal)factorType.convertToDefaultType(null, object2);
        if (this.isYearMonth) {
            bigDecimal2 = BigDecimal.valueOf(((IntervalMonthData)object).units);
        } else {
            long l2 = ((IntervalSecondData)object).units * (long)DTIType.nanoScaleFactors[0] + (long)((IntervalSecondData)object).nanos;
            bigDecimal2 = BigDecimal.valueOf(l2, 9);
        }
        BigDecimal bigDecimal4 = bigDecimal = bl ? (BigDecimal)factorType.divide(null, bigDecimal2, bigDecimal3) : (BigDecimal)factorType.multiply(bigDecimal2, bigDecimal3);
        if (NumberType.compareToLongLimits(bigDecimal) != 0) {
            throw Error.error(3435);
        }
        if (bl2) {
            if (this.isYearMonth) {
                return new IntervalMonthData(bigDecimal.longValue(), this);
            }
            int n2 = (int)NumberType.scaledDecimal(bigDecimal, 9);
            return new IntervalSecondData(bigDecimal.longValue(), n2, this, true);
        }
        if (this.isYearMonth) {
            return bigDecimal.longValue();
        }
        return bigDecimal;
    }

    String intervalMonthToString(Object object) {
        StringBuilder stringBuilder = new StringBuilder(8);
        long l2 = ((IntervalMonthData)object).units;
        if (l2 < 0L) {
            l2 = -l2;
            stringBuilder.append('-');
        }
        for (int i2 = this.startPartIndex; i2 <= this.endPartIndex; ++i2) {
            int n2 = DTIType.yearToSecondFactors[i2];
            long l3 = l2 / (long)n2;
            if (i2 == this.startPartIndex) {
                int n3 = (int)this.precision - IntervalType.getPrecisionExponent(l3);
            } else if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3);
            l2 %= (long)n2;
            if (i2 >= this.endPartIndex) continue;
            stringBuilder.append((char)DTIType.yearToSecondSeparators[i2]);
        }
        return stringBuilder.toString();
    }

    String intervalSecondToString(Object object) {
        long l2 = ((IntervalSecondData)object).units;
        int n2 = ((IntervalSecondData)object).nanos;
        return this.intervalSecondToString(l2, n2, false);
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.isIntervalType()) {
            int n2 = ((IntervalType)type).endPartIndex;
            return n2 - this.endPartIndex;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    @Override
    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    public static IntervalType newIntervalType(int n2, long l2, int n3) {
        int n4 = IntervalType.getStartIntervalType(n2);
        int n5 = IntervalType.getEndIntervalType(n2);
        int n6 = n4 > 102 ? 106 : 102;
        return new IntervalType(n6, n2, l2, n3, n4, n5, false);
    }

    public static IntervalType getIntervalType(IntervalType intervalType, long l2, int n2) {
        if (intervalType.precision >= l2 && intervalType.scale >= n2) {
            return intervalType;
        }
        return IntervalType.getIntervalType(intervalType.typeCode, l2, n2);
    }

    public static IntervalType getIntervalType(int n2, long l2, int n3) {
        int n4 = IntervalType.getStartIntervalType(n2);
        int n5 = IntervalType.getEndIntervalType(n2);
        return IntervalType.getIntervalType(n2, n4, n5, l2, n3, false);
    }

    public static IntervalType getIntervalType(int n2, int n3, long l2, int n4) {
        boolean bl;
        boolean bl2 = bl = l2 == -1L;
        if (n2 == -1 || n3 == -1) {
            throw Error.error(3406);
        }
        if (n2 > n3) {
            throw Error.error(3406);
        }
        if (n2 <= 1 && n3 > 1) {
            throw Error.error(3406);
        }
        int n5 = DTIType.intervalParts[n2];
        int n6 = DTIType.intervalParts[n3];
        int n7 = DTIType.intervalTypes[n2][n3];
        if (l2 == 0L || n4 > 9) {
            throw Error.error(5592);
        }
        if (n2 == 5 ? l2 > 12L : l2 > 9L) {
            throw Error.error(5592);
        }
        if (l2 == -1L) {
            l2 = 2L;
        }
        if (n4 == -1) {
            n4 = n6 == 106 ? 6 : 0;
        }
        return IntervalType.getIntervalType(n7, n5, n6, l2, n4, bl);
    }

    public static IntervalType getIntervalType(int n2, int n3, int n4, long l2, int n5, boolean bl) {
        int n6;
        int n7 = n6 = n3 > 102 ? 106 : 102;
        if (bl) {
            return new IntervalType(n6, n2, l2, n5, n3, n4, bl);
        }
        switch (n2) {
            case 101: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_YEAR;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_YEAR_MAX_PRECISION;
            }
            case 107: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_YEAR_TO_MONTH;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
            }
            case 102: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_MONTH;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_MONTH_MAX_PRECISION;
            }
            case 103: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_DAY;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_DAY_MAX_PRECISION;
            }
            case 108: {
                if (l2 != 2L) break;
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                if (l2 != 2L) break;
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                if (l2 != 2L || n5 != 6) break;
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_HOUR;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_HOUR_MAX_PRECISION;
            }
            case 111: {
                if (l2 != 2L) break;
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 105: {
                if (l2 == 2L) {
                    return SQL_INTERVAL_MINUTE;
                }
                if (l2 != 9L) break;
                return SQL_INTERVAL_MINUTE_MAX_PRECISION;
            }
            case 112: {
                if (l2 != 2L || n5 != 6) break;
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 113: {
                if (l2 != 2L || n5 != 6) break;
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                if (l2 != 2L || n5 != 6) break;
                return SQL_INTERVAL_SECOND;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return new IntervalType(n6, n2, l2, n5, n3, n4, bl);
    }

    public static int getStartIntervalType(int n2) {
        int n3;
        switch (n2) {
            case 101: 
            case 107: {
                n3 = 101;
                break;
            }
            case 102: {
                n3 = 102;
                break;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                n3 = 103;
                break;
            }
            case 104: 
            case 111: 
            case 112: {
                n3 = 104;
                break;
            }
            case 105: 
            case 113: {
                n3 = 105;
                break;
            }
            case 106: {
                n3 = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return n3;
    }

    public static int getEndIntervalType(int n2) {
        int n3;
        switch (n2) {
            case 101: {
                n3 = 101;
                break;
            }
            case 107: {
                n3 = 102;
                break;
            }
            case 102: {
                n3 = 102;
                break;
            }
            case 103: {
                n3 = 103;
                break;
            }
            case 108: {
                n3 = 104;
                break;
            }
            case 109: {
                n3 = 105;
                break;
            }
            case 110: {
                n3 = 106;
                break;
            }
            case 104: {
                n3 = 104;
                break;
            }
            case 111: {
                n3 = 105;
                break;
            }
            case 112: {
                n3 = 106;
                break;
            }
            case 105: {
                n3 = 105;
                break;
            }
            case 113: {
                n3 = 106;
                break;
            }
            case 106: {
                n3 = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return n3;
    }

    public static Type getCombinedIntervalType(IntervalType intervalType, IntervalType intervalType2) {
        int n2 = intervalType2.startIntervalType > intervalType.startIntervalType ? intervalType.startIntervalType : intervalType2.startIntervalType;
        int n3 = intervalType2.endIntervalType > intervalType.endIntervalType ? intervalType2.endIntervalType : intervalType.endIntervalType;
        int n4 = IntervalType.getCombinedIntervalType(n2, n3);
        long l2 = intervalType.precision > intervalType2.precision ? intervalType.precision : intervalType2.precision;
        int n5 = intervalType.scale > intervalType2.scale ? intervalType.scale : intervalType2.scale;
        return IntervalType.getIntervalType(n4, n2, n3, l2, n5, false);
    }

    public static int getCombinedIntervalType(int n2, int n3) {
        if (n2 == n3) {
            return n2;
        }
        switch (n2) {
            case 101: {
                if (n3 != 102) break;
                return 107;
            }
            case 103: {
                switch (n3) {
                    case 104: {
                        return 108;
                    }
                    case 105: {
                        return 109;
                    }
                    case 106: {
                        return 110;
                    }
                }
                break;
            }
            case 104: {
                switch (n3) {
                    case 105: {
                        return 111;
                    }
                    case 106: {
                        return 112;
                    }
                }
                break;
            }
            case 105: {
                if (n3 != 106) break;
                return 113;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public static int getIntervalType(String string) {
        int n2 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_NAMES, string);
        if (n2 < 0) {
            throw Error.error(5562);
        }
        return intervalParts[n2];
    }

    long getIntervalValueLimit() {
        long l2;
        switch (this.typeCode) {
            case 101: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 12L;
                break;
            }
            case 107: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 12L;
                l2 += 12L;
                break;
            }
            case 102: {
                l2 = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            case 103: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 108: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 109: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 110: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 104: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 111: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 112: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 105: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 113: {
                l2 = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 106: {
                l2 = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return l2;
    }

    @Override
    public int getPart(Session session, Object object, int n2) {
        switch (n2) {
            case 101: {
                return ((IntervalMonthData)object).units / 12;
            }
            case 102: {
                long l2 = ((IntervalMonthData)object).units;
                return n2 == this.startIntervalType ? (int)l2 : (int)(l2 % 12L);
            }
            case 103: {
                return (int)(((IntervalSecondData)object).units / 86400L);
            }
            case 104: {
                long l3 = ((IntervalSecondData)object).units / 3600L;
                return n2 == this.startIntervalType ? (int)l3 : (int)(l3 % 24L);
            }
            case 105: {
                long l4 = ((IntervalSecondData)object).units / 60L;
                return n2 == this.startIntervalType ? (int)l4 : (int)(l4 % 60L);
            }
            case 106: {
                long l5 = ((IntervalSecondData)object).units;
                return n2 == this.startIntervalType ? (int)l5 : (int)(l5 % 60L);
            }
            case 132: {
                return ((IntervalSecondData)object).nanos / 1000000;
            }
            case 133: {
                return ((IntervalSecondData)object).nanos / 1000;
            }
            case 134: {
                return ((IntervalSecondData)object).nanos;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public long getSeconds(Object object) {
        return ((IntervalSecondData)object).units;
    }

    @Override
    public BigDecimal getSecondPart(Session session, Object object) {
        long l2 = ((IntervalSecondData)object).units;
        if (this.typeCode != 106) {
            l2 %= 60L;
        }
        int n2 = ((IntervalSecondData)object).nanos;
        return this.getSecondPart(l2, n2);
    }

    public long convertToLongEndUnits(Object object) {
        switch (this.endIntervalType) {
            case 101: 
            case 102: {
                long l2 = ((IntervalMonthData)object).units;
                return l2 / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                long l3 = ((IntervalSecondData)object).units;
                return l3 / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public double convertToDoubleStartUnits(Object object) {
        switch (this.startIntervalType) {
            case 101: 
            case 102: {
                double d2 = ((IntervalMonthData)object).units;
                return d2 / (double)DTIType.yearToSecondFactors[this.startPartIndex];
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                double d3 = ((IntervalSecondData)object).units;
                return d3 / (double)DTIType.yearToSecondFactors[this.startPartIndex];
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public static double convertToDouble(Object object) {
        if (object instanceof IntervalMonthData) {
            double d2 = ((IntervalMonthData)object).units;
            return d2;
        }
        IntervalSecondData intervalSecondData = (IntervalSecondData)object;
        double d3 = (double)intervalSecondData.units + (double)intervalSecondData.nanos / (double)nanoScaleFactors[0];
        return d3;
    }

    public Object convertFromDouble(double d2) {
        long l2 = (long)d2;
        if (this.isIntervalYearMonthType()) {
            return new IntervalMonthData(l2);
        }
        int n2 = (int)((d2 - (double)l2) * 1.0E9);
        return new IntervalSecondData(l2, n2);
    }

    public CharacterType getCharacterType() {
        String string = this.getNameString();
        CharacterType characterType = new CharacterType(string, (long)this.displaySize());
        return characterType;
    }

    public Object getValue(long l2, int n2) {
        if (this.isIntervalYearMonthType()) {
            return new IntervalMonthData(l2, this);
        }
        return new IntervalSecondData(l2, n2, this, true);
    }
}

