/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class IntervalMonthData {
    public final int units;

    public static IntervalMonthData newInterval(double d2, int n2) {
        int n3 = DTIType.intervalIndexMap.get(n2);
        return new IntervalMonthData((long)(d2 *= (double)DTIType.yearToSecondFactors[n3]));
    }

    public static IntervalMonthData newIntervalYear(long l2, IntervalType intervalType) {
        return new IntervalMonthData(l2 * 12L, intervalType);
    }

    public static IntervalMonthData newIntervalMonth(long l2, IntervalType intervalType) {
        return new IntervalMonthData(l2, intervalType);
    }

    public IntervalMonthData(long l2, IntervalType intervalType) {
        if (l2 >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3406);
        }
        if (intervalType.typeCode == 101) {
            l2 -= l2 % 12L;
        }
        this.units = (int)l2;
    }

    public IntervalMonthData(long l2) {
        this.units = (int)l2;
    }

    public boolean equals(Object object) {
        if (object instanceof IntervalMonthData) {
            return this.units == ((IntervalMonthData)object).units;
        }
        return false;
    }

    public int hashCode() {
        return this.units;
    }

    public int compareTo(IntervalMonthData intervalMonthData) {
        if (this.units > intervalMonthData.units) {
            return 1;
        }
        if (this.units < intervalMonthData.units) {
            return -1;
        }
        return 0;
    }

    public int getMonths() {
        return this.units;
    }

    public String toString() {
        return Type.SQL_INTERVAL_MONTH_MAX_PRECISION.convertToString(this);
    }
}

