/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public final boolean withTimeZone;
    private String nameString;
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);
    public static final long epochLimitSeconds = HsqlDateTime.getDateSeconds("10000-01-01");
    public static final TimestampData epochLimitTimestamp = new TimestampData(epochLimitSeconds);

    public DateTimeType(int n2, int n3, int n4) {
        super(n2, n3, 0L, n4);
        this.withTimeZone = n3 == 94 || n3 == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 94: {
                return 2013;
            }
            case 95: {
                return 2014;
            }
        }
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 94: {
                return Time.class;
            }
            case 95: {
                return Timestamp.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 94: {
                return "java.sql.Time";
            }
            case 95: {
                return "java.sql.Timestamp";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(Type type) {
        return this.typeCode == type.typeCode;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String string;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                string = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                string = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(string);
        stringBuilder.append('(');
        stringBuilder.append(this.scale);
        stringBuilder.append(')');
        if (this.withTimeZone) {
            stringBuilder.append(" WITH TIME ZONE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimestampType() {
        switch (this.typeCode) {
            case 93: 
            case 95: {
                return true;
            }
            case 91: 
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimeType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return false;
            }
            case 92: 
            case 94: {
                return true;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type type) {
        int n2;
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? this : type;
        }
        if (type.typeCode == 0) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = (DateTimeType)type;
        if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
            throw Error.error(5562);
        }
        int n3 = this.typeCode;
        int n4 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
        boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
        int n5 = n2 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
        n3 = n2 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
        return DateTimeType.getDateTimeType(n3, n4);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        switch (n2) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n3;
                if (this.typeCode == type.typeCode) {
                    return this;
                }
                if (type.typeCode == 0) {
                    return this;
                }
                if (!type.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType dateTimeType = (DateTimeType)type;
                if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
                    throw Error.error(5562);
                }
                int n4 = this.typeCode;
                int n5 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
                boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
                int n6 = n3 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
                n4 = n3 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
                return DateTimeType.getDateTimeType(n4, n5);
            }
            case 32: 
            case 33: {
                if (type.isIntervalType()) {
                    if (this.typeCode != 91 && type.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, type.scale);
                    }
                    return this;
                }
                if (type.isDateTimeType()) {
                    if (n2 != 33 || type.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!type.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = ((TimeData)object).getSeconds() - ((TimeData)object2).getSeconds();
                if (l2 == 0L) {
                    l2 = ((TimeData)object).getNanos() - ((TimeData)object2).getNanos();
                }
                return l2 == 0L ? 0 : (l2 > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long l3 = ((TimestampData)object).getSeconds() - ((TimestampData)object2).getSeconds();
                if (l3 == 0L) {
                    l3 = ((TimestampData)object).getNanos() - ((TimestampData)object2).getNanos();
                }
                return l3 == 0L ? 0 : (l3 > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return object;
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n2 = timeData.getNanos();
                int n3 = this.scaleNanos(n2);
                if (n3 == n2) {
                    return timeData;
                }
                return new TimeData(timeData.getSeconds(), n3, timeData.getZone());
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                int n4 = timestampData.getNanos();
                int n5 = this.scaleNanos(n4);
                if (timestampData.getSeconds() > epochLimitSeconds) {
                    throw Error.error(3408);
                }
                if (n5 == n4) {
                    return timestampData;
                }
                return new TimestampData(timestampData.getSeconds(), n5, timestampData.getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int n2) {
        int n3 = nanoScaleFactors[this.scale];
        return n2 / n3 * n3;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
                        }
                        catch (HsqlException hsqlException) {
                            return DateTimeType.convertToDatetimeSpecial(sessionInterface, (String)object, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (type.typeCode) {
                    case 91: {
                        return object;
                    }
                    case 95: {
                        long l2 = ((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone();
                        long l3 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l2 * 1000L);
                        return new TimestampData(l3 / 1000L);
                    }
                    case 93: {
                        long l4 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), ((TimestampData)object).getSeconds() * 1000L);
                        return new TimestampData(l4 / 1000L);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (type.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() - sessionInterface.getZoneSeconds(), this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l5 = HsqlDateTime.convertToNormalisedTime(timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l5, this.scaleNanos(timestampData.getNanos()), timestampData.getZone());
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l6 = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        l6 = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), l6 * 1000L) / 1000L;
                        return new TimeData((int)l6, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() + timeData.getZone(), this.scaleNanos(timeData.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l7 = timestampData.getSeconds() + (long)timestampData.getZone();
                        l7 = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), l7 * 1000L) / 1000L;
                        return new TimeData((int)l7, this.scaleNanos(timestampData.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l8 = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l8, this.scaleNanos(timestampData.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l9 = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l9, this.scaleNanos(timeData.getNanos()), timeData.getZone());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l10 = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l10, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l11 = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l11, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData timestampData = (TimestampData)object;
                        return new TimestampData(timestampData.getSeconds(), 0, sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l12 = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l12, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l13 = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l13, this.scaleNanos(timeData.getNanos()));
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l14 = timestampData.getSeconds() + (long)timestampData.getZone();
                        return new TimestampData(l14, this.scaleNanos(timestampData.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 91: {
                        return object;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        DateTimeType dateTimeType = object instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(sessionInterface, object, dateTimeType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object instanceof Date) break;
                if (object instanceof java.util.Date) {
                    long l2;
                    int n2 = 0;
                    int n3 = 0;
                    if (this.typeCode == 92) {
                        l2 = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                    } else {
                        l2 = ((java.util.Date)object).getTime();
                        n3 = sessionInterface.getZoneSeconds();
                    }
                    l2 = HsqlDateTime.getNormalisedTime(sessionInterface.getCalendarGMT(), l2);
                    if (object instanceof Timestamp) {
                        n2 = ((Timestamp)object).getNanos();
                        n2 = DateTimeType.normaliseFraction(n2, this.scale);
                    }
                    return new TimeData((int)l2 / 1000, n2, n3);
                }
                TimeData timeData = this.convertJavaTimeObject(sessionInterface, object);
                if (timeData == null) break;
                return timeData;
            }
            case 91: {
                if (object instanceof Time) break;
                if (object instanceof java.util.Date) {
                    long l3 = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                    l3 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l3);
                    long l4 = l3 / 1000L;
                    if (l4 < epochSeconds || l4 > epochLimitSeconds) {
                        throw Error.error(3408);
                    }
                    return new TimestampData(l4);
                }
                TimestampData timestampData = this.convertJavaDateTimeObject(sessionInterface, object);
                if (timestampData == null) break;
                return timestampData;
            }
            case 93: 
            case 95: {
                if (object instanceof Time) break;
                if (object instanceof java.util.Date) {
                    int n4;
                    long l5;
                    long l6 = ((java.util.Date)object).getTime();
                    int n5 = 0;
                    if (this.typeCode == 93) {
                        l6 = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), l6);
                        if (object instanceof Date) {
                            l6 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l6);
                        }
                    } else {
                        if (object instanceof Date) {
                            l6 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l6);
                        }
                        n5 = HsqlDateTime.getZoneMillis(sessionInterface.getCalendar(), l6) / 1000;
                    }
                    if ((l5 = l6 / 1000L) < epochSeconds || l5 > epochLimitSeconds) {
                        throw Error.error(3408);
                    }
                    if (object instanceof Timestamp) {
                        n4 = ((Timestamp)object).getNanos();
                        n4 = DateTimeType.normaliseFraction(n4, this.scale);
                    } else {
                        n4 = DateTimeType.normaliseFraction((int)(l6 % 1000L) * 1000000, this.scale);
                    }
                    return new TimestampData(l5, n4, n5);
                }
                TimestampData timestampData = this.convertJavaDateTimeObject(sessionInterface, object);
                if (timestampData == null) break;
                return timestampData;
            }
        }
        throw Error.error(5561);
    }

    TimestampData convertJavaDateTimeObject(SessionInterface sessionInterface, Object object) {
        return null;
    }

    TimeData convertJavaTimeObject(SessionInterface sessionInterface, Object object) {
        return null;
    }

    public Object convertSQLToJavaGMT(SessionInterface sessionInterface, Object object) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l2 = (long)((TimeData)object).getSeconds() * 1000L;
                return new Time(l2 += (long)(((TimeData)object).getNanos() / 1000000));
            }
            case 91: {
                long l3 = ((TimestampData)object).getSeconds() * 1000L;
                return new Date(l3);
            }
            case 93: 
            case 95: {
                long l4 = ((TimestampData)object).getSeconds() * 1000L;
                Timestamp timestamp = new Timestamp(l4);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar calendar = sessionInterface.getCalendar();
                long l2 = HsqlDateTime.convertMillisToCalendar(calendar, ((TimeData)object).getMillis());
                l2 = HsqlDateTime.getNormalisedTime(calendar, l2);
                Time time = new Time(l2);
                return time;
            }
            case 94: {
                long l3 = ((TimeData)object).getMillis();
                return new Time(l3);
            }
            case 91: {
                Calendar calendar = sessionInterface.getCalendar();
                long l4 = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getMillis());
                Date date = new Date(l4);
                return date;
            }
            case 93: {
                Calendar calendar = sessionInterface.getCalendar();
                long l5 = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getMillis());
                Timestamp timestamp = new Timestamp(l5);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
            case 95: {
                long l6 = ((TimestampData)object).getMillis();
                Timestamp timestamp = new Timestamp(l6);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static int normaliseTime(int n2) {
        while (n2 < 0) {
            n2 += 86400;
        }
        if (n2 >= 86400) {
            n2 %= 86400;
        }
        return n2;
    }

    @Override
    public String convertToString(Object object) {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)object).getSeconds());
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n2 = DateTimeType.normaliseTime(timeData.getSeconds() + timeData.getZone());
                String string = this.intervalSecondToString(n2, timeData.getNanos(), false);
                if (!this.withTimeZone) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                string = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)object).getZone(), 0, true);
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                String string = HsqlDateTime.getTimestampString(timestampData.getSeconds() + (long)timestampData.getZone(), timestampData.getNanos(), this.scale);
                if (this.withTimeZone) {
                    String string2 = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)object).getZone(), 0, true);
                    string = string + string2;
                }
                return string;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        switch (this.typeCode) {
            case 91: {
                stringBuilder.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                stringBuilder.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                stringBuilder.append("TIMESTAMP");
            }
        }
        stringBuilder.append(StringConverter.toQuotedString(this.convertToString(object), '\'', false));
        return stringBuilder.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (!type.isDateTimeType()) {
            return false;
        }
        if (type.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (type.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, ((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, -((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static double convertToDouble(Object object) {
        double d2;
        double d3;
        if (object instanceof TimeData) {
            d3 = ((TimeData)object).getSeconds();
            d2 = (double)((TimeData)object).getNanos() / 1.0E9;
        } else {
            d3 = ((TimestampData)object).getSeconds();
            d2 = (double)((TimestampData)object).getNanos() / 1.0E9;
        }
        return d3 + d2;
    }

    public Object convertFromDouble(Session session, double d2) {
        long l2 = (long)d2;
        int n2 = (int)((d2 - (double)l2) * 1.0E9);
        return this.getValue(session, l2, n2, 0);
    }

    public Object truncate(Session session, Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.getMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l2 = HsqlDateTime.getTruncatedPart(calendar, l2, n2);
        l2 -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 94: {
                l2 = HsqlDateTime.getNormalisedTime(calendar, l2);
            }
            case 92: {
                return new TimeData((int)(l2 / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l2 / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Session session, Object object, int n2) {
        if (object == null) {
            return null;
        }
        long l2 = this.getMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l2 = HsqlDateTime.getRoundedPart(calendar, l2, n2);
        l2 -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                l2 = HsqlDateTime.getNormalisedTime(l2);
                return new TimeData((int)(l2 / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l2 / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateTimeType) {
            return super.equals(object) && ((DateTimeType)object).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object object, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 1;
        switch (n2) {
            case 101: {
                n3 = 1;
                break;
            }
            case 102: {
                n4 = 1;
                n3 = 2;
                break;
            }
            case 103: 
            case 124: {
                n3 = 5;
                break;
            }
            case 104: {
                n3 = 11;
                break;
            }
            case 105: {
                n3 = 12;
                break;
            }
            case 106: {
                n3 = 13;
                break;
            }
            case 123: {
                n3 = 7;
                break;
            }
            case 126: 
            case 136: {
                n3 = 3;
                break;
            }
            case 130: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType dateTimeType = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        object = dateTimeType.castToType(session, object, this);
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
                return ((TimeData)object).getSeconds();
            }
            case 121: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 3600;
                }
                return ((TimeData)object).getZone() / 3600;
            }
            case 122: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 60 % 60;
                }
                return ((TimeData)object).getZone() / 60 % 60;
            }
            case 135: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 60;
                }
                return ((TimeData)object).getZone() / 60;
            }
            case 127: {
                n4 = 1;
                n5 = 3;
                n3 = 2;
                break;
            }
            case 125: {
                n3 = 6;
                break;
            }
            case 132: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).getNanos() / 1000000;
                }
                return ((TimeData)object).getNanos() / 1000000;
            }
            case 134: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).getNanos();
                }
                return ((TimeData)object).getNanos();
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + n2);
            }
        }
        long l2 = this.getMillis(object);
        return HsqlDateTime.getDateTimePart(session.getCalendarGMT(), l2, n3) / n5 + n4;
    }

    public Object addMonthsSpecial(Session session, Object object, int n2) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l2 = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        boolean bl = l2 == calendar.getTimeInMillis();
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.add(2, n2);
        if (bl) {
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
        }
        l2 = calendar.getTimeInMillis();
        return new TimestampData(l2 / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(Session session, Object object) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l2 = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        l2 = calendar.getTimeInMillis();
        return new TimestampData(l2 / 1000L, 0, 0);
    }

    long getMillis(Object object) {
        long l2 = this.typeCode == 92 || this.typeCode == 94 ? (long)(((TimeData)object).getSeconds() + ((TimeData)object).getZone()) * 1000L : (((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone()) * 1000L;
        return l2;
    }

    long getZoneMillis(Object object) {
        long l2 = this.typeCode == 92 || this.typeCode == 94 ? (long)((TimeData)object).getZone() * 1000L : (long)((TimestampData)object).getZone() * 1000L;
        return l2;
    }

    @Override
    public BigDecimal getSecondPart(Session session, Object object) {
        long l2 = this.getPart(session, object, 106);
        int n2 = 0;
        if (this.typeCode == 93 || this.typeCode == 95) {
            n2 = ((TimestampData)object).getNanos();
        } else if (this.typeCode == 92 || this.typeCode == 94) {
            n2 = ((TimeData)object).getNanos();
        }
        return this.getSecondPart(l2, n2);
    }

    public String getPartString(Session session, Object object, int n2) {
        String string = "";
        switch (n2) {
            case 128: {
                string = "EEEE";
                break;
            }
            case 129: {
                string = "MMMM";
            }
        }
        SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
        try {
            simpleDateFormat.applyPattern(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, object);
        return simpleDateFormat.format(date);
    }

    public Object getValue(Session session, long l2, int n2, int n3) {
        Calendar calendar = session.getCalendarGMT();
        switch (this.typeCode) {
            case 91: {
                l2 = HsqlDateTime.getNormalisedDate(calendar, (l2 + (long)n3) * 1000L) / 1000L;
                return new TimestampData(l2);
            }
            case 94: {
                l2 = HsqlDateTime.getNormalisedDate(calendar, l2 * 1000L) / 1000L;
                return new TimeData((int)l2, n2, n3);
            }
            case 92: {
                l2 = HsqlDateTime.getNormalisedTime(calendar, (l2 + (long)n3) * 1000L) / 1000L;
                return new TimeData((int)l2, n2);
            }
            case 95: {
                return new TimestampData(l2, n2, n3);
            }
            case 93: {
                return new TimestampData(l2 + (long)n3, n2);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public DateTimeType getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            DateTimeType dateTimeType;
            switch (this.typeCode) {
                case 94: {
                    dateTimeType = new DateTimeType(92, 92, this.scale);
                    break;
                }
                case 95: {
                    dateTimeType = new DateTimeType(93, 93, this.scale);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "DateTimeType");
                }
            }
            dateTimeType.nameString = this.nameString;
            return dateTimeType;
        }
        return this;
    }

    public static DateTimeType getDateTimeType(int n2, int n3) {
        if (n3 > 9) {
            throw Error.error(5592);
        }
        switch (n2) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (n3 == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, n2, n3);
            }
            case 94: {
                if (n3 == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, n2, n3);
            }
            case 93: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP;
                }
                if (n3 == 0) {
                    return SQL_TIMESTAMP_NO_FRACTION;
                }
                return new DateTimeType(93, n2, n3);
            }
            case 95: {
                if (n3 == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(93, n2, n3);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static Object changeZoneToUTC(Object object) {
        Object object2;
        if (object instanceof TimestampData && ((TimestampData)(object2 = (TimestampData)object)).getZone() != 0) {
            return new TimestampData(((TimestampData)object2).seconds, ((TimestampData)object2).nanos);
        }
        if (object instanceof TimeData && ((TimeData)(object2 = (TimeData)object)).getZone() != 0) {
            return new TimeData(((TimeData)object2).seconds, ((TimeData)object2).nanos);
        }
        return object;
    }

    public Object changeZone(Session session, Object object, Type type, int n2, int n3) {
        Calendar calendar = session.getCalendarGMT();
        if (object == null) {
            return null;
        }
        if (n2 > 50400 || -n2 > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData timeData = (TimeData)object;
                if (type.isDateTimeTypeWithZone()) {
                    if (timeData.zone == n2) break;
                    return new TimeData(timeData.getSeconds(), timeData.getNanos(), n2);
                }
                int n4 = timeData.getSeconds() - n3;
                n4 = (int)(HsqlDateTime.getNormalisedTime(calendar, (long)n4 * 1000L) / 1000L);
                return new TimeData(n4, timeData.getNanos(), n2);
            }
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                long l2 = timestampData.getSeconds();
                if (!type.isDateTimeTypeWithZone()) {
                    l2 -= (long)n3;
                }
                if (timestampData.getSeconds() == l2 && timestampData.zone == n2) break;
                return new TimestampData(l2, timestampData.getNanos(), n2);
            }
        }
        return object;
    }

    public boolean canAdd(IntervalType intervalType) {
        return intervalType.startPartIndex >= this.startPartIndex && intervalType.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Type normalizeInput(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            return null;
        }
        if (!bl && objectArray2[1] == null) {
            return null;
        }
        if (!typeArray[0].isDateTimeType() || !typeArray2[0].isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = SQL_TIMESTAMP_WITH_TIME_ZONE;
        objectArray[0] = dateTimeType.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = dateTimeType.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray[0], objectArray[1], typeArray[1]) : dateTimeType.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : (bl ? objectArray2[0] : dateTimeType.castToType(session, objectArray2[1], typeArray2[1]));
        if (((Type)dateTimeType).compare(session, objectArray[0], objectArray[1]) >= 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (!bl && ((Type)dateTimeType).compare(session, objectArray2[0], objectArray2[1]) >= 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return dateTimeType;
    }

    public static Type normalizeInputRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            objectArray[1] = objectArray[0];
        }
        if (objectArray2[1] == null) {
            objectArray2[1] = objectArray2[0];
        }
        Type type = typeArray[0].getCombinedType(session, typeArray2[0], 40);
        objectArray[0] = type.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = type.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? type.add(session, objectArray[0], objectArray[1], typeArray[1]) : type.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? type.add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : type.castToType(session, objectArray2[1], typeArray2[1]);
        if (type.compare(session, objectArray[0], objectArray[1]) > 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (type.compare(session, objectArray2[0], objectArray2[1]) > 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return type;
    }

    public static Boolean overlaps(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean overlapsRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInputRelaxed(session, objectArray, typeArray, objectArray2, typeArray2);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean precedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelyPrecedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelySucceeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean succeeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean equals(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) == 0 && type.compare(session, objectArray[1], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean contains(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, bl);
        if (type == null) {
            return null;
        }
        int n2 = type.compare(session, objectArray[0], objectArray2[0]);
        int n3 = type.compare(session, objectArray[1], objectArray2[1]);
        if (n2 <= 0 && n3 >= 0) {
            if (bl && n3 == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(Session session, TimestampData timestampData, TimestampData timestampData2) {
        long l2 = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        long l3 = (timestampData2.getSeconds() + (long)timestampData2.getZone()) * 1000L;
        boolean bl = false;
        if (l2 < l3) {
            bl = true;
            long l4 = l2;
            l2 = l3;
            l3 = l4;
        }
        l2 = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), l2);
        l3 = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), l3);
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(2) + calendar.get(1) * 12;
        int n3 = calendar.get(5);
        calendar.set(5, 1);
        long l5 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l5 = calendar.getTimeInMillis();
        int n4 = calendar.get(5);
        calendar.setTimeInMillis(l3);
        int n5 = calendar.get(2) + calendar.get(1) * 12;
        int n6 = calendar.get(5);
        calendar.set(5, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l5 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l5 = calendar.getTimeInMillis();
        int n7 = calendar.get(5);
        if (n3 == n6 || n3 == n4 && n6 == n7) {
            double d2 = n2 - n5;
            if (bl) {
                d2 = -d2;
            }
            return BigDecimal.valueOf(d2);
        }
        if (n6 > n3) {
            double d3 = n2 - n5 - 1;
            double d4 = n7 - n6 + n3;
            d3 += d4 / 31.0;
            if (bl) {
                d3 = -d3;
            }
            return BigDecimal.valueOf(d3);
        }
        double d5 = n2 - n5;
        double d6 = n3 - n6;
        d5 += d6 / 31.0;
        if (bl) {
            d5 = -d5;
        }
        return BigDecimal.valueOf(d5);
    }

    public static int subtractMonths(Session session, TimestampData timestampData, TimestampData timestampData2, boolean bl) {
        Calendar calendar = session.getCalendarGMT();
        boolean bl2 = false;
        if (timestampData2.getSeconds() > timestampData.getSeconds()) {
            bl2 = true;
            TimestampData timestampData3 = timestampData;
            timestampData = timestampData2;
            timestampData2 = timestampData3;
        }
        calendar.setTimeInMillis(timestampData.getSeconds() * 1000L);
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        calendar.setTimeInMillis(timestampData2.getSeconds() * 1000L);
        n2 -= calendar.get(2);
        n3 -= calendar.get(1);
        if (bl) {
            n2 = n3 * 12;
        } else {
            if (n2 < 0) {
                n2 += 12;
                --n3;
            }
            n2 += n3 * 12;
        }
        if (bl2) {
            n2 = -n2;
        }
        return n2;
    }

    public static TimeData addSeconds(TimeData timeData, long l2, int n2) {
        l2 += (long)((n2 += timeData.getNanos()) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        l2 += (long)timeData.getSeconds();
        TimeData timeData2 = new TimeData((int)(l2 %= 86400L), n2, timeData.getZone());
        return timeData2;
    }

    public static TimestampData addMonths(Session session, TimestampData timestampData, int n2) {
        int n3 = timestampData.getNanos();
        Calendar calendar = session.getCalendarGMT();
        HsqlDateTime.setTimeInMillis(calendar, timestampData.getSeconds() * 1000L);
        calendar.add(2, n2);
        TimestampData timestampData2 = new TimestampData(calendar.getTimeInMillis() / 1000L, n3, timestampData.getZone());
        return timestampData2;
    }

    public static TimestampData addSeconds(TimestampData timestampData, long l2, int n2) {
        l2 += (long)((n2 += timestampData.getNanos()) / 1000000000);
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --l2;
        }
        long l3 = timestampData.getSeconds() + l2;
        TimestampData timestampData2 = new TimestampData(l3, n2, timestampData.getZone());
        return timestampData2;
    }

    public static TimestampData convertToDatetimeSpecial(SessionInterface sessionInterface, String string, DateTimeType dateTimeType) {
        switch (dateTimeType.typeCode) {
            case 93: {
                String string2;
                if (!(sessionInterface instanceof Session) || !((Session)sessionInterface).database.sqlSyntaxOra) break;
                switch (string.length()) {
                    case 8: 
                    case 9: {
                        string2 = "DD-MON-YY";
                        break;
                    }
                    case 10: 
                    case 11: {
                        string2 = "DD-MON-YYYY";
                        break;
                    }
                    case 19: 
                    case 20: {
                        string2 = "DD-MON-YYYY HH24:MI:SS";
                        break;
                    }
                    default: {
                        string2 = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                }
                SimpleDateFormat simpleDateFormat = sessionInterface.getSimpleDateFormatGMT();
                return HsqlDateTime.toDate(string, string2, simpleDateFormat, true);
            }
        }
        throw Error.error(3407);
    }

    public static TimestampData nextDayOfWeek(Session session, TimestampData timestampData, int n2) {
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(timestampData.getMillis());
        int n3 = calendar.get(7);
        if (n3 >= n2) {
            n2 += 7;
        }
        int n4 = n2 - n3;
        calendar.add(5, n4);
        long l2 = calendar.getTimeInMillis();
        l2 = HsqlDateTime.getNormalisedDate(calendar, l2);
        return new TimestampData(l2 / 1000L);
    }

    public static int getDayOfWeek(String string) {
        if (string.length() > 0) {
            char c2 = Character.toUpperCase(string.charAt(0));
            switch (c2) {
                case 'M': {
                    return 2;
                }
                case 'T': {
                    if (string.length() < 2) break;
                    if (Character.toUpperCase(string.charAt(1)) == 'U') {
                        return 3;
                    }
                    if (Character.toUpperCase(string.charAt(1)) != 'H') break;
                    return 5;
                }
                case 'W': {
                    return 4;
                }
                case 'F': {
                    return 6;
                }
                case 'S': {
                    if (string.length() < 2) break;
                    if (Character.toUpperCase(string.charAt(1)) == 'A') {
                        return 7;
                    }
                    if (Character.toUpperCase(string.charAt(1)) != 'U') break;
                    return 1;
                }
            }
        }
        throw Error.error(3407, string);
    }
}

