/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Clob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class ClobType
extends CharacterType {
    public static final long maxClobPrecision = 0x10000000000L;
    public static final int defaultClobSize = 0x40000000;
    public static final int defaultShortClobSize = 0x1000000;

    public ClobType(long l2) {
        super(40, l2);
    }

    public ClobType(Collation collation, long l2) {
        super(collation, 40, l2);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2005;
    }

    @Override
    public Class getJDBCClass() {
        return Clob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Clob";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getDefinition() {
        long l2 = this.precision;
        String string = null;
        if (this.precision % 1024L == 0L) {
            if (this.precision % 0x40000000L == 0L) {
                l2 = this.precision / 0x40000000L;
                string = "G";
            } else if (this.precision % 0x100000L == 0L) {
                l2 = this.precision / 0x100000L;
                string = "M";
            } else {
                l2 = this.precision / 1024L;
                string = "K";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(this.getNameString());
        stringBuilder.append('(');
        stringBuilder.append(l2);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        return this.compare(session, object, object2, 40);
    }

    @Override
    public int compare(Session session, Object object, Object object2, int n2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof String) {
            long l2 = ((ClobData)object).getId();
            return session.database.lobManager.compare(this.collation, l2, (String)object2);
        }
        return session.database.lobManager.compare(this.collation, (ClobData)object, (ClobData)object2);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClobData) {
            return object;
        }
        if (object instanceof String) {
            ClobDataID clobDataID = sessionInterface.createClob(((String)object).length());
            clobDataID.setString(sessionInterface, 0L, (String)object);
            return clobDataID;
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return Long.toString(((ClobData)object).getId());
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return this.convertToString(object);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JDBCClobClient) {
            return ((JDBCClobClient)object).getClob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            ClobDataID clobDataID = (ClobDataID)object;
            return new JDBCClobClient(sessionInterface, clobDataID);
        }
        throw Error.error(5561);
    }

    @Override
    public long position(SessionInterface sessionInterface, Object object, Object object2, Type type, long l2) {
        if (type.typeCode == 40) {
            return ((ClobData)object).position(sessionInterface, (ClobData)object2, l2);
        }
        if (type.isCharacterType()) {
            return ((ClobData)object).position(sessionInterface, (String)object2, l2);
        }
        throw Error.runtimeError(201, "ClobType");
    }
}

