/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.ClobData;

public final class ClobInputStream
extends Reader {
    final ClobData clob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public final SessionInterface session;

    public ClobInputStream(SessionInterface sessionInterface, ClobData clobData, long l2, long l3) {
        long l4 = clobData.length(sessionInterface);
        this.session = sessionInterface;
        this.clob = clobData;
        this.availableLength = l2 + Math.min(l3, l4 - l2);
        this.currentPosition = l2;
        this.streamBlockSize = sessionInterface.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception exception) {
                throw JavaSystem.toIOException(exception);
            }
        }
        char c2 = this.buffer[(int)(this.currentPosition - this.bufferOffset)];
        ++this.currentPosition;
        return c2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.currentPosition + (long)n3 > this.availableLength) {
            n3 = (int)(this.availableLength - this.currentPosition);
        }
        for (int i2 = n2; i2 < n2 + n3 && i2 < cArray.length; ++i2) {
            cArray[i2] = (char)this.read();
        }
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l2 > this.availableLength) {
            l2 = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l2;
        return l2;
    }

    public int available() {
        long l2 = this.availableLength - this.currentPosition;
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(Error.getMessage(1853));
        }
    }

    private void readIntoBuffer() {
        long l2 = this.availableLength - this.currentPosition;
        if (l2 <= 0L) {
            return;
        }
        if (l2 > (long)this.streamBlockSize) {
            l2 = this.streamBlockSize;
        }
        this.buffer = this.clob.getChars(this.session, this.currentPosition, (int)l2);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }
}

