/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.BlobData;

public class BlobInputStream
extends InputStream {
    final BlobData blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public final SessionInterface session;

    public BlobInputStream(SessionInterface sessionInterface, BlobData blobData, long l2, long l3) {
        long l4 = blobData.length(sessionInterface);
        this.session = sessionInterface;
        this.blob = blobData;
        this.availableLength = l2 + Math.min(l3, l4 - l2);
        this.currentPosition = l2;
        this.streamBlockSize = sessionInterface.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception exception) {
                throw JavaSystem.toIOException(exception);
            }
        }
        int n2 = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l2 > this.availableLength) {
            l2 = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l2;
        return l2;
    }

    @Override
    public int available() {
        long l2 = this.availableLength - this.currentPosition;
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.blob.isClosed()) {
            throw new IOException(Error.getMessage(1853));
        }
    }

    private void readIntoBuffer() {
        long l2 = this.availableLength - this.currentPosition;
        if (l2 <= 0L) {
            return;
        }
        if (l2 > (long)this.streamBlockSize) {
            l2 = this.streamBlockSize;
        }
        this.buffer = this.blob.getBytes(this.session, this.currentPosition, (int)l2);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }
}

