/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.InputStream;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;

    public BlobDataID(long l2) {
        this.id = l2;
    }

    @Override
    public BlobData duplicate(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobDuplicateRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            HsqlException hsqlException = result.getException();
            if (hsqlException == null) {
                hsqlException = new HsqlException(result);
            }
            throw hsqlException;
        }
        long l2 = ((ResultLob)result).getLobID();
        return new BlobDataID(l2);
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface) {
        long l2 = this.length(sessionInterface);
        return new BlobInputStream(sessionInterface, this, 0L, l2);
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface, long l2, long l3) {
        return new BlobInputStream(sessionInterface, this, l2, l3);
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface sessionInterface, long l2, int n2) {
        ResultLob resultLob;
        Result result;
        long l3 = this.length(sessionInterface);
        if (l2 >= l3) {
            return new byte[0];
        }
        if (l2 + (long)n2 >= l3) {
            n2 = (int)(l3 - l2);
        }
        if ((result = sessionInterface.execute(resultLob = ResultLob.newLobGetBytesRequest(this.id, l2, n2))).isError()) {
            throw Error.error(result);
        }
        return ((ResultLob)result).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface sessionInterface, long l2, long l3) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l2, l3);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw Error.error(result);
        }
        long l4 = ((ResultLob)result).getLobID();
        return new BlobDataID(l4);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
        return this.length;
    }

    @Override
    public long bitLength(SessionInterface sessionInterface) {
        return this.length(sessionInterface) * 8L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, long l2) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, blobData.getId(), l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, byte[] byArray, long l2) {
        ResultLob resultLob = ResultLob.newLobGetBytePatternPositionRequest(this.id, byArray, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, byte[] object, int n2, int n3) {
        Result result;
        Object object2;
        if (n2 != 0 || n3 != ((byte[])object).length) {
            if (!BinaryData.isInLimits(((byte[])object).length, n2, n3)) {
                throw new IndexOutOfBoundsException();
            }
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
        }
        if ((result = sessionInterface.execute((Result)(object2 = ResultLob.newLobSetBytesRequest(this.id, l2, object)))).isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, byte[] byArray) {
        this.setBytes(sessionInterface, l2, byArray, 0, byArray.length);
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, BlobData blobData, long l3, long l4) {
        if (l4 > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = blobData.getBytes(sessionInterface, l3, (int)l4);
        this.setBytes(sessionInterface, l2, byArray, 0, byArray.length);
    }

    @Override
    public void setBinaryStream(SessionInterface sessionInterface, long l2, InputStream inputStream) {
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l2) {
        if (l2 >= this.length(sessionInterface)) {
            return;
        }
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BlobDataID) {
            return this.id == ((BlobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

