/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowOutputText;

public class RowOutputTextQuoted
extends RowOutputText {
    public RowOutputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
    }

    @Override
    protected String checkConvertString(String string, String string2) {
        if (this.textFileSettings.isAllQuoted || string.length() == 0 || string.indexOf(this.textFileSettings.quoteChar) != -1 || string2.length() > 0 && string.contains(string2) || RowOutputTextQuoted.hasUnprintable(string)) {
            string = StringConverter.toQuotedString(string, this.textFileSettings.quoteChar, true);
        }
        return string;
    }

    private static boolean hasUnprintable(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isISOControl(string.charAt(i2))) continue;
            return true;
        }
        return false;
    }
}

