/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputBinary180
extends RowOutputBinary {
    Calendar tempCalDefault = new GregorianCalendar();

    public RowOutputBinary180(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        long l2 = timestampData.getSeconds() * 1000L;
        l2 = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, l2);
        this.writeLong(l2);
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        if (type.typeCode == 92) {
            long l2 = (long)timeData.getSeconds() * 1000L;
            l2 = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, l2);
            this.writeLong(l2);
        } else {
            this.writeInt(timeData.getSeconds());
            this.writeInt(timeData.getNanos());
            this.writeInt(timeData.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        if (type.typeCode == 93) {
            long l2 = timestampData.getSeconds() * 1000L;
            l2 = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, l2);
            this.writeLong(l2);
            this.writeInt(timestampData.getNanos());
        } else {
            this.writeLong(timestampData.getSeconds());
            this.writeInt(timestampData.getNanos());
            this.writeInt(timestampData.getZone());
        }
    }
}

