/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;

public final class UserManager {
    private OrderedHashMap userList;
    private GranteeManager granteeManager;
    Routine pwCheckFunction;
    Routine extAuthenticationFunction;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new OrderedHashMap();
    }

    public User createUser(Session session, HsqlNameManager.HsqlName hsqlName, String string, boolean bl) {
        User user2 = this.granteeManager.addUser(hsqlName);
        if (session == null) {
            user2.setPassword(string, bl);
        } else {
            try {
                this.setPassword(session, user2, string, bl);
            }
            catch (HsqlException hsqlException) {
                this.granteeManager.removeNewUser(hsqlName);
                throw hsqlException;
            }
        }
        this.userList.add(hsqlName.name, user2);
        return user2;
    }

    public void setPassword(Session session, User user2, String string, boolean bl) {
        if (!bl && !this.checkComplexity(session, string)) {
            throw Error.error(391);
        }
        user2.setPassword(string, bl);
    }

    public boolean checkComplexity(Session session, String string) {
        if (session == null || this.pwCheckFunction == null) {
            return true;
        }
        Result result = this.pwCheckFunction.invoke(session, new Object[]{string}, null, true);
        Boolean bl = (Boolean)result.getValueObject();
        return bl != null && bl != false;
    }

    public void dropUser(String string) {
        boolean bl = GranteeManager.isReserved(string);
        if (bl) {
            throw Error.error(4002, string);
        }
        boolean bl2 = this.granteeManager.removeGrantee(string);
        if (!bl2) {
            throw Error.error(4001, string);
        }
        User user2 = (User)this.userList.remove(string);
        if (user2 == null) {
            throw Error.error(4001, string);
        }
    }

    public void createFirstUser(String string, String string2) {
        boolean bl = true;
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string, bl, 11);
        User user2 = this.createUser(null, hsqlName, string2, false);
        user2.isLocalOnly = true;
        this.granteeManager.grant(hsqlName.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String string, String string2) {
        SchemaObject schemaObject;
        int n2;
        User user2;
        boolean bl;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = bl = (user2 = (User)this.userList.get(string)) != null && user2.isLocalOnly;
        if (this.extAuthenticationFunction == null || bl) {
            user2 = this.get(string);
            user2.checkPassword(string2);
            return user2;
        }
        Result result = this.extAuthenticationFunction.invokeJavaMethodDirect(new String[]{this.granteeManager.database.getNameString(), string, string2});
        if (result.isError()) {
            throw Error.error(4001, result.getMainString());
        }
        Object[] objectArray = (Object[])result.getValueObject();
        if (user2 == null) {
            HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string, true, 11);
            user2 = this.createUser(null, hsqlName, "", false);
            user2.isExternalOnly = true;
        }
        if (objectArray == null) {
            user2.updateAllRights();
            return user2;
        }
        user2.clearPrivileges();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            try {
                schemaObject = this.granteeManager.getRole((String)objectArray[n2]);
                user2.grant((Grantee)schemaObject);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        user2.updateAllRights();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            schemaObject = this.granteeManager.database.schemaManager.findSchema((String)objectArray[n2]);
            if (schemaObject == null) continue;
            user2.setInitialSchema(((Schema)schemaObject).getName());
            break;
        }
        return user2;
    }

    public OrderedHashMap getUsers() {
        return this.userList;
    }

    public boolean exists(String string) {
        return this.userList.get(string) != null;
    }

    public User get(String string) {
        User user2 = (User)this.userList.get(string);
        if (user2 == null) {
            throw Error.error(4001, string);
        }
        return user2;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList<User> hsqlArrayList = new HsqlArrayList<User>();
        boolean bl = session.isAdmin();
        String string = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return hsqlArrayList;
        }
        for (int i2 = 0; i2 < this.userList.size(); ++i2) {
            User user2 = (User)this.userList.get(i2);
            if (user2 == null) continue;
            String string2 = user2.getName().getNameString();
            if (bl) {
                hsqlArrayList.add(user2);
                continue;
            }
            if (!string.equals(string2)) continue;
            hsqlArrayList.add(user2);
        }
        return hsqlArrayList;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        for (int i2 = 0; i2 < this.userList.size(); ++i2) {
            User user2 = (User)this.userList.get(i2);
            HsqlNameManager.HsqlName hsqlName2 = user2.getInitialSchema();
            if (hsqlName2 == null || !hsqlName.equals(hsqlName2)) continue;
            user2.setInitialSchema(null);
        }
    }

    public void setPasswordCheckFunction(Routine routine) {
        this.pwCheckFunction = routine;
    }

    public void setExtAuthenticationFunction(Routine routine) {
        this.extAuthenticationFunction = routine;
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>(this.userList.size());
        for (int i2 = 0; i2 < this.userList.size(); ++i2) {
            HsqlNameManager.HsqlName hsqlName;
            User user2 = (User)this.userList.get(i2);
            if (user2.isSystem || (hsqlName = user2.getInitialSchema()) == null) continue;
            hsqlArrayList.add(user2.getInitialSchemaSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getAuthenticationSQL() {
        StringBuilder stringBuilder;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        if (this.pwCheckFunction != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("SET").append(' ').append("DATABASE");
            stringBuilder.append(' ').append("PASSWORD").append(' ');
            stringBuilder.append("CHECK").append(' ').append("FUNCTION");
            stringBuilder.append(' ');
            stringBuilder.append(this.pwCheckFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        if (this.extAuthenticationFunction != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("SET").append(' ').append("DATABASE");
            stringBuilder.append(' ').append("AUTHENTICATION").append(' ');
            stringBuilder.append("FUNCTION").append(' ');
            stringBuilder.append(this.extAuthenticationFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }
}

