/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.IOException;
import java.util.Arrays;
import org.hsqldb.ColumnBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Type;

public final class ResultMetaData {
    public static final int RESULT_METADATA = 1;
    public static final int SIMPLE_RESULT_METADATA = 2;
    public static final int UPDATE_RESULT_METADATA = 3;
    public static final int PARAM_METADATA = 4;
    public static final int GENERATED_INDEX_METADATA = 5;
    public static final int GENERATED_NAME_METADATA = 6;
    private int type;
    public String[] columnLabels;
    public Type[] columnTypes;
    private int columnCount;
    private int extendedColumnCount;
    public static final ResultMetaData emptyResultMetaData = ResultMetaData.newResultMetaData(0);
    public static final ResultMetaData emptyParamMetaData = ResultMetaData.newParameterMetaData(0);
    public int[] colIndexes;
    public ColumnBase[] columns;
    public byte[] paramModes;
    public byte[] paramNullable;

    private ResultMetaData(int n2) {
        this.type = n2;
    }

    public static ResultMetaData newResultMetaData(Type[] typeArray, String[] stringArray) {
        ResultMetaData resultMetaData = new ResultMetaData(1);
        resultMetaData.columnLabels = stringArray;
        resultMetaData.columnTypes = new Type[typeArray.length];
        resultMetaData.columnCount = typeArray.length;
        resultMetaData.extendedColumnCount = typeArray.length;
        ArrayUtil.copyArray(typeArray, resultMetaData.columnTypes, typeArray.length);
        return resultMetaData;
    }

    public static ResultMetaData newUpdateResultMetaData(Type[] typeArray) {
        ResultMetaData resultMetaData = new ResultMetaData(3);
        resultMetaData.columnTypes = new Type[typeArray.length];
        resultMetaData.columnCount = typeArray.length;
        resultMetaData.extendedColumnCount = typeArray.length;
        ArrayUtil.copyArray(typeArray, resultMetaData.columnTypes, typeArray.length);
        return resultMetaData;
    }

    public static ResultMetaData newSimpleResultMetaData(Type[] typeArray) {
        ResultMetaData resultMetaData = new ResultMetaData(2);
        resultMetaData.columnTypes = typeArray;
        resultMetaData.columnCount = typeArray.length;
        resultMetaData.extendedColumnCount = typeArray.length;
        return resultMetaData;
    }

    public static ResultMetaData newResultMetaData(int n2) {
        Type[] typeArray = new Type[n2];
        return ResultMetaData.newResultMetaData(typeArray, null, n2, n2);
    }

    public static ResultMetaData newSingleColumnMetaData(String string) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
        resultMetaData.columns[0] = new ColumnBase(null, null, null, string);
        resultMetaData.columns[0].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.prepareData();
        return resultMetaData;
    }

    public static ResultMetaData newDoubleColumnMetaData(String string, String string2) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(2);
        resultMetaData.columns[0] = new ColumnBase(null, null, null, string);
        resultMetaData.columns[0].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.columns[1] = new ColumnBase(null, null, null, string2);
        resultMetaData.columns[1].setType(Type.SQL_VARCHAR_DEFAULT);
        resultMetaData.prepareData();
        return resultMetaData;
    }

    public static ResultMetaData newResultMetaData(Type[] typeArray, int[] nArray, int n2, int n3) {
        ResultMetaData resultMetaData = new ResultMetaData(1);
        resultMetaData.columnLabels = new String[n2];
        resultMetaData.columns = new ColumnBase[n2];
        resultMetaData.columnTypes = typeArray;
        resultMetaData.colIndexes = nArray;
        resultMetaData.columnCount = n2;
        resultMetaData.extendedColumnCount = n3;
        return resultMetaData;
    }

    public static ResultMetaData newParameterMetaData(int n2) {
        ResultMetaData resultMetaData = new ResultMetaData(4);
        resultMetaData.columnTypes = new Type[n2];
        resultMetaData.columnLabels = new String[n2];
        resultMetaData.paramModes = new byte[n2];
        resultMetaData.paramNullable = new byte[n2];
        resultMetaData.columnCount = n2;
        resultMetaData.extendedColumnCount = n2;
        return resultMetaData;
    }

    public static ResultMetaData newGeneratedColumnsMetaData(int[] nArray, String[] stringArray) {
        if (nArray != null) {
            ResultMetaData resultMetaData = new ResultMetaData(5);
            resultMetaData.columnCount = nArray.length;
            resultMetaData.extendedColumnCount = nArray.length;
            resultMetaData.colIndexes = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                resultMetaData.colIndexes[i2] = nArray[i2] - 1;
            }
            return resultMetaData;
        }
        if (stringArray != null) {
            ResultMetaData resultMetaData = new ResultMetaData(6);
            resultMetaData.columnLabels = new String[stringArray.length];
            resultMetaData.columnCount = stringArray.length;
            resultMetaData.extendedColumnCount = stringArray.length;
            resultMetaData.columnLabels = stringArray;
            return resultMetaData;
        }
        return null;
    }

    public void prepareData() {
        if (this.columns != null) {
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                if (this.columnTypes[i2] != null) continue;
                this.columnTypes[i2] = this.columns[i2].getDataType();
            }
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getExtendedColumnCount() {
        return this.extendedColumnCount;
    }

    public void resetExtendedColumnCount() {
        this.extendedColumnCount = this.columnCount;
    }

    public Type[] getParameterTypes() {
        return this.columnTypes;
    }

    public String[] getGeneratedColumnNames() {
        return this.columnLabels;
    }

    public int[] getGeneratedColumnIndexes() {
        return this.colIndexes;
    }

    public boolean isTableColumn(int n2) {
        String string = this.columns[n2].getNameString();
        String string2 = this.columns[n2].getTableNameString();
        return string2 != null && string2.length() > 0 && string != null && string.length() > 0;
    }

    private static void decodeTableColumnAttrs(int n2, ColumnBase columnBase) {
        columnBase.setNullability((byte)(n2 & 3));
        columnBase.setIdentity((n2 & 4) != 0);
        columnBase.setWriteable((n2 & 8) != 0);
        columnBase.setSearchable((n2 & 0x10) != 0);
    }

    private static int encodeTableColumnAttrs(ColumnBase columnBase) {
        int n2 = columnBase.getNullability();
        if (columnBase.isIdentity()) {
            n2 |= 4;
        }
        if (columnBase.isWriteable()) {
            n2 |= 8;
        }
        if (columnBase.isSearchable()) {
            n2 |= 0x10;
        }
        return n2;
    }

    private void decodeParamColumnAttrs(int n2, int n3) {
        this.paramNullable[n3] = (byte)(n2 & 3);
        this.paramModes[n3] = (byte)(n2 >> 4 & 0xF);
    }

    private int encodeParamColumnAttrs(int n2) {
        int n3 = this.paramModes[n2] << 4;
        return n3 |= this.paramNullable[n2];
    }

    ResultMetaData(RowInputInterface rowInputInterface) throws IOException {
        this.type = rowInputInterface.readInt();
        this.columnCount = rowInputInterface.readInt();
        switch (this.type) {
            case 2: 
            case 3: {
                this.columnTypes = new Type[this.columnCount];
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    this.columnTypes[i2] = this.readDataTypeSimple(rowInputInterface);
                }
                return;
            }
            case 5: {
                this.colIndexes = new int[this.columnCount];
                for (int i3 = 0; i3 < this.columnCount; ++i3) {
                    this.colIndexes[i3] = rowInputInterface.readInt();
                }
                return;
            }
            case 6: {
                this.columnLabels = new String[this.columnCount];
                for (int i4 = 0; i4 < this.columnCount; ++i4) {
                    this.columnLabels[i4] = rowInputInterface.readString();
                }
                return;
            }
            case 4: {
                this.columnTypes = new Type[this.columnCount];
                this.columnLabels = new String[this.columnCount];
                this.paramModes = new byte[this.columnCount];
                this.paramNullable = new byte[this.columnCount];
                for (int i5 = 0; i5 < this.columnCount; ++i5) {
                    this.columnTypes[i5] = this.readDataType(rowInputInterface);
                    this.columnLabels[i5] = rowInputInterface.readString();
                    this.decodeParamColumnAttrs(rowInputInterface.readByte(), i5);
                }
                return;
            }
            case 1: {
                Object object;
                int n2;
                this.extendedColumnCount = rowInputInterface.readInt();
                this.columnTypes = new Type[this.extendedColumnCount];
                this.columnLabels = new String[this.columnCount];
                this.columns = new ColumnBase[this.columnCount];
                if (this.columnCount != this.extendedColumnCount) {
                    this.colIndexes = new int[this.columnCount];
                }
                for (n2 = 0; n2 < this.extendedColumnCount; ++n2) {
                    object = this.readDataType(rowInputInterface);
                    this.columnTypes[n2] = object;
                }
                for (n2 = 0; n2 < this.columnCount; ++n2) {
                    this.columnLabels[n2] = rowInputInterface.readString();
                    object = rowInputInterface.readString();
                    String string = rowInputInterface.readString();
                    String string2 = rowInputInterface.readString();
                    String string3 = rowInputInterface.readString();
                    ColumnBase columnBase = new ColumnBase((String)object, string, string2, string3);
                    columnBase.setType(this.columnTypes[n2]);
                    ResultMetaData.decodeTableColumnAttrs(rowInputInterface.readByte(), columnBase);
                    this.columns[n2] = columnBase;
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (n2 = 0; n2 < this.columnCount; ++n2) {
                        this.colIndexes[n2] = rowInputInterface.readInt();
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(201, "ResultMetaData");
    }

    Type readDataTypeSimple(RowInputInterface rowInputInterface) {
        boolean bl;
        int n2 = rowInputInterface.readType();
        boolean bl2 = bl = n2 == 50;
        if (bl) {
            n2 = rowInputInterface.readType();
            return Type.getDefaultArrayType(n2);
        }
        return Type.getDefaultType(n2);
    }

    Type readDataType(RowInputInterface rowInputInterface) {
        boolean bl;
        int n2 = rowInputInterface.readType();
        boolean bl2 = bl = n2 == 50;
        if (bl) {
            n2 = rowInputInterface.readType();
        }
        long l2 = rowInputInterface.readLong();
        int n3 = rowInputInterface.readInt();
        Type type = Type.getType(n2, Type.SQL_VARCHAR.getCharacterSet(), Type.SQL_VARCHAR.getCollation(), l2, n3);
        if (bl) {
            type = new ArrayType(type, 0x100000);
        }
        return type;
    }

    void writeDataType(RowOutputInterface rowOutputInterface, Type type) {
        rowOutputInterface.writeType(type.typeCode);
        if (type.isArrayType()) {
            rowOutputInterface.writeType(type.collectionBaseType().typeCode);
        }
        rowOutputInterface.writeLong(type.precision);
        rowOutputInterface.writeInt(type.scale);
    }

    void writeDataTypeCodes(RowOutputInterface rowOutputInterface, Type type) {
        rowOutputInterface.writeType(type.typeCode);
        if (type.isArrayType()) {
            rowOutputInterface.writeType(type.collectionBaseType().typeCode);
        }
    }

    void write(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeInt(this.type);
        rowOutputInterface.writeInt(this.columnCount);
        switch (this.type) {
            case 2: 
            case 3: {
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    this.writeDataTypeCodes(rowOutputInterface, this.columnTypes[i2]);
                }
                return;
            }
            case 5: {
                for (int i3 = 0; i3 < this.columnCount; ++i3) {
                    rowOutputInterface.writeInt(this.colIndexes[i3]);
                }
                return;
            }
            case 6: {
                for (int i4 = 0; i4 < this.columnCount; ++i4) {
                    rowOutputInterface.writeString(this.columnLabels[i4]);
                }
                return;
            }
            case 4: {
                for (int i5 = 0; i5 < this.columnCount; ++i5) {
                    this.writeDataType(rowOutputInterface, this.columnTypes[i5]);
                    rowOutputInterface.writeString(this.columnLabels[i5]);
                    rowOutputInterface.writeByte(this.encodeParamColumnAttrs(i5));
                }
                return;
            }
            case 1: {
                ColumnBase columnBase;
                int n2;
                rowOutputInterface.writeInt(this.extendedColumnCount);
                for (n2 = 0; n2 < this.extendedColumnCount; ++n2) {
                    if (this.columnTypes[n2] == null) {
                        columnBase = this.columns[n2];
                        this.columnTypes[n2] = columnBase.getDataType();
                    }
                    this.writeDataType(rowOutputInterface, this.columnTypes[n2]);
                }
                for (n2 = 0; n2 < this.columnCount; ++n2) {
                    columnBase = this.columns[n2];
                    rowOutputInterface.writeString(this.columnLabels[n2]);
                    rowOutputInterface.writeString(columnBase.getCatalogNameString());
                    rowOutputInterface.writeString(columnBase.getSchemaNameString());
                    rowOutputInterface.writeString(columnBase.getTableNameString());
                    rowOutputInterface.writeString(columnBase.getNameString());
                    rowOutputInterface.writeByte(ResultMetaData.encodeTableColumnAttrs(columnBase));
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (n2 = 0; n2 < this.colIndexes.length; ++n2) {
                        rowOutputInterface.writeInt(this.colIndexes[n2]);
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(201, "ResultMetaData");
    }

    public ResultMetaData getNewMetaData(int[] nArray) {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(nArray.length);
        ArrayUtil.projectRow(this.columnLabels, nArray, resultMetaData.columnLabels);
        ArrayUtil.projectRow(this.columnTypes, nArray, resultMetaData.columnTypes);
        ArrayUtil.projectRow(this.columns, nArray, resultMetaData.columns);
        return resultMetaData;
    }

    public static boolean areGeneratedReguestsCompatible(ResultMetaData resultMetaData, ResultMetaData resultMetaData2) {
        if (resultMetaData == resultMetaData2) {
            return true;
        }
        if (resultMetaData == null || resultMetaData2 == null) {
            return false;
        }
        if (!Arrays.equals(resultMetaData.columnLabels, resultMetaData2.columnLabels)) {
            return false;
        }
        return Arrays.equals(resultMetaData.colIndexes, resultMetaData2.colIndexes);
    }

    public boolean areTypesCompatible(ResultMetaData resultMetaData) {
        if (this.columnCount != resultMetaData.columnCount) {
            return false;
        }
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.columnTypes[i2].canConvertFrom(resultMetaData.columnTypes[i2])) continue;
            return false;
        }
        return true;
    }
}

