/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    final DataSpaceManager spaceManager;
    final int scale;
    final int fileBlockSize;
    final int spaceID;
    private DoubleIntIndex spaceList;
    private DoubleIntIndex oldList;
    private DoubleLongIndex oldLargeList;
    private final int capacity;
    private long requestGetCount;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    boolean isInitialised;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;
    long currentBlockFloor = 0L;
    long currentBlockLimit = 0L;
    int fileBlockIndex = -1;

    public TableSpaceManagerBlocks(DataSpaceManager dataSpaceManager, int n2, int n3, int n4, int n5) {
        this.spaceManager = dataSpaceManager;
        this.spaceID = n2;
        this.fileBlockSize = n3;
        this.capacity = n4;
        this.scale = n5;
        this.spaceList = new DoubleIntIndex(n4, true);
        this.spaceList.setValuesSearchTarget();
        this.oldList = new DoubleIntIndex(n4, true);
    }

    @Override
    public boolean hasFileRoom(long l2) {
        return this.freshBlockLimit - this.freshBlockFreePos > l2;
    }

    @Override
    public void addFileBlock(long l2, long l3) {
        int n2 = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (n2 > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, n2);
        }
        this.initialiseFileBlock(null, l2, l3);
    }

    @Override
    public void initialiseFileBlock(LongLookup longLookup, long l2, long l3) {
        this.isInitialised = true;
        this.freshBlockFreePos = l2;
        this.freshBlockLimit = l3;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (longLookup != null) {
            ((DoubleIntIndex)longLookup).copyTo(this.spaceList);
        }
    }

    private boolean getNewMainBlock(long l2) {
        if (!this.isInitialised) {
            this.isInitialised = true;
            this.spaceManager.initialiseTableSpace(this);
            if (this.freshBlockFreePos + l2 <= this.freshBlockLimit) {
                return true;
            }
        }
        long l3 = ((long)this.fileBlockSize + l2) / (long)this.fileBlockSize;
        long l4 = l3 * (long)this.fileBlockSize;
        long l5 = this.spaceManager.getFileBlocks(this.spaceID, (int)l3);
        if (l5 < 0L) {
            return false;
        }
        if (l5 != this.freshBlockLimit) {
            long l6 = this.freshBlockLimit - this.freshBlockFreePos;
            if (l6 > 0L) {
                this.release(this.freshBlockFreePos / (long)this.scale, (int)l6);
            }
            this.freshBlockFreePos = l5;
            this.freshBlockLimit = l5;
        }
        this.freshBlockLimit += l4;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (this.oldList.size() + this.spaceList.size() > this.oldList.capacity()) {
            this.resetOldList();
        }
        this.oldList.addUnsorted(this.spaceList);
        this.resetOldList();
        this.spaceList.clear();
        return true;
    }

    private long getNewBlock(long l2) {
        boolean bl;
        if (this.freshBlockFreePos + l2 > this.freshBlockLimit && !(bl = this.getNewMainBlock(l2))) {
            throw Error.error(468);
        }
        long l3 = this.freshBlockFreePos;
        this.freshBlockFreePos += l2;
        return l3 / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long l2, int n2) {
        int n3 = n2 / this.scale;
        this.isModified = true;
        ++this.releaseCount;
        if (l2 + (long)n3 >= Integer.MAX_VALUE) {
            if (this.oldLargeList == null) {
                this.oldLargeList = new DoubleLongIndex(this.capacity);
            }
            this.oldLargeList.addUnsorted(l2, n3);
            if (this.oldLargeList.size() == this.capacity) {
                this.resetOldList();
            }
            return;
        }
        if (l2 >= this.currentBlockFloor && l2 < this.currentBlockLimit) {
            this.spaceList.add(l2, (long)n3);
            if (this.spaceList.size() == this.capacity) {
                this.resetList(false);
            }
        } else {
            this.oldList.addUnsorted(l2, (long)n3);
            if (this.oldList.size() == this.capacity) {
                this.resetOldList();
            }
        }
    }

    @Override
    public synchronized long getFilePosition(int n2) {
        ++this.requestGetCount;
        if (this.capacity == 0) {
            return this.getNewBlock(n2);
        }
        int n3 = -1;
        int n4 = n2 / this.scale;
        if (this.spaceList.size() > 0) {
            if (this.spaceList.getValue(0) >= n4) {
                n3 = 0;
            } else {
                n3 = this.spaceList.findFirstGreaterEqualKeyIndex(n4);
                if (n3 == -1) {
                    this.spaceList.compactLookupAsIntervals();
                    this.spaceList.setValuesSearchTarget();
                    n3 = this.spaceList.findFirstGreaterEqualKeyIndex(n4);
                }
            }
        }
        if (n3 == -1) {
            return this.getNewBlock(n2);
        }
        ++this.requestCount;
        this.requestSize += (long)n2;
        int n5 = this.spaceList.getKey(n3);
        int n6 = this.spaceList.getValue(n3);
        int n7 = n6 - n4;
        this.spaceList.remove(n3);
        if (n7 > 0) {
            int n8 = n5 + n4;
            this.spaceList.add(n8, n7);
        }
        return n5;
    }

    @Override
    public void reset() {
        this.fileBlockIndex = this.freshBlockFreePos == 0L ? -1 : (int)(this.freshBlockFreePos / (long)this.fileBlockSize);
        this.resetOldList();
        this.resetList(true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
        this.currentBlockFloor = 0L;
        this.currentBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        long l2 = this.freshBlockLimit - this.freshBlockFreePos + this.spaceList.getTotalValues() * (long)this.scale + this.oldList.getTotalValues() * (long)this.scale;
        return l2;
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    public int getFileBlockIndex() {
        return this.fileBlockIndex;
    }

    private void resetList(boolean bl) {
        this.spaceList.compactLookupAsIntervals();
        if (bl) {
            this.spaceManager.freeTableSpace(this.spaceID, this.spaceList, this.freshBlockFreePos, this.freshBlockLimit);
            this.spaceList.clear();
            this.spaceList.setValuesSearchTarget();
        } else {
            if (this.spaceList.size() > this.capacity - 32) {
                int n2 = this.capacity / 2;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = this.spaceList.getKey(i2);
                    int n4 = this.spaceList.getValue(i2);
                    this.oldList.addUnsorted(n3, n4);
                    if (this.oldList.size() != this.capacity) continue;
                    this.resetOldList();
                }
                this.spaceList.removeRange(0, n2);
                this.resetOldList();
            }
            this.spaceList.setValuesSearchTarget();
        }
    }

    private void resetOldList() {
        if (this.oldList.size() > 0) {
            this.oldList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldList, 0L, 0L);
            this.oldList.clear();
        }
        if (this.oldLargeList != null && this.oldLargeList.size() > 0) {
            this.oldLargeList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldLargeList, 0L, 0L);
            this.oldLargeList.clear();
        }
    }
}

