/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLCheck;
import org.hsqldb.index.IndexStats;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    Database database;
    TableSpaceManager tableSpace;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    long baseElementCount;
    AtomicLong elementCount = new AtomicLong();
    long storageSize;
    boolean[] nullsList;
    double[][] searchCost;
    boolean isSchemaStore;
    public LongKeyHashMap rowActionMap;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    @Override
    public boolean isRowStore() {
        return true;
    }

    public boolean isRowSet() {
        return false;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long l2) {
        this.timestamp = l2;
    }

    @Override
    public abstract boolean isMemory();

    @Override
    public void setMemory(boolean bl) {
    }

    @Override
    public abstract CachedObject get(long var1, boolean var3);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    public int compare(Session session, long l2) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract void add(Session var1, CachedObject var2, boolean var3);

    @Override
    public final void add(CachedObject cachedObject, boolean bl) {
    }

    @Override
    public boolean canRead(Session session, long l2, int n2, int[] nArray) {
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject cachedObject, int n2, int[] nArray) {
        RowAction rowAction = ((Row)cachedObject).rowAction;
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n2);
    }

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public CachedObject get(CachedObject cachedObject, RowInputInterface rowInputInterface) {
        return cachedObject;
    }

    @Override
    public CachedObject getNewInstance(int n2) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public int getDefaultObjectSize() {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(CachedObject var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteActionToRow(Session session, Row row, int[] nArray, boolean bl) {
        Row row2 = row;
        synchronized (row2) {
            return RowAction.addDeleteAction(session, this.table, this, row, nArray);
        }
    }

    @Override
    public abstract DataFileCache getCache();

    @Override
    public TableSpaceManager getSpaceManager() {
        return this.tableSpace;
    }

    @Override
    public void setSpaceManager(TableSpaceManager tableSpaceManager) {
        this.tableSpace = tableSpaceManager;
    }

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n2 = index.getPosition();
        if (n2 >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        this.writeLock();
        try {
            int n2;
            for (n2 = 0; n2 < this.indexList.length; ++n2) {
                this.indexList[n2].delete(session, this, row);
            }
            for (n2 = 0; n2 < this.subStores.length; ++n2) {
                this.subStores[n2].delete(session, row);
            }
            row.delete(this);
            long l2 = this.elementCount.decrementAndGet();
            if (l2 > 16384L && l2 < this.baseElementCount / 2L) {
                this.baseElementCount = l2;
                this.searchCost = null;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        int n2;
        this.writeLock();
        try {
            for (n2 = 0; n2 < this.indexList.length; ++n2) {
                this.indexList[n2].insert(session, this, row);
            }
            int n3 = 0;
            try {
                for (n3 = 0; n3 < this.subStores.length; ++n3) {
                    this.subStores[n3].indexRow(session, row);
                }
            }
            catch (HsqlException hsqlException) {
                int n4 = n3;
                for (n3 = 0; n3 < n4; ++n3) {
                    this.subStores[n3].delete(session, row);
                }
                throw hsqlException;
            }
            long l2 = this.elementCount.incrementAndGet();
            if (l2 > 16384L && l2 > this.baseElementCount * 2L) {
                this.baseElementCount = l2;
                this.searchCost = null;
            }
        }
        catch (HsqlException hsqlException) {
            int n5 = n2;
            for (n2 = 0; n2 < n5; ++n2) {
                this.indexList[n2].delete(session, this, row);
            }
            if (this.rowActionMap != null) {
                this.rowActionMap.remove(row.getPos());
            }
            this.remove(row);
            throw hsqlException;
        }
        catch (Throwable throwable) {
            int n6 = n2;
            for (n2 = 0; n2 < n6; ++n2) {
                this.indexList[n2].delete(session, this, row);
            }
            if (this.rowActionMap != null) {
                this.rowActionMap.remove(row.getPos());
            }
            throw Error.error(458, throwable);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public abstract void commitRow(Session var1, Row var2, int var3, int var4);

    @Override
    public abstract void rollbackRow(Session var1, Row var2, int var3, int var4);

    @Override
    public abstract void postCommitAction(Session var1, RowAction var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void indexRows(Session session) {
        this.writeLock();
        try {
            for (int i2 = 1; i2 < this.indexList.length; ++i2) {
                this.setAccessor(this.indexList[i2], null);
            }
            RowIterator rowIterator = this.rowIterator();
            while (rowIterator.next()) {
                Row row = rowIterator.getCurrentRow();
                ((RowAVL)row).clearNonPrimaryNodes();
                for (int i3 = 1; i3 < this.indexList.length; ++i3) {
                    this.indexList[i3].insert(session, this, row);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i2 = 0; i2 < this.indexList.length; ++i2) {
            if (!this.indexList[i2].isClustered()) continue;
            index = this.indexList[i2];
            break;
        }
        return index.firstRow(this);
    }

    @Override
    public void setAccessors(long l2, long[] lArray, long l3) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        this.accessorList[index.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, long l2) {
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] indexArray) {
        int n2;
        this.searchCost = null;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == indexArray) {
            return;
        }
        Index[] indexArray2 = this.indexList;
        CachedObject[] cachedObjectArray = this.accessorList;
        int n3 = this.indexList.length;
        int n4 = indexArray.length - this.indexList.length;
        if (n4 < -1) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        if (n4 == -1) {
            n3 = indexArray.length;
        } else {
            if (n4 == 0) {
                return;
            }
            if (n4 != 1) {
                for (n2 = 0; n2 < n3 && this.indexList[n2] == indexArray[n2]; ++n2) {
                }
                Index[] indexArray3 = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n2, 1);
                indexArray3[n2] = indexArray[n2];
                this.resetAccessorKeys(session, indexArray3);
                this.resetAccessorKeys(session, indexArray);
                return;
            }
        }
        while (n2 < n3 && this.indexList[n2] == indexArray[n2]) {
            ++n2;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, n2, n4);
        this.indexList = indexArray;
        try {
            if (n4 > 0) {
                this.insertIndexNodes(session, this.indexList[0], this.indexList[n2]);
            } else {
                this.dropIndexFromRows(this.indexList[0], indexArray2[n2]);
            }
        }
        catch (HsqlException hsqlException) {
            this.accessorList = cachedObjectArray;
            this.indexList = indexArray2;
            throw hsqlException;
        }
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double searchCost(Session session, Index index, int n2, int n3) {
        if (n2 == 0) {
            return this.elementCount.get();
        }
        if (n3 != 40) {
            return (double)this.elementCount.get() / 2.0;
        }
        if (index.isUnique() && n2 == index.getColumnCount()) {
            return 1.0;
        }
        int n4 = index.getPosition();
        RowStoreAVL rowStoreAVL = this;
        synchronized (rowStoreAVL) {
            if (this.searchCost == null || this.searchCost.length != this.indexList.length) {
                this.searchCost = new double[this.indexList.length][];
            }
            if (this.searchCost[n4] == null) {
                this.searchCost[n4] = this.indexList[n4].searchCost(session, this);
            }
            return this.searchCost[index.getPosition()][n2 - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.readLock();
            try {
                long l2 = index.size(null, this);
                this.elementCount.set(l2);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.elementCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elementCount(Session session) {
        if (session == null) {
            return this.elementCount();
        }
        Index index = this.indexList[0];
        if (session.database.txManager.isMVRows()) {
            switch (this.table.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    this.readLock();
                    try {
                        long l2 = index.size(session, this);
                        return l2;
                    }
                    finally {
                        this.readUnlock();
                    }
                }
            }
        }
        return this.elementCount();
    }

    @Override
    public long elementCountUnique(Index index) {
        return 0L;
    }

    final void setElementCount(long l2) {
        this.elementCount.set(l2);
    }

    @Override
    public boolean hasNull(int n2) {
        return false;
    }

    @Override
    public final void moveData(Session session, PersistentStore persistentStore, int[] nArray, int n2) {
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            Object object3;
            Table table = (Table)this.table;
            RowIterator rowIterator = persistentStore.rowIterator();
            while (rowIterator.next()) {
                object3 = rowIterator.getCurrentRow();
                object2 = ((Row)object3).getData();
                objectArray = table.getEmptyRowData();
                ArrayUtil.copyAdjustArray((Object[])object2, objectArray, nArray, n2);
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    Object object4;
                    SchemaObject schemaObject;
                    if (n2 == 0) {
                        Object object5;
                        schemaObject = persistentStore.getTable().getColumnTypes()[nArray[i2]];
                        object4 = this.table.getColumnTypes()[nArray[i2]];
                        Object object6 = object2[nArray[i2]];
                        objectArray[nArray[i2]] = object5 = ((Type)object4).convertToType(session, object6, (Type)schemaObject);
                        table.systemSetIdentityColumn(session, objectArray);
                        continue;
                    }
                    if (n2 <= 0) continue;
                    schemaObject = table.getColumn(nArray[i2]);
                    objectArray[nArray[i2]] = object4 = table.getColumnDefaultOrGeneratedValue(session, (ColumnSchema)schemaObject, objectArray);
                    table.systemSetIdentityColumn(session, objectArray);
                }
                table.enforceRowConstraints(session, objectArray);
                object = (Row)this.getNewCachedObject(session, objectArray, false);
                this.indexRow(session, (Row)object);
            }
            if (table.isTemp()) {
                return;
            }
            if (nArray.length == 0) {
                return;
            }
            if (n2 <= 0 && (object3 = persistentStore.getTable().getColumnTypes()[nArray[0]]) != null && ((Type)object3).isLobType()) {
                rowIterator = persistentStore.rowIterator();
                while (rowIterator.next()) {
                    object2 = rowIterator.getCurrentRow();
                    objectArray = ((Row)object2).getData();
                    object = (LobData)objectArray[nArray[0]];
                    if (object == null) continue;
                    session.sessionData.adjustLobUsageCount((LobData)object, -1);
                }
            }
            if (n2 >= 0 && (object3 = this.table.getColumnTypes()[nArray[0]]) != null && ((Type)object3).isLobType()) {
                rowIterator = this.rowIterator();
                while (rowIterator.next()) {
                    object2 = rowIterator.getCurrentRow();
                    objectArray = ((Row)object2).getData();
                    object = (LobData)objectArray[nArray[0]];
                    if (object == null) continue;
                    session.sessionData.adjustLobUsageCount((LobData)object, 1);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Error.error(460);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindex(Session session, Index index, Index index2) {
        this.writeLock();
        try {
            RowIterator rowIterator = index2 == null ? this.table.rowIterator(this) : index2.firstRow(this);
            this.setAccessor(index, null);
            while (rowIterator.next()) {
                RowAVL rowAVL = (RowAVL)rowIterator.getCurrentRow();
                rowAVL.getNode(index.getPosition()).delete();
                index.insert(session, this, rowAVL);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public IndexStats[] checkIndexes(Session session, int n2) {
        IndexStats[] indexStatsArray = new IndexStats[this.accessorList.length];
        for (int i2 = 0; i2 < this.indexList.length; ++i2) {
            IndexAVL indexAVL = (IndexAVL)this.indexList[i2];
            NodeAVL nodeAVL = (NodeAVL)this.accessorList[i2];
            IndexAVLCheck.IndexAVLProbe indexAVLProbe = new IndexAVLCheck.IndexAVLProbe(session, this, indexAVL, nodeAVL);
            indexAVLProbe.probe();
            indexStatsArray[i2] = indexAVLProbe.getStats();
        }
        return indexStatsArray;
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    void dropIndexFromRows(Index index, Index index2) {
        RowIterator rowIterator = index.firstRow(this);
        int n2 = index2.getPosition() - 1;
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            int n3 = n2;
            NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
            while (n3-- > 0) {
                nodeAVL = nodeAVL.nNext;
            }
            nodeAVL.nNext = nodeAVL.nNext.nNext;
        }
        rowIterator.release();
    }

    /*
     * Exception decompiling
     */
    boolean insertIndexNodes(Session var1_1, Index var2_2, Index var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void destroyIndexes() {
        if (this.indexList.length == 0) {
            return;
        }
        IndexAVL indexAVL = (IndexAVL)this.indexList[0];
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[0];
        indexAVL.unlinkNodes(this, nodeAVL);
    }
}

