/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.EventLogInterface;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;

public class RAShadowFile {
    private static final int headerSize = 12;
    final EventLogInterface logger;
    final String pathName;
    final RandomAccessInterface source;
    RandomAccessInterface dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    long savedLength;
    long synchLength;
    byte[] buffer;
    HsqlByteArrayOutputStream byteArrayOutputStream;

    RAShadowFile(EventLogInterface eventLogInterface, RandomAccessInterface randomAccessInterface, String string, long l2, int n2) {
        this.logger = eventLogInterface;
        this.pathName = string;
        this.source = randomAccessInterface;
        this.pageSize = n2;
        this.maxSize = l2;
        int n3 = (int)(l2 / (long)n2);
        if (l2 % (long)n2 != 0L) {
            ++n3;
        }
        this.bitMap = new BitMap(n3, false);
        this.buffer = new byte[n2 + 12];
        this.byteArrayOutputStream = new HsqlByteArrayOutputStream(this.buffer);
    }

    int copy(long l2, int n2) throws IOException {
        int n3 = 0;
        if (!this.zeroPageSet) {
            n3 += this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (l2 >= this.maxSize) {
            return n3;
        }
        long l3 = l2 + (long)n2;
        if (l3 > this.maxSize) {
            l3 = this.maxSize;
        }
        int n4 = (int)(l2 / (long)this.pageSize);
        int n5 = (int)(l3 / (long)this.pageSize);
        if (l3 % (long)this.pageSize == 0L) {
            --n5;
        }
        while (n4 <= n5) {
            n3 += this.copy(n4);
            ++n4;
        }
        return n3;
    }

    private int copy(int n2) throws IOException {
        if (this.bitMap.set(n2) == 1) {
            return 0;
        }
        long l2 = (long)n2 * (long)this.pageSize;
        int n3 = this.pageSize;
        int n4 = this.buffer.length;
        if (this.maxSize - l2 < (long)this.pageSize) {
            n3 = (int)(this.maxSize - l2);
        }
        if (this.dest == null) {
            this.open();
        }
        long l3 = this.dest.length();
        try {
            this.byteArrayOutputStream.reset();
            if (n3 < this.pageSize) {
                this.byteArrayOutputStream.fill(0, this.buffer.length);
                this.byteArrayOutputStream.reset();
            }
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(l2);
            this.source.seek(l2);
            this.source.read(this.buffer, 12, n3);
            this.dest.seek(l3);
            this.dest.write(this.buffer, 0, n4);
            this.savedLength = l3 + (long)n4;
            return 1;
        }
        catch (Throwable throwable) {
            this.bitMap.unset(n2);
            this.dest.seek(0L);
            this.dest.setLength(l3);
            this.close();
            this.logger.logSevereEvent("shadow backup failure pos " + l2 + " " + n3, throwable);
            throw JavaSystem.toIOException(throwable);
        }
    }

    private void open() throws IOException {
        this.dest = new RAFileSimple(this.logger, this.pathName, "rw");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.synch();
            this.dest.close();
            this.dest = null;
        }
    }

    public void synch() {
        if (this.dest != null) {
            this.dest.synch();
            this.synchLength = this.savedLength;
        }
    }

    public long getSavedLength() {
        return this.savedLength;
    }

    public InputStreamInterface getInputStream() {
        return new InputStreamShadow();
    }

    private static RandomAccessInterface getStorage(Database database, String string, String string2) throws IOException {
        return new RAFileSimple(database.logger, string, string2);
    }

    public static void restoreFile(Database database, String string, String string2) throws IOException {
        RandomAccessInterface randomAccessInterface = RAShadowFile.getStorage(database, string, "r");
        RandomAccessInterface randomAccessInterface2 = RAShadowFile.getStorage(database, string2, "rw");
        while (randomAccessInterface.getFilePointer() != randomAccessInterface.length()) {
            int n2 = randomAccessInterface.readInt();
            long l2 = randomAccessInterface.readLong();
            byte[] byArray = new byte[n2];
            randomAccessInterface.read(byArray, 0, byArray.length);
            randomAccessInterface2.seek(l2);
            randomAccessInterface2.write(byArray, 0, byArray.length);
        }
        randomAccessInterface.close();
        randomAccessInterface2.synch();
        randomAccessInterface2.close();
    }

    class InputStreamShadow
    implements InputStreamInterface {
        FileInputStream is;
        long limitSize = 0L;
        long fetchedSize = 0L;
        boolean initialised = false;

        InputStreamShadow() {
        }

        @Override
        public int read() throws IOException {
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            int n2 = this.is.read();
            if (n2 < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            ++this.fetchedSize;
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (!this.initialised) {
                this.initialise();
            }
            if (this.fetchedSize == this.limitSize) {
                return -1;
            }
            if (this.limitSize >= 0L && this.limitSize - this.fetchedSize < (long)n3) {
                n3 = (int)(this.limitSize - this.fetchedSize);
            }
            if ((n4 = this.is.read(byArray, n2, n3)) < 0) {
                throw new IOException("backup file not complete " + this.fetchedSize + " " + this.limitSize);
            }
            this.fetchedSize += (long)n4;
            return n4;
        }

        @Override
        public long skip(long l2) {
            return 0L;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
        }

        @Override
        public void setSizeLimit(long l2) {
            this.limitSize = l2;
        }

        @Override
        public long getSizeLimit() {
            if (!this.initialised) {
                this.initialise();
            }
            return this.limitSize;
        }

        private void initialise() {
            this.limitSize = RAShadowFile.this.synchLength;
            RAShadowFile.this.logger.logDetailEvent("shadow file size for backup: " + this.limitSize);
            if (this.limitSize > 0L) {
                try {
                    this.is = new FileInputStream(RAShadowFile.this.pathName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.initialised = true;
        }
    }
}

