/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.EventLogInterface;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFileNIO
implements RandomAccessInterface {
    private final EventLogInterface logger;
    private final boolean readOnly;
    private final long maxLength;
    private long fileLength;
    private RandomAccessFile file;
    private FileDescriptor fileDescriptor;
    private MappedByteBuffer buffer;
    private long bufferPosition;
    private int bufferLength;
    private long currentPosition;
    private FileChannel channel;
    private boolean buffersModified;
    private MappedByteBuffer[] buffers = new MappedByteBuffer[0];
    private static final String JVM_ERROR = "NIO access failed";
    static final int largeBufferScale = 24;
    static final int largeBufferSize = 0x1000000;
    static final long largeBufferMask = -16777216L;

    RAFileNIO(EventLogInterface eventLogInterface, String string, boolean bl, long l2, long l3) throws IOException {
        this.logger = eventLogInterface;
        this.maxLength = l3;
        File file = new File(string);
        if (bl) {
            l2 = file.length();
        } else {
            if (file.length() > l2) {
                l2 = file.length();
            }
            l2 = ArrayUtil.getBinaryNormalisedCeiling(l2, 24);
        }
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.readOnly = bl;
        this.channel = this.file.getChannel();
        this.fileDescriptor = this.file.getFD();
        if (!this.ensureLength(l2)) {
            this.close();
            IOException iOException = new IOException("NIO buffer allocation failed");
            throw iOException;
        }
        this.buffer = this.buffers[0];
        this.bufferLength = this.buffer.limit();
        this.bufferPosition = 0L;
        this.currentPosition = 0L;
    }

    @Override
    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            this.logger.logWarningEvent(JVM_ERROR, iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void seek(long l2) throws IOException {
        try {
            this.positionBufferSeek(l2);
            this.buffer.position((int)(l2 - this.bufferPosition));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.logWarningEvent(JVM_ERROR, illegalArgumentException);
            IOException iOException = JavaSystem.toIOException(illegalArgumentException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        try {
            return this.currentPosition;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.currentPosition == this.fileLength) {
                return -1;
            }
            byte by = this.buffer.get();
            this.positionBufferMove(1);
            return by;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            do {
                this.checkBuffer();
                long l2 = this.bufferPosition + (long)this.bufferLength - this.currentPosition;
                if (l2 > (long)n3) {
                    l2 = n3;
                }
                this.buffer.get(byArray, n2, (int)l2);
                this.positionBufferMove((int)l2);
                n3 = (int)((long)n3 - l2);
                n2 = (int)((long)n2 + l2);
            } while (n3 != 0);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            int n2 = this.buffer.getInt();
            this.positionBufferMove(4);
            return n2;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            long l2 = this.buffer.getLong();
            this.positionBufferMove(8);
            return l2;
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.buffersModified = true;
            do {
                this.checkBuffer();
                long l2 = this.bufferPosition + (long)this.bufferLength - this.currentPosition;
                if (l2 > (long)n3) {
                    l2 = n3;
                }
                this.buffer.put(byArray, n2, (int)l2);
                this.positionBufferMove((int)l2);
                n3 = (int)((long)n3 - l2);
                n2 = (int)((long)n2 + l2);
            } while (n3 != 0);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n2) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putInt(n2);
            this.positionBufferMove(4);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void writeLong(long l2) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putLong(l2);
            this.positionBufferMove(8);
        }
        catch (Throwable throwable) {
            this.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = JavaSystem.toIOException(throwable);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = null;
        try {
            this.logger.logDetailEvent("NIO file close, size: " + this.fileLength);
            this.buffer = null;
            this.channel = null;
            for (int i2 = 0; i2 < this.buffers.length; ++i2) {
                throwable = JavaSystem.unmap(this.buffers[i2]);
                this.buffers[i2] = null;
            }
            this.file.close();
            if (throwable != null) {
                this.logger.logWarningEvent("NIO buffer unmap exception", throwable);
            }
        }
        catch (Throwable throwable2) {
            try {
                this.logger.logWarningEvent("NIO buffer close error", throwable2);
                IOException iOException = JavaSystem.toIOException(throwable2);
                throw iOException;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    this.logger.logWarningEvent("NIO buffer unmap exception", throwable);
                }
                throw throwable3;
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l2) {
        if (l2 > this.maxLength) {
            return false;
        }
        while (l2 > this.fileLength) {
            if (this.enlargeFile(l2)) continue;
            return false;
        }
        return true;
    }

    private boolean enlargeFile(long l2) {
        try {
            FileChannel.MapMode mapMode;
            long l3;
            if (this.readOnly) {
                l3 = 0x1000000L;
                if (this.file.length() - this.fileLength < 0x1000000L) {
                    l3 = this.file.length() - this.fileLength;
                }
            } else {
                l3 = 0x1000000L;
            }
            FileChannel.MapMode mapMode2 = mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            if (!this.readOnly && this.file.length() < this.fileLength + l3) {
                this.file.seek(this.fileLength + l3 - 1L);
                this.file.writeByte(0);
            }
            MappedByteBuffer[] mappedByteBufferArray = new MappedByteBuffer[this.buffers.length + 1];
            MappedByteBuffer mappedByteBuffer = this.channel.map(mapMode, this.fileLength, l3);
            System.arraycopy(this.buffers, 0, mappedByteBufferArray, 0, this.buffers.length);
            mappedByteBufferArray[this.buffers.length] = mappedByteBuffer;
            this.buffers = mappedByteBufferArray;
            this.fileLength += l3;
            this.logger.logDetailEvent("NIO buffer instance, file size " + this.fileLength);
        }
        catch (Throwable throwable) {
            this.logger.logDetailEvent("NOI buffer allocate failed, file size " + l2);
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l2) {
        if (l2 > this.fileLength) {
            return this.enlargeFile(l2);
        }
        try {
            this.seek(0L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        int n2;
        boolean bl = false;
        int n3 = 0;
        for (n2 = 0; n2 < this.buffers.length; ++n2) {
            try {
                this.buffers[n2].force();
                continue;
            }
            catch (Throwable throwable) {
                this.logger.logWarningEvent("NIO buffer force error: pos " + n2 * 0x1000000 + " ", throwable);
                if (!bl) {
                    n3 = n2;
                }
                bl = true;
            }
        }
        if (bl) {
            for (n2 = n3; n2 < this.buffers.length; ++n2) {
                try {
                    this.buffers[n2].force();
                    continue;
                }
                catch (Throwable throwable) {
                    this.logger.logWarningEvent("NIO buffer force error " + n2 * 0x1000000 + " ", throwable);
                }
            }
        }
        try {
            this.fileDescriptor.sync();
            this.buffersModified = false;
        }
        catch (Throwable throwable) {
            this.logger.logSevereEvent("NIO RA file sync error ", throwable);
            throw Error.error(throwable, 452, null);
        }
    }

    private void positionBufferSeek(long l2) {
        if (l2 < this.bufferPosition || l2 >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(l2);
        }
        this.buffer.position((int)(l2 - this.bufferPosition));
        this.currentPosition = l2;
    }

    private void positionBufferMove(int n2) {
        long l2 = this.currentPosition + (long)n2;
        if (l2 >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(l2);
        }
        this.buffer.position((int)(l2 - this.bufferPosition));
        this.currentPosition = l2;
    }

    private void setCurrentBuffer(long l2) {
        int n2 = (int)(l2 >> 24);
        if (n2 == this.buffers.length) {
            n2 = this.buffers.length - 1;
            this.bufferPosition = (long)n2 * 0x1000000L;
            this.buffer = this.buffers[n2];
            return;
        }
        this.buffer = this.buffers[n2];
        this.bufferPosition = l2 & 0xFFFFFFFFFF000000L;
    }

    private void checkBuffer() {
        if (this.readOnly) {
            return;
        }
        int n2 = (int)(this.currentPosition >> 24);
        if (this.currentPosition != this.bufferPosition + (long)this.buffer.position()) {
            this.buffer = this.buffers[n2];
            this.bufferPosition = this.currentPosition & 0xFFFFFFFFFF000000L;
            this.buffer.position((int)(this.currentPosition - this.bufferPosition));
        } else if (this.buffer != this.buffers[n2]) {
            this.buffer = this.buffers[n2];
        }
    }
}

