/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileNIO;
import org.hsqldb.persist.RandomAccessInterface;

public final class RAFileHybrid
implements RandomAccessInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    boolean preNio;
    boolean isNio;
    long initialMaxLength = 0x800000L;
    RandomAccessInterface store;

    public RAFileHybrid(Database database, String string, boolean bl) throws IOException {
        this.database = database;
        this.fileName = string;
        this.isReadOnly = bl;
        File file = new File(string);
        long l2 = file.length();
        this.newStore(l2);
    }

    @Override
    public long length() throws IOException {
        return this.store.length();
    }

    @Override
    public void seek(long l2) throws IOException {
        this.store.seek(l2);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.store.read();
    }

    @Override
    public void read(byte[] byArray, int n2, int n3) throws IOException {
        this.store.read(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.store.write(byArray, n2, n3);
    }

    @Override
    public int readInt() throws IOException {
        return this.store.readInt();
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.store.writeInt(n2);
    }

    @Override
    public long readLong() throws IOException {
        return this.store.readLong();
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.store.writeLong(l2);
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    @Override
    public boolean ensureLength(long l2) {
        if (l2 <= this.initialMaxLength) {
            return this.store.ensureLength(l2);
        }
        if (this.preNio) {
            try {
                this.newStore(l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.store.ensureLength(l2)) {
            return true;
        }
        if (this.isNio) {
            try {
                this.newStore(l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.store.ensureLength(l2);
    }

    @Override
    public boolean setLength(long l2) {
        return this.store.setLength(l2);
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        this.store.synch();
    }

    void newStore(long l2) throws IOException {
        long l3 = 0L;
        if (this.store == null) {
            this.preNio = l2 <= this.database.logger.propNioMaxSize;
        } else {
            l3 = this.store.getFilePointer();
            this.store.synch();
            this.store.close();
        }
        if (this.preNio && this.initialMaxLength <= l2) {
            try {
                this.store = new RAFileNIO(this.database.logger, this.fileName, this.isReadOnly, l2, this.database.logger.propNioMaxSize);
                this.store.seek(l3);
                this.preNio = false;
                this.isNio = true;
                return;
            }
            catch (Throwable throwable) {
                this.preNio = false;
            }
        }
        this.isNio = false;
        this.store = new RAFile(this.database.logger, this.fileName, this.isReadOnly, true, false);
        this.store.seek(l3);
    }
}

