/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.LobStore;

public class LobStoreMem
implements LobStore {
    final int lobBlockSize;
    int blocksInLargeBlock = 128;
    int largeBlockSize;
    HsqlArrayList byteStoreList;

    public LobStoreMem(int n2) {
        this.lobBlockSize = n2;
        this.largeBlockSize = n2 * this.blocksInLargeBlock;
        this.byteStoreList = new HsqlArrayList();
    }

    @Override
    public byte[] getBlockBytes(int n2, int n3) {
        byte[] byArray = new byte[n3 * this.lobBlockSize];
        int n4 = 0;
        while (n3 > 0) {
            int n5 = n2 / this.blocksInLargeBlock;
            byte[] byArray2 = (byte[])this.byteStoreList.get(n5);
            int n6 = n2 % this.blocksInLargeBlock;
            int n7 = n3;
            if (n6 + n7 > this.blocksInLargeBlock) {
                n7 = this.blocksInLargeBlock - n6;
            }
            System.arraycopy(byArray2, n6 * this.lobBlockSize, byArray, n4 * this.lobBlockSize, n7 * this.lobBlockSize);
            n2 += n7;
            n4 += n7;
            n3 -= n7;
        }
        return byArray;
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            int n5 = n2 / this.blocksInLargeBlock;
            if (n5 >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] byArray2 = (byte[])this.byteStoreList.get(n5);
            int n6 = n2 % this.blocksInLargeBlock;
            int n7 = n3;
            if (n6 + n7 > this.blocksInLargeBlock) {
                n7 = this.blocksInLargeBlock - n6;
            }
            System.arraycopy(byArray, n4 * this.lobBlockSize, byArray2, n6 * this.lobBlockSize, n7 * this.lobBlockSize);
            n2 += n7;
            n4 += n7;
            n3 -= n7;
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, long l2, int n2, int n3) {
        while (n3 > 0) {
            int n4 = (int)(l2 / (long)this.largeBlockSize);
            if (n4 >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] byArray2 = (byte[])this.byteStoreList.get(n4);
            int n5 = (int)(l2 % (long)this.largeBlockSize);
            int n6 = n3;
            if (n5 + n6 > this.largeBlockSize) {
                n6 = this.largeBlockSize - n5;
            }
            System.arraycopy(byArray, n2, byArray2, n5, n6);
            l2 += (long)n6;
            n2 += n6;
            n3 -= n6;
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return (long)this.byteStoreList.size() * (long)this.largeBlockSize;
    }

    @Override
    public void setLength(long l2) {
        int n2 = (int)(l2 / (long)this.largeBlockSize);
        this.byteStoreList.setSize(n2 + 1);
    }

    @Override
    public void close() {
        this.byteStoreList.clear();
    }

    @Override
    public void synch() {
    }
}

