/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class IntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    int[] values;

    public IntArrayCachedObject(int n2) {
        this.values = new int[n2];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getFilePosition();
        int n2 = this.values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2] = rowInputInterface.readInt();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.values.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.values.length * 4;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n2 = this.values.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (int i2 = 0; i2 < n2; ++i2) {
            rowOutputInterface.writeInt(this.values[i2]);
        }
        rowOutputInterface.writeEnd();
    }

    public int getNonZeroSize() {
        int n2;
        for (n2 = 0; n2 < this.values.length && this.values[n2] != 0; ++n2) {
        }
        return n2;
    }

    public void setValue(int n2, int n3) {
        this.values[n2] = n3;
        this.hasChanged = true;
    }

    public void setIntArray(int[] nArray) {
        this.values = nArray;
        this.hasChanged = true;
    }

    public int getValue(int n2) {
        return this.values[n2];
    }

    public int[] getIntArray() {
        return this.values;
    }
}

