/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;
import org.hsqldb.persist.TableSpaceManagerSimple;
import org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManager defaultSpaceManager;
    final int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    LongLookup lookup;

    DataSpaceManagerSimple(DataFileCache dataFileCache, boolean bl) {
        this.cache = dataFileCache;
        if (dataFileCache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else if (dataFileCache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else {
            int n2 = dataFileCache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, 4096, n2, dataFileCache.getDataFileScale());
            if (!bl) {
                this.initialiseSpaces();
                dataFileCache.spaceManagerPosition = 0L;
            }
        }
        this.totalFragmentSize = dataFileCache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int n2) {
        if (n2 >= this.spaceIdSequence) {
            this.spaceIdSequence = n2 + 2;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        int n2 = this.spaceIdSequence;
        this.spaceIdSequence += 2;
        return n2;
    }

    @Override
    public long getFileBlocks(int n2, int n3) {
        long l2 = this.cache.getFileFreePos();
        this.cache.enlargeFileSpace(l2 + (long)n3 * 4096L);
        return l2;
    }

    @Override
    public void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
    }

    @Override
    public void freeTableSpace(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n2, LongLookup longLookup, long l2, long l3) {
        this.totalFragmentSize += longLookup.getTotalValues() * (long)this.cache.getDataFileScale();
        if (this.cache.fileFreePosition == l3) {
            this.cache.writeLock.lock();
            try {
                this.cache.fileFreePosition = l2;
            }
            finally {
                this.cache.writeLock.unlock();
            }
        } else {
            this.totalFragmentSize += l3 - l2;
        }
        if (longLookup.size() != 0) {
            this.lookup = longLookup.duplicate();
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return 0x100000 * this.cache.getDataFileScale() / 16;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long l2 = this.cache.getFileFreePos();
        long l3 = (l2 + 4096L) / 4096L;
        long l4 = this.cache.enlargeFileSpace(l3 * 4096L);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, l4, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues() * (long)this.cache.getDataFileScale();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    @Override
    public int getFileBlockItemCount() {
        return 65536;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        return new DirectoryBlockCachedObject[0];
    }
}

