/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.DoubleIntArrayCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManagerBlocks defaultSpaceManager;
    final TableSpaceManagerBlocks directorySpaceManager;
    final IntKeyHashMap spaceManagerList;
    final BlockObjectStore rootStore;
    final BlockObjectStore directoryStore;
    final BlockObjectStore bitMapStore;
    final BlockObjectStore lastBlockStore;
    IntArrayCachedObject rootBlock;
    DoubleIntArrayCachedObject lastBlocks;
    final AtomicInteger spaceIdSequence = new AtomicInteger(8);
    final IntIndex emptySpaceList;
    int released = 0;
    public static final int lastBlockListSize = 1024;
    public static final int dirBlockSize = 2048;
    public static final int fileBlockItemCountLimit = 65536;
    final int bitmapIntSize;
    final int bitmapStorageSize;
    final int fileBlockItemCount;
    final int fileBlockSize;
    final int dataFileScale;
    BlockAccessor ba;

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.cache.getDataFileSpace() * 1024 * 1024;
        this.fileBlockItemCount = this.fileBlockSize / this.dataFileScale;
        this.bitmapIntSize = this.fileBlockItemCount / 32;
        int n2 = 4 * this.bitmapIntSize;
        if (n2 < 4096) {
            n2 = 4096;
        }
        this.bitmapStorageSize = n2;
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.emptySpaceList = new IntIndex(32, false);
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = this.getRootStore();
        this.directoryStore = this.getDirectoryStore();
        this.bitMapStore = this.getBitMapStore();
        this.lastBlockStore = this.getLastBlockStore();
        if (this.cache.spaceManagerPosition == 0L) {
            this.initialiseNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
        } else {
            long l2 = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(l2, true);
            if (this.getBlockIndexLimit() == 0) {
                throw Error.error(452);
            }
            if (this.cache.isDataReadOnly()) {
                return;
            }
            this.initialiseSpaceList();
            int n3 = this.rootBlock.getValue(2047);
            if (n3 == 0) {
                this.lastBlocks = new DoubleIntArrayCachedObject(1024);
                this.initialiseTableSpace(this.directorySpaceManager);
                this.lastBlockStore.add(this.lastBlocks, true);
                n3 = this.getFileBlockPosFromPosition(this.lastBlocks.getPos());
                this.rootBlock.setValue(2047, n3);
            } else {
                l2 = this.getPositionFromFileBlock(n3);
                this.lastBlocks = (DoubleIntArrayCachedObject)this.lastBlockStore.get(l2, true);
                this.initialiseTableSpace(this.directorySpaceManager);
            }
        }
    }

    BlockObjectStore getRootStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 8192, 2048);
    }

    BlockObjectStore getDirectoryStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 24576, 2048);
    }

    BlockObjectStore getBitMapStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, this.bitmapStorageSize, this.bitmapIntSize);
    }

    BlockObjectStore getLastBlockStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, DoubleIntArrayCachedObject.class, 8192, 1024);
    }

    private void initialiseNewSpaceDirectory() {
        long l2 = 8192L;
        int n2 = 1;
        this.cache.enlargeFileSpace(this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, l2, this.fileBlockSize);
        this.rootBlock = new IntArrayCachedObject(2048);
        this.rootStore.add(this.rootBlock, true);
        this.lastBlocks = new DoubleIntArrayCachedObject(1024);
        this.lastBlockStore.add(this.lastBlocks, true);
        int n3 = this.getFileBlockPosFromPosition(this.lastBlocks.getPos());
        this.rootBlock.setValue(2047, n3);
        this.createFileBlocksInDirectory(0, n2, 1);
    }

    private void ensureDirectorySpaceAvailable(int n2) {
        long l2 = (long)this.bitmapStorageSize * (long)n2;
        boolean bl = this.directorySpaceManager.hasFileRoom(l2 += 24576L);
        if (!bl) {
            int n3 = this.getBlockIndexLimit();
            long l3 = (long)n3 * (long)this.fileBlockSize;
            long l4 = l2 / (long)this.fileBlockSize + 1L;
            long l5 = l4 * (long)this.fileBlockSize;
            this.cache.enlargeFileSpace(l3 + l5);
            this.directorySpaceManager.addFileBlock(l3, l3 + l5);
            this.createFileBlocksInDirectory(n3, (int)l4, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int n2, int n3) {
        this.cache.writeLock.lock();
        try {
            long l2 = this.getExistingBlockIndex(n2, n3);
            if (l2 > 0L) {
                long l3 = l2 * (long)this.fileBlockSize;
                return l3;
            }
            long l4 = this.getNewFileBlocks(n2, n3);
            return l4;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int n2, int n3) {
        this.ensureDirectorySpaceAvailable(n3);
        return this.getNewFileBlocksNoCheck(n2, n3);
    }

    private long getNewFileBlocksNoCheck(int n2, int n3) {
        int n4 = this.getBlockIndexLimit();
        long l2 = (long)n4 * (long)this.fileBlockSize;
        long l3 = (long)n3 * (long)this.fileBlockSize;
        this.cache.enlargeFileSpace(l2 + l3);
        this.createFileBlocksInDirectory(n4, n3, n2);
        return l2;
    }

    private void createFileBlocksInDirectory(int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.createFileBlockInDirectory(n2 + i2, n4);
        }
    }

    private void createFileBlockInDirectory(int n2, int n3) {
        BitMapCachedObject bitMapCachedObject = new BitMapCachedObject(this.bitmapIntSize);
        this.bitMapStore.add(bitMapCachedObject, false);
        int n4 = this.getFileBlockPosFromPosition(bitMapCachedObject.getPos());
        int n5 = n2 % 2048;
        DirectoryBlockCachedObject directoryBlockCachedObject = this.getDirectory(n2, true);
        if (directoryBlockCachedObject == null) {
            this.createDirectory(n2);
            directoryBlockCachedObject = this.getDirectory(n2, true);
        }
        directoryBlockCachedObject.setTableId(n5, n3);
        directoryBlockCachedObject.setBitmapAddress(n5, n4);
        directoryBlockCachedObject.keepInMemory(false);
    }

    private DirectoryBlockCachedObject getDirectory(int n2, boolean bl) {
        int n3 = n2 / 2048;
        return this.getDirectoryByIndex(n3, bl);
    }

    private DirectoryBlockCachedObject getDirectoryByIndex(int n2, boolean bl) {
        int n3 = this.rootBlock.getValue(n2);
        long l2 = this.getPositionFromFileBlock(n3);
        if (l2 == 0L) {
            return null;
        }
        return (DirectoryBlockCachedObject)this.directoryStore.get(l2, bl);
    }

    private void createDirectory(int n2) {
        DirectoryBlockCachedObject directoryBlockCachedObject = new DirectoryBlockCachedObject(2048);
        this.directoryStore.add(directoryBlockCachedObject, false);
        int n3 = n2 / 2048;
        int n4 = this.getFileBlockPosFromPosition(directoryBlockCachedObject.getPos());
        this.rootBlock.setValue(n3, n4);
    }

    private int getBlockIndexLimit() {
        int n2 = this.rootBlock.getNonZeroSize();
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.getDirectoryIndexLimit(--n2);
        return n2 * 2048 + n3;
    }

    private int getDirectoryIndexLimit(int n2) {
        int n3;
        DirectoryBlockCachedObject directoryBlockCachedObject = this.getDirectoryByIndex(n2, false);
        int[] nArray = directoryBlockCachedObject.getBitmapAddressArray();
        for (n3 = 0; n3 < nArray.length && nArray[n3] != 0; ++n3) {
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSpaceList() {
        int n2 = 7;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        this.ba.initialise(false);
        try {
            boolean bl;
            while (bl = this.ba.nextBlock()) {
                int n3 = this.ba.getTableId();
                if (n3 > n2) {
                    n2 = n3;
                }
                if (n3 != 0) continue;
                char c2 = this.ba.getFreeSpaceValue();
                char c3 = this.ba.getFreeBlockValue();
                if (c2 == '\u0000' && c3 == '\u0000') {
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                    continue;
                }
                orderedIntHashSet.add(this.ba.currentBlockIndex);
            }
        }
        finally {
            this.ba.reset();
        }
        this.spaceIdSequence.set(n2 + 2 & 0xFFFFFFFE);
        if (orderedIntHashSet.size() > 0) {
            this.setAsideBlocks(orderedIntHashSet);
            String string = "space manager error - recovered (freeItems in empty blocks) : (" + orderedIntHashSet.size() + ")";
            this.cache.logSevereEvent(string, null);
        }
    }

    private int getExistingBlockIndex(int n2, int n3) {
        int n4 = this.emptySpaceList.removeFirstConsecutiveKeys(n3, -1);
        if (n4 > 0) {
            this.setDirectoryBlocksAsTable(n2, n4, n3);
        }
        return n4;
    }

    private void setDirectoryBlocksAsTable(int n2, int n3, int n4) {
        int n5 = -1;
        CachedObjectBase cachedObjectBase = null;
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            if (n5 != i2 / 2048) {
                if (cachedObjectBase != null) {
                    cachedObjectBase.keepInMemory(false);
                }
                cachedObjectBase = this.getDirectory(i2, true);
                n5 = i2 / 2048;
            }
            int n6 = i2 % 2048;
            ((DirectoryBlockCachedObject)cachedObjectBase).setTableId(n6, n2);
        }
        cachedObjectBase.keepInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSpaceManager getTableSpace(int n2) {
        if (n2 == 7) {
            return this.defaultSpaceManager;
        }
        if (n2 >= this.spaceIdSequence.get()) {
            this.spaceIdSequence.set(n2 + 2 & 0xFFFFFFFE);
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)this.spaceManagerList.get(n2);
            if (tableSpaceManagerBlocks == null) {
                tableSpaceManagerBlocks = new TableSpaceManagerBlocks(this, n2, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale);
                this.spaceManagerList.put(n2, tableSpaceManagerBlocks);
            }
            TableSpaceManagerBlocks tableSpaceManagerBlocks2 = tableSpaceManagerBlocks;
            return tableSpaceManagerBlocks2;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n2) {
        if (n2 == 7 || n2 == 1) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManager tableSpaceManager = (TableSpaceManager)this.spaceManagerList.get(n2);
            if (tableSpaceManager != null) {
                tableSpaceManager.reset();
            }
            this.lastBlocks.removeKey(n2);
            IntIndex intIndex = new IntIndex(16, false);
            this.ba.initialise(true);
            try {
                while (this.ba.nextBlockForTable(n2)) {
                    intIndex.addUnsorted(this.ba.currentBlockIndex);
                    this.ba.setTable(0);
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                }
            }
            finally {
                this.ba.reset();
            }
            this.cache.releaseRange(intIndex, this.fileBlockItemCount);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n2, LongLookup longLookup, long l2, long l3) {
        if (longLookup.size() == 0 && l2 == l3) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                int n3;
                long l4;
                for (int i2 = 0; i2 < longLookup.size(); ++i2) {
                    l4 = longLookup.getLongKey(i2);
                    n3 = (int)longLookup.getLongValue(i2);
                    this.freeTableSpacePart(l4, n3);
                }
                l4 = l2 / (long)this.dataFileScale;
                n3 = (int)((l3 - l2) / (long)this.dataFileScale);
                this.freeTableSpacePart(l4, n3);
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private void freeTableSpacePart(long l2, int n2) {
        while (n2 > 0) {
            boolean bl;
            int n3 = (int)(l2 / (long)this.fileBlockItemCount);
            int n4 = (int)(l2 % (long)this.fileBlockItemCount);
            int n5 = this.fileBlockItemCount - n4;
            if (n5 > n2) {
                n5 = n2;
            }
            if (bl = this.ba.moveToBlock(n3)) {
                int n6 = this.ba.setRange(n4, n5);
                if (n6 != n5) {
                    this.ba.unsetRange(n4, n5);
                    String string = "space manager error - recovered (block, offset, units) : (" + n3 + "," + n4 + "," + n2 + ")";
                    this.cache.logSevereEvent(string, null);
                }
            } else {
                String string = "space manager error - recovered (block, offset, units) : (" + n3 + "," + n4 + "," + n2 + ")";
                this.cache.logSevereEvent(string, null);
            }
            n2 -= n5;
            l2 += (long)n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findTableSpace(long l2) {
        int n2 = (int)(l2 / (long)this.fileBlockItemCount);
        this.cache.writeLock.lock();
        try {
            int n3;
            block8: {
                this.ba.initialise(false);
                try {
                    boolean bl = this.ba.moveToBlock(n2);
                    if (bl) break block8;
                    int n4 = -1;
                    this.ba.reset();
                    return n4;
                }
                catch (Throwable throwable) {
                    this.ba.reset();
                    throw throwable;
                }
            }
            int n5 = n3 = this.ba.getTableId();
            this.ba.reset();
            return n5;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsideBlocks(OrderedIntHashSet orderedIntHashSet) {
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                for (int i2 = 0; i2 < orderedIntHashSet.size(); ++i2) {
                    int n2 = orderedIntHashSet.get(i2);
                    boolean bl = this.ba.moveToBlock(n2);
                    if (!bl) continue;
                    this.ba.setTable(6);
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLostBlocksSize() {
        long l2 = 0L;
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(false);
            try {
                boolean bl;
                while (bl = this.ba.nextBlock()) {
                    if (this.ba.getTableId() == 1) continue;
                    l2 += (long)this.ba.getFreeSpaceValue() * (long)this.dataFileScale;
                    if (this.ba.getTableId() != 0) continue;
                    l2 += (long)this.fileBlockSize;
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
        return l2;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialiseSpaces() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                if (tableSpaceManagerBlocks.getSpaceID() != 1 && tableSpaceManagerBlocks.getFileBlockIndex() == -1) continue;
                this.initialiseTableSpace(tableSpaceManagerBlocks);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                tableSpaceManagerBlocks.reset();
                int n2 = tableSpaceManagerBlocks.getFileBlockIndex();
                if (n2 < 0) continue;
                int n3 = tableSpaceManagerBlocks.getSpaceID();
                this.lastBlocks.addKey(n3, n2);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    @Override
    public int getFileBlockItemCount() {
        return this.fileBlockItemCount;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        int n2 = this.rootBlock.getNonZeroSize();
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = new DirectoryBlockCachedObject[n2];
        for (int i2 = 0; i2 < directoryBlockCachedObjectArray.length; ++i2) {
            directoryBlockCachedObjectArray[i2] = this.getDirectoryByIndex(i2, false);
        }
        return directoryBlockCachedObjectArray;
    }

    DoubleIntIndex checkDirectorySpaces() {
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = this.getDirectoryList();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(8);
        DoubleIntIndex doubleIntIndex2 = new DoubleIntIndex(8);
        for (int i2 = 0; i2 < directoryBlockCachedObjectArray.length; ++i2) {
            boolean bl;
            DirectoryBlockCachedObject directoryBlockCachedObject = directoryBlockCachedObjectArray[i2];
            long l2 = directoryBlockCachedObject.getPos();
            int n2 = this.findTableSpace(l2);
            int n3 = i2;
            int n4 = this.rootBlock.getValue(n3);
            int n5 = directoryBlockCachedObject.getStorageSize() / 4096;
            for (int i3 = 0; i3 < n5; ++i3) {
                bl = doubleIntIndex2.addUnique(n4, n3);
            }
            int[] nArray = directoryBlockCachedObject.getBitmapAddressArray();
            for (int i4 = 0; i4 < nArray.length && (n4 = directoryBlockCachedObject.getBitmapAddress(i4)) != 0; ++i4) {
                l2 = this.getPositionFromFileBlock(n4);
                n2 = this.findTableSpace(l2);
                n3 = i2 * 2048 + i4;
                if (n2 != 1) {
                    doubleIntIndex.add(n3, n2);
                    continue;
                }
                bl = doubleIntIndex2.addUnique(n4, n3);
                if (bl) continue;
                doubleIntIndex.add(n3, n2);
                int n6 = doubleIntIndex2.findFirstEqualKeyIndex(n4);
                n3 = doubleIntIndex2.getValue(n6);
                doubleIntIndex.add(n3, n2);
            }
        }
        return doubleIntIndex;
    }

    DoubleIntIndex checkDirectoryBitmaps(DirectoryBlockCachedObject directoryBlockCachedObject) {
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = this.getDirectoryList();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(8);
        int n2 = 0;
        block0: for (int i2 = 0; i2 < directoryBlockCachedObjectArray.length; ++i2) {
            int n3;
            DirectoryBlockCachedObject directoryBlockCachedObject2 = directoryBlockCachedObjectArray[i2];
            int[] nArray = directoryBlockCachedObject2.getBitmapAddressArray();
            for (int i3 = 0; i3 < nArray.length && (n3 = directoryBlockCachedObject2.getBitmapAddress(i3)) != 0; ++i3) {
                long l2 = this.getPositionFromFileBlock(n3);
                int n4 = this.findTableSpace(l2);
                int n5 = i2 * 2048 + i3;
                BitMapCachedObject bitMapCachedObject = (BitMapCachedObject)this.bitMapStore.get(l2, false);
                n4 = directoryBlockCachedObject2.getTableId(i3);
                int n6 = bitMapCachedObject.bitMap.countSetBits();
                int n7 = bitMapCachedObject.bitMap.countSetBitsEnd();
                if (directoryBlockCachedObject2.getFreeSpace(i3) == n6 && directoryBlockCachedObject2.getFreeBlock(i3) == n7) continue;
                doubleIntIndex.add(n5, n4);
                directoryBlockCachedObject.setTableId(n2, n4);
                directoryBlockCachedObject.setFreeSpace(n2, (char)n6);
                directoryBlockCachedObject.setFreeBlock(n2, (char)n7);
                if (++n2 == directoryBlockCachedObject.getTableIdArray().length) continue block0;
            }
        }
        return doubleIntIndex;
    }

    private int findLastFreeSpace(int n2) {
        return this.lastBlocks.getValue(n2, -1);
    }

    @Override
    public void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
        long l2;
        int n2;
        int n3 = tableSpaceManagerBlocks.getSpaceID();
        int n4 = tableSpaceManagerBlocks.getFileBlockIndex();
        if (n4 < 0) {
            n4 = this.findLastFreeSpace(n3);
        }
        if (n4 >= 0 && (n2 = this.findTableSpace(l2 = (long)n4 * (long)this.fileBlockItemCount)) != n3) {
            n4 = -1;
        }
        if (n4 < 0) {
            n4 = this.findLargestFreeSpace(n3);
        }
        if (n4 < 0) {
            return;
        }
        if (this.hasFreeSpace(n3, n4)) {
            this.initialiseTableSpace(tableSpaceManagerBlocks, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFreeSpace(int n2, int n3) {
        this.ba.initialise(false);
        try {
            boolean bl = this.ba.moveToBlock(n3);
            if (bl && this.ba.getTableId() == n2 && this.ba.getFreeBlockValue() > '\u0000') {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLargestFreeSpace(int n2) {
        int n3 = 0;
        int n4 = -1;
        this.ba.initialise(false);
        try {
            int n5;
            while (this.ba.nextBlockForTable(n2)) {
                n5 = this.ba.getFreeBlockValue();
                if (n5 <= n3) continue;
                n4 = this.ba.currentBlockIndex;
                n3 = n5;
            }
            n5 = n4;
            return n5;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks, int n2) {
        this.ba.initialise(true);
        try {
            this.ba.moveToBlock(n2);
            char c2 = this.ba.getFreeBlockValue();
            long l2 = (long)n2 * (long)this.fileBlockSize;
            int n3 = this.ba.unsetRange(this.fileBlockItemCount - c2, c2);
            if (n3 == c2) {
                tableSpaceManagerBlocks.initialiseFileBlock(null, l2 + (long)this.fileBlockSize - (long)c2 * (long)this.dataFileScale, l2 + (long)this.fileBlockSize);
            } else {
                this.cache.logSevereEvent("space manager error - recovered", null);
            }
        }
        finally {
            this.ba.reset();
        }
    }

    long getPositionFromFileBlock(int n2) {
        return (long)n2 * (long)(4096 / this.dataFileScale);
    }

    int getFileBlockPosFromPosition(long l2) {
        return (int)(l2 / (long)(4096 / this.dataFileScale));
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean bl) {
            this.currentKeep = bl;
        }

        boolean nextBlock() {
            boolean bl = this.moveToBlock(this.currentBlockIndex + 1);
            return bl;
        }

        boolean nextBlockForTable(int n2) {
            do {
                boolean bl;
                if (bl = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != n2);
            return true;
        }

        boolean moveToBlock(int n2) {
            if (this.currentBlockIndex != n2) {
                this.endBlockUpdate();
                this.currentBitMap = null;
                if (this.currentDirIndex != n2 / 2048) {
                    this.reset();
                    this.currentDirIndex = n2 / 2048;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(n2, this.currentKeep);
                }
                if (this.currentDir == null) {
                    this.reset();
                    return false;
                }
                this.currentBlockIndex = n2;
                this.currentBlockOffset = n2 % 2048;
                long l2 = this.currentDir.getBitmapAddress(this.currentBlockOffset);
                if (l2 == 0L) {
                    this.reset();
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(l2 *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), true);
                }
            }
            return true;
        }

        int setRange(int n2, int n3) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.setRange(n2, n3);
        }

        int unsetRange(int n2, int n3) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.unsetRange(n2, n3);
        }

        void reset() {
            this.endBlockUpdate();
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        private void endBlockUpdate() {
            if (this.currentBitMap == null) {
                return;
            }
            if (!this.currentBitMap.hasChanged()) {
                this.currentBitMap.keepInMemory(false);
                return;
            }
            int n2 = this.currentBitMap.bitMap.countSetBits();
            int n3 = this.currentBitMap.bitMap.countSetBitsEnd();
            if (n2 == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                int n4 = this.currentDir.getTableIdArray()[this.currentBlockOffset];
                if (n4 != 6) {
                    this.setTable(0);
                    DataSpaceManagerBlocks.this.emptySpaceList.addUnique(this.currentBlockIndex);
                    ++DataSpaceManagerBlocks.this.released;
                }
                this.currentBitMap.keepInMemory(false);
                return;
            }
            this.currentBitMap.keepInMemory(false);
            this.currentDir.setFreeSpace(this.currentBlockOffset, (char)n2);
            this.currentDir.setFreeBlock(this.currentBlockOffset, (char)n3);
        }

        void setTable(int n2) {
            this.currentDir.setTableId(this.currentBlockOffset, n2);
            this.currentDir.setFreeSpace(this.currentBlockOffset, '\u0000');
            this.currentDir.setFreeBlock(this.currentBlockOffset, '\u0000');
            this.currentBitMap.bitMap.reset();
            this.currentBitMap.setChanged(true);
        }

        int getTableId() {
            return this.currentDir.getTableId(this.currentBlockOffset);
        }

        char getFreeSpaceValue() {
            return this.currentDir.getFreeSpace(this.currentBlockOffset);
        }

        char getFreeBlockValue() {
            return this.currentDir.getFreeBlock(this.currentBlockOffset);
        }
    }
}

