/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.RowStoreAVLDisk;

final class DataFileDefrag {
    DataFileCache dataFileOut;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    Database database;
    DataFileCache dataCache;
    LongLookup pointerLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache) {
        this.database = database;
        this.dataCache = dataFileCache;
        this.dataFileName = dataFileCache.getFileName();
    }

    void process(Session session) {
        Object object;
        Throwable throwable = null;
        this.database.logger.logDetailEvent("Defrag process begins");
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[hsqlArrayList.size()][];
        long l2 = 0L;
        int n2 = hsqlArrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Table table = (Table)hsqlArrayList.get(i2);
            if (table.getTableType() != 5) continue;
            object = (RowStoreAVLDisk)this.database.persistentStoreCollection.getStore(table);
            long l3 = ((RowStoreAVL)object).elementCount();
            if (l3 > l2) {
                l2 = l3;
            }
            if (!this.dataCache.spaceManager.isMultiSpace() || !((RowStoreAVL)object).getSpaceManager().isDefaultSpace() || ((RowStoreAVLDisk)object).getStorageSizeEstimate() <= (long)(this.dataCache.spaceManager.getFileBlockSize() / 2)) continue;
            int n3 = this.dataCache.spaceManager.getNewTableSpaceID();
            table.setSpaceID(n3);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw Error.error(3426);
        }
        try {
            String string = this.database.getCanonicalPath();
            this.dataFileOut = new DataFileCache(this.database, string, true);
            this.pointerLookup = this.dataCache.fileFreePosition < Integer.MAX_VALUE * (long)this.dataCache.dataFileScale ? new DoubleIntIndex((int)l2) : new DoubleLongIndex((int)l2);
            int n4 = hsqlArrayList.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object = (Table)hsqlArrayList.get(n2);
                if (((TableBase)object).getTableType() == 5) {
                    long[] lArray = this.writeTableToDataFile(session, (Table)object);
                    this.rootsList[n2] = lArray;
                    continue;
                }
                this.rootsList[n2] = null;
            }
            this.dataFileOut.close();
            this.dataFileOut = null;
            n4 = this.rootsList.length;
            for (n2 = 0; n2 < n4; ++n2) {
                object = this.rootsList[n2];
                if (object == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList((long[])object, ",", ""));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw Error.error(458, throwable2);
        }
        finally {
            try {
                if (this.dataFileOut != null) {
                    this.dataFileOut.release();
                }
            }
            catch (Throwable throwable3) {}
            if (throwable instanceof OutOfMemoryError) {
                this.database.logger.logInfoEvent("defrag failed - out of memory - required: " + l2 * 8L);
            }
            if (throwable == null) {
                this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
            } else {
                this.database.logger.logSevereEvent("defrag failed ", throwable);
                if (this.dataFileOut != null) {
                    this.dataFileOut.deleteDataFile();
                }
            }
        }
    }

    long[] writeTableToDataFile(Session session, Table table) {
        RowStoreAVLDisk rowStoreAVLDisk = (RowStoreAVLDisk)table.database.persistentStoreCollection.getStore(table);
        long[] lArray = table.getIndexRootsArray();
        this.pointerLookup.clear();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().statementName + " " + this.stopw.elapsedTime());
        rowStoreAVLDisk.moveDataToSpace(this.dataFileOut, this.pointerLookup);
        for (int i2 = 0; i2 < table.getIndexCount(); ++i2) {
            if (lArray[i2] == -1L) continue;
            long l2 = this.pointerLookup.lookup(lArray[i2], -1L);
            if (l2 == -1L) {
                throw Error.error(466);
            }
            lArray[i2] = l2;
        }
        long l3 = rowStoreAVLDisk.elementCount();
        if (l3 != (long)this.pointerLookup.size()) {
            this.database.logger.logSevereEvent("discrepency in row count " + table.getName().name + " " + l3 + " " + this.pointerLookup.size(), null);
        }
        this.database.logger.logDetailEvent("table written " + table.getName().statementName);
        return lArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }
}

