/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DataSpaceManagerBlocks;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;

public class DataFileCache {
    protected FileAccess fa;
    public DataSpaceManager spaceManager;
    static final int initIOBufferSize = 4096;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected int dataFileSpace;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected long lostSpaceSize;
    protected long spaceManagerPosition;
    protected long fileStartFreePosition;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is251;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database database, String string) {
        this.initParams(database, string, false);
        this.cache = new Cache(this);
    }

    public DataFileCache(Database database, String string, boolean bl) {
        this.initParams(database, string, true);
        this.cache = new Cache(this);
        try {
            this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "rw");
        }
        catch (Throwable throwable) {
            throw Error.error(452, throwable);
        }
        this.initNewFile();
        this.initBuffers();
        this.spaceManager = this.dataFileSpace > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
    }

    protected void initParams(Database database, String string, boolean bl) {
        this.database = database;
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.fa = database.logger.getFileAccess();
        this.dataFileScale = database.logger.getDataFileScale();
        this.dataFileSpace = database.logger.getDataFileSpace();
        this.cachedRowPadding = this.dataFileScale;
        if (this.dataFileScale < 8) {
            this.cachedRowPadding = 8;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        this.maxCacheRows = database.logger.getCacheMaxRows();
        this.maxCacheBytes = database.logger.getCacheSize();
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)database.logger.getDataFileFactor();
        if (bl) {
            this.dataFileName = this.dataFileName + ".new";
            this.backupFileName = this.backupFileName + ".new";
            this.maxCacheRows = 1024;
            this.maxCacheBytes = 0x400000L;
        }
    }

    public void open(boolean bl) {
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl2 = this.database.logger.propNioDataFile;
            int n2 = this.database.isFilesInJar() ? 2 : (bl2 ? 1 : 0);
            if (bl || this.database.isFilesInJar()) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, true, n2);
                int n3 = this.getFlags();
                if (BitMap.isSet(n3, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.initBuffers();
                this.spaceManager = new DataSpaceManagerSimple(this, true);
                return;
            }
            boolean bl3 = this.fa.isStreamElement(this.dataFileName);
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            if (bl3) {
                this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "r");
                long l2 = this.dataFile.length();
                boolean bl7 = false;
                if (l2 > 32L) {
                    int n4 = this.getFlags();
                    bl5 = BitMap.isSet(n4, 2);
                    bl4 = BitMap.isSet(n4, 1);
                    this.is251 = BitMap.isSet(n4, 6);
                    if (BitMap.isSet(n4, 5)) {
                        bl7 = true;
                    }
                } else {
                    bl3 = false;
                }
                if (bl5 && this.is251) {
                    this.dataFile.seek(32L);
                    long l3 = this.dataFile.readLong();
                    if (l3 > this.database.logger.getFilesTimestamp()) {
                        bl6 = true;
                    }
                }
                this.dataFile.close();
                if (bl7) {
                    throw Error.error(453);
                }
                if (!this.database.logger.propLargeData && l2 > this.maxDataFileSize / 8L * 7L) {
                    this.database.logger.propLargeData = true;
                    this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)this.database.logger.getDataFileFactor();
                }
                if (l2 > this.maxDataFileSize) {
                    throw Error.error(468, String.valueOf(this.maxDataFileSize));
                }
            }
            if (bl3) {
                if (bl5) {
                    boolean bl8 = this.fa.isStreamElement(this.backupFileName);
                    if (bl8) {
                        this.logInfoEvent("data file was not modified but inc backup exists");
                        if (bl6) {
                            this.restoreBackupIncremental();
                        }
                    }
                    this.deleteBackupFile();
                } else {
                    boolean bl9 = bl4 ? this.restoreBackupIncremental() : this.restoreBackup();
                    if (!bl9) {
                        this.database.logger.logSevereEvent("DataFileCache data file modified but no backup exists", null);
                        throw Error.error(454);
                    }
                }
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, bl, n2);
            if (bl3) {
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(20L);
                int n5 = this.dataFile.readInt();
                this.setSpaceProps(n5);
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                int n6 = this.getFlags();
                n6 = BitMap.set(n6, 1);
                n6 = BitMap.set(n6, 2);
                this.setFlags(n6);
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = this.dataFileSpace > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
            if (!bl3) {
                this.reset();
            }
            this.openShadowFile();
            this.logInfoEvent("dataFileCache open end");
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.open", throwable);
            this.release();
            throw Error.error(throwable, 452, 52, new String[]{throwable.toString(), this.dataFileName});
        }
    }

    void setSpaceProps(int n2) {
        if (n2 == 0) {
            n2 = this.dataFileScale | this.dataFileSpace << 16;
            try {
                this.dataFile.seek(20L);
                this.dataFile.writeInt(n2);
                this.dataFile.synch();
            }
            catch (Throwable throwable) {
                throw Error.error(452, throwable);
            }
            return;
        }
        this.dataFileScale = n2 & 0xFFFF;
        this.dataFileSpace = n2 >>> 16;
        this.database.logger.setDataFileScaleNoCheck(this.dataFileScale);
        this.database.logger.setDataFileSpace(this.dataFileSpace);
    }

    void initNewFile() {
        try {
            int n2 = 8192;
            if (this.dataFileSpace == 0 && (n2 = 64) < this.dataFileScale) {
                n2 = this.dataFileScale;
            }
            this.fileFreePosition = n2;
            this.fileStartFreePosition = n2;
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n3 = this.dataFileScale | this.dataFileSpace << 16;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n3);
            this.dataFile.seek(32L);
            this.dataFile.writeLong(this.database.logger.getFilesTimestamp());
            int n4 = 0;
            n4 = BitMap.set(n4, 1);
            n4 = BitMap.set(n4, 2);
            n4 = BitMap.set(n4, 4);
            n4 = BitMap.set(n4, 6);
            this.setFlags(n4);
            this.is251 = true;
        }
        catch (Throwable throwable) {
            throw Error.error(452, throwable);
        }
    }

    private void openShadowFile() {
        this.shadowFile = new RAShadowFile(this.database.logger, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
    }

    private boolean restoreBackup() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            this.deleteBackupFile();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackup", throwable);
            throw Error.error(throwable, 452, 26, new String[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackupFile();
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackupIncremental", throwable);
            throw Error.error(452, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file closed");
            this.dataFile = null;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.release", throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            this.reset();
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close end");
            this.dataFile = null;
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.close", throwable);
            throw Error.error(throwable, 452, 53, new String[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int n2) {
        this.writeLock.lock();
        try {
            this.storeCount += n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen() {
        this.writeLock.lock();
        try {
            this.openShadowFile();
            this.spaceManager.initialiseSpaces();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reset() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.spaceManager.reset();
            this.cache.saveAll();
            long l2 = this.spaceManager.getLostBlocksSize();
            this.dataFile.seek(4L);
            this.dataFile.writeLong(l2);
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n2 = this.dataFileScale | this.dataFileSpace << 16;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n2);
            int n3 = (int)(this.spaceManagerPosition / 4096L);
            this.dataFile.seek(24L);
            this.dataFile.writeInt(n3);
            if (this.is251) {
                this.dataFile.seek(32L);
                this.dataFile.writeLong(this.database.logger.getFilesTimestamp());
            }
            this.setFlag(2, true);
            this.logDetailEvent("file sync end");
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.logInfoEvent("dataFileCache commit end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.reset commit", throwable);
            throw Error.error(throwable, 452, 53, new String[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = new RowOutputBinaryEncode(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag(Session session) {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this);
            dataFileDefrag.process(session);
            DataFileDefrag dataFileDefrag2 = dataFileDefrag;
            return dataFileDefrag2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(CachedObject cachedObject) {
        this.release(cachedObject.getPos());
    }

    public void removePersistence(CachedObject cachedObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject cachedObject, boolean bl) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.put(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            if (cachedObject.getStorageSize() > 4096) {
                this.rowOut.reset(cachedObject.getStorageSize());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        long l2;
        this.readLock.lock();
        try {
            if (cachedObject.isInMemory()) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            l2 = cachedObject.getPos();
            if (l2 < 0L) {
                CachedObject cachedObject3 = null;
                return cachedObject3;
            }
            cachedObject = this.cache.get(l2);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject4 = cachedObject;
                return cachedObject4;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l2, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long l2, int n2, PersistentStore persistentStore, boolean bl) {
        if (l2 < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l2);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l2, n2, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long l2, PersistentStore persistentStore, boolean bl) {
        if (l2 < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l2);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l2, persistentStore, bl);
    }

    private CachedObject getFromFile(long l2, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(l2);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    this.readObject(l2);
                    cachedObject = persistentStore.get(this.rowIn);
                    if (cachedObject == null) {
                        throw Error.error(467, "position " + l2);
                    }
                    break;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        this.cache.clearUnchanged();
                        if (i2 <= 0) continue;
                        this.logInfoEvent(this.dataFileName + " getFromFile out of mem, pos: " + l2);
                        HsqlException hsqlException = Error.error(460, throwable);
                        hsqlException.info = this.rowIn;
                        throw hsqlException;
                    }
                    if (throwable instanceof HsqlException) {
                        ((HsqlException)throwable).info = this.rowIn;
                        throw (HsqlException)throwable;
                    }
                    HsqlException hsqlException = Error.error(467, throwable);
                    hsqlException.info = this.rowIn;
                    throw hsqlException;
                }
            }
            if (cachedObject == null) {
                throw Error.error(466);
            }
            this.cache.put(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            CachedObject cachedObject3 = cachedObject;
            return cachedObject3;
        }
        catch (HsqlException hsqlException) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l2, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CachedObject getFromFile(long l2, int n2, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(l2);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    this.readObject(l2, n2);
                    cachedObject = persistentStore.get(this.rowIn);
                    break;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.cache.clearUnchanged();
                    System.gc();
                    if (i2 <= 0) continue;
                    this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + l2, outOfMemoryError);
                    throw outOfMemoryError;
                }
            }
            if (cachedObject == null) {
                throw Error.error(466);
            }
            this.cache.putUsingReserve(cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            CachedObject cachedObject3 = cachedObject;
            return cachedObject3;
        }
        catch (HsqlException hsqlException) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l2, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(long l2) {
        this.writeLock.lock();
        try {
            this.readObject(l2);
            RowInputInterface rowInputInterface = this.rowIn;
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void readObject(long l2) {
        try {
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            int n2 = this.dataFile.readInt();
            this.rowIn.resetRow(l2, n2);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.readObject", throwable, l2);
            HsqlException hsqlException = Error.error(466, throwable);
            if (this.rowIn.getFilePosition() != l2) {
                this.rowIn.resetRow(l2, 0);
            }
            hsqlException.info = this.rowIn;
            throw hsqlException;
        }
    }

    protected void readObject(long l2, int n2) {
        try {
            this.rowIn.resetBlock(l2, n2);
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            this.dataFile.read(this.rowIn.getBuffer(), 0, n2);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.readObject", throwable, l2);
            HsqlException hsqlException = Error.error(466, throwable);
            hsqlException.info = this.rowIn;
            throw hsqlException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(long l2, long l3) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(l2, l3);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(IntIndex intIndex, int n2) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(intIndex, n2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(long l2) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            CachedObject cachedObject = this.cache.release(l2);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        int n4 = this.copyShadow(cachedObjectArray, n2, n3);
        long l2 = this.cache.saveAllTimer.elapsedTime();
        long l3 = 0L;
        this.cache.saveAllTimer.start();
        if (n4 > 0) {
            this.setFileModified();
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            CachedObject cachedObject = cachedObjectArray[i2];
            this.saveRowNoLock(cachedObject);
            cachedObjectArray[i2] = null;
            l3 += (long)cachedObject.getStorageSize();
        }
        this.cache.saveAllTimer.stop();
        this.cache.logSaveRowsEvent(n3, l3, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.copyShadow(cachedObject);
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveRowOutput(long l2) {
        try {
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.saveRowOutput", throwable, l2);
            throw Error.error(466, throwable);
        }
    }

    protected void saveRowNoLock(CachedObject cachedObject) {
        try {
            this.rowOut.reset();
            cachedObject.write(this.rowOut);
            this.dataFile.seek(cachedObject.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            cachedObject.setChanged(false);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.saveRowNoLock", throwable, cachedObject.getPos());
            throw Error.error(466, throwable);
        }
    }

    protected int copyShadow(CachedObject[] cachedObjectArray, int n2, int n3) {
        int n4 = 0;
        if (this.shadowFile != null) {
            long l2 = this.cache.shadowTimer.elapsedTime();
            long l3 = 0L;
            this.cache.shadowTimer.start();
            try {
                for (int i2 = n2; i2 < n2 + n3; ++i2) {
                    CachedObject cachedObject = cachedObjectArray[i2];
                    l3 = cachedObject.getPos() * (long)this.dataFileScale;
                    n4 += this.shadowFile.copy(l3, cachedObject.getStorageSize());
                }
                if (n4 > 0) {
                    this.shadowFile.synch();
                }
            }
            catch (Throwable throwable) {
                this.logSevereEvent("DataFileCache.copyShadow", throwable, l3);
                throw Error.error(466, throwable);
            }
            this.cache.shadowTimer.stop();
            if (n4 > 0) {
                l2 = this.cache.shadowTimer.elapsedTime() - l2;
                this.logDetailEvent("copyShadow [size, time] " + this.shadowFile.getSavedLength() + " " + l2);
            }
        }
        return n4;
    }

    protected int copyShadow(CachedObject cachedObject) {
        if (this.shadowFile != null) {
            long l2 = cachedObject.getPos() * (long)this.dataFileScale;
            try {
                int n2 = this.shadowFile.copy(l2, cachedObject.getStorageSize());
                this.shadowFile.synch();
                return n2;
            }
            catch (Throwable throwable) {
                this.logSevereEvent("DataFileCache.copyShadow", throwable, cachedObject.getPos());
                throw Error.error(466, throwable);
            }
        }
        return 0;
    }

    void deleteDataFile() {
        Log.deleteFile(this.fa, this.dataFileName);
    }

    private void deleteBackupFile() {
        Log.deleteFile(this.fa, this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long enlargeFileSpace(long l2) {
        this.writeLock.lock();
        try {
            long l3 = this.fileFreePosition;
            if (l2 > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum allowed size: " + this.dataFileName + " " + this.maxDataFileSize, null);
                throw Error.error(468);
            }
            boolean bl = this.dataFile.ensureLength(l2);
            if (!bl) {
                this.logSevereEvent("data file cannot be enlarged - disk space: " + this.dataFileName + " " + l2, null);
                throw Error.error(468);
            }
            this.fileFreePosition = l2;
            long l4 = l3;
            return l4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public long getLostBlockSize() {
        return this.spaceManager.getLostBlocksSize();
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public int getDataFileScale() {
        return this.dataFileScale;
    }

    public int getDataFileSpace() {
        return this.dataFileSpace;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    protected void setFileModified() {
        try {
            if (!this.fileModified) {
                this.setFlag(2, false);
                this.logDetailEvent("setFileModified flag set ");
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.setFileModified", throwable);
            throw Error.error(466, throwable);
        }
    }

    int getFlags() throws IOException {
        this.dataFile.seek(28L);
        int n2 = this.dataFile.readInt();
        return n2;
    }

    void setFlags(int n2) throws IOException {
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n2);
        this.dataFile.synch();
    }

    void setFlag(int n2, boolean bl) throws IOException {
        this.dataFile.seek(28L);
        int n3 = this.dataFile.readInt();
        n3 = bl ? BitMap.set(n3, n2) : BitMap.unset(n3, n2);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n3);
        this.dataFile.synch();
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    public AtomicInteger getAccessCount() {
        return this.cache.getAccessCount();
    }

    private void logSevereEvent(String string, Throwable throwable, long l2) {
        if (this.logEvents) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(' ').append(l2);
            string = stringBuilder.toString();
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    public void logSevereEvent(String string, Throwable throwable) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    void logInfoEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(string);
        }
    }

    void logDetailEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(string);
        }
    }

    static interface Positions {
        public static final int LONG_EMPTY_SIZE = 4;
        public static final int LONG_FREE_POS = 12;
        public static final int INT_SPACE_PROPS = 20;
        public static final int INT_SPACE_LIST_POS = 24;
        public static final int INT_FLAGS = 28;
        public static final int LONG_TIMESTAMP = 32;
        public static final int MIN_INITIAL_FREE_POS = 64;
        public static final int MAX_INITIAL_FREE_POS = 8192;
    }

    static interface Flags {
        public static final int FLAG_ISSHADOWED = 1;
        public static final int FLAG_ISSAVED = 2;
        public static final int FLAG_ROWINFO = 3;
        public static final int FLAG_200 = 4;
        public static final int FLAG_HX = 5;
        public static final int FLAG_251 = 6;
    }
}

