/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.PIFData;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileInputStream;
import org.hsqldb.lib.tar.TarHeaderField;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarReader {
    public static final int LIST_MODE = 0;
    public static final int EXTRACT_MODE = 1;
    public static final int OVERWRITE_MODE = 2;
    protected TarFileInputStream archive;
    protected Pattern[] patterns = null;
    protected int mode;
    protected File extractBaseDir;

    public TarReader(File file, int n2, String[] stringArray, Integer n3, File file2) throws IOException {
        this.mode = n2;
        File file3 = file.getAbsoluteFile();
        this.extractBaseDir = file2 == null ? null : file2.getAbsoluteFile();
        int n4 = 0;
        if (file3.getName().endsWith(".tgz") || file3.getName().endsWith(".gz")) {
            n4 = 1;
        }
        if (stringArray != null) {
            this.patterns = new Pattern[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.patterns[i2] = Pattern.compile(stringArray[i2]);
            }
        }
        this.archive = n3 == null ? new TarFileInputStream(file3, n4) : new TarFileInputStream(file3, n4, n3);
    }

    public void read() throws IOException, TarMalformatException {
        boolean bl = false;
        Long l2 = null;
        String string = null;
        try {
            while (this.archive.readNextHeaderBlock()) {
                TarEntryHeader tarEntryHeader = new TarEntryHeader(this.archive.readBuffer);
                char c2 = tarEntryHeader.getEntryType();
                if (c2 == 'x') {
                    l2 = this.getPifData(tarEntryHeader).getSize();
                    string = tarEntryHeader.toString();
                    continue;
                }
                if (l2 != null) {
                    tarEntryHeader.setDataSize(l2);
                    l2 = null;
                }
                if (this.patterns != null) {
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < this.patterns.length; ++i2) {
                        if (!this.patterns[i2].matcher(tarEntryHeader.getPath()).matches()) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        string = null;
                        this.skipFileData(tarEntryHeader);
                        continue;
                    }
                }
                if (c2 != '\u0000' && c2 != '0' && c2 != 'x') {
                    bl = true;
                }
                switch (this.mode) {
                    case 0: {
                        if (string != null) {
                            System.out.println(string);
                        }
                        System.out.println(tarEntryHeader.toString());
                        this.skipFileData(tarEntryHeader);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (string != null) {
                            System.out.println(string);
                        }
                        System.out.println(tarEntryHeader.toString());
                        if (c2 == '\u0000' || c2 == '0' || c2 == 'x') {
                            this.extractFile(tarEntryHeader);
                            break;
                        }
                        this.skipFileData(tarEntryHeader);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(RB.unsupported_mode.getString(this.mode));
                    }
                }
                string = null;
            }
            if (bl) {
                System.out.println(RB.unsupported_entry_present.getString());
            }
        }
        catch (IOException iOException) {
            this.archive.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PIFData getPifData(TarEntryHeader tarEntryHeader) throws IOException, TarMalformatException {
        long l2 = tarEntryHeader.getDataSize();
        if (l2 < 1L) {
            throw new TarMalformatException(RB.pif_unknown_datasize.getString());
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new TarMalformatException(RB.pif_data_toobig.getString(Long.toString(l2), Integer.MAX_VALUE));
        }
        int n2 = (int)(l2 % 512L);
        PipedInputStream pipedInputStream = null;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            int n3;
            pipedInputStream = new PipedInputStream(pipedOutputStream);
            for (int i2 = (int)(l2 / 512L); i2 > 0; i2 -= n3) {
                n3 = i2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : i2;
                this.archive.readBlocks(n3);
                pipedOutputStream.write(this.archive.readBuffer, 0, n3 * 512);
            }
            if (n2 != 0) {
                this.archive.readBlock();
                pipedOutputStream.write(this.archive.readBuffer, 0, n2);
            }
            pipedOutputStream.flush();
        }
        catch (IOException iOException) {
            if (pipedInputStream != null) {
                pipedInputStream.close();
            }
            throw iOException;
        }
        finally {
            try {
                pipedOutputStream.close();
            }
            finally {
                pipedOutputStream = null;
            }
        }
        return new PIFData(pipedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(TarEntryHeader tarEntryHeader) throws IOException, TarMalformatException {
        if (tarEntryHeader.getDataSize() < 1L) {
            throw new TarMalformatException(RB.data_size_unknown.getString());
        }
        int n2 = (int)(tarEntryHeader.getDataSize() / 512L);
        int n3 = (int)(tarEntryHeader.getDataSize() % 512L);
        File file = tarEntryHeader.generateFile();
        if (!file.isAbsolute()) {
            file = this.extractBaseDir == null ? file.getAbsoluteFile() : new File(this.extractBaseDir, file.getPath());
        }
        File file2 = file.getParentFile();
        if (file.exists()) {
            if (this.mode != 2) {
                throw new IOException(RB.extraction_exists.getString(file.getAbsolutePath()));
            }
            if (!file.isFile()) {
                throw new IOException(RB.extraction_exists_notfile.getString(file.getAbsolutePath()));
            }
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException(RB.extraction_parent_not_dir.getString(file2.getAbsolutePath()));
            }
            if (!file2.canWrite()) {
                throw new IOException(RB.extraction_parent_not_writable.getString(file2.getAbsolutePath()));
            }
        } else if (!file2.mkdirs()) {
            throw new IOException(RB.extraction_parent_mkfail.getString(file2.getAbsolutePath()));
        }
        int n4 = tarEntryHeader.getFileMode();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            file.setExecutable(false, false);
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setExecutable((n4 & 0x40) != 0, true);
            file.setReadable((n4 & 0x100) != 0, true);
            file.setWritable((n4 & 0x80) != 0, true);
            while (n2 > 0) {
                int n5 = n2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : n2;
                this.archive.readBlocks(n5);
                n2 -= n5;
                fileOutputStream.write(this.archive.readBuffer, 0, n5 * 512);
            }
            if (n3 != 0) {
                this.archive.readBlock();
                fileOutputStream.write(this.archive.readBuffer, 0, n3);
            }
            fileOutputStream.flush();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            finally {
                fileOutputStream = null;
            }
        }
        file.setLastModified(tarEntryHeader.getModTime() * 1000L);
        if (file.length() != tarEntryHeader.getDataSize()) {
            throw new IOException(RB.write_count_mismatch.getString(Long.toString(tarEntryHeader.getDataSize()), file.getAbsolutePath(), Long.toString(file.length())));
        }
    }

    protected void skipFileData(TarEntryHeader tarEntryHeader) throws IOException, TarMalformatException {
        int n2;
        if (tarEntryHeader.getDataSize() == 0L) {
            return;
        }
        if (tarEntryHeader.getDataSize() < 0L) {
            throw new TarMalformatException(RB.data_size_unknown.getString());
        }
        int n3 = tarEntryHeader.getDataSize() % 512L == 0L ? 0 : 1;
        for (int i2 = (int)(tarEntryHeader.getDataSize() / 512L) + n3; i2 > 0; i2 -= n2) {
            n2 = i2 > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : i2;
            this.archive.readBlocks(n2);
        }
    }

    protected static class TarEntryHeader {
        protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        protected byte[] rawHeader;
        protected String path;
        protected int fileMode;
        protected long dataSize = -1L;
        protected long modTime;
        protected char entryType;
        protected String ownerName;
        protected boolean ustar;

        public TarEntryHeader(byte[] byArray) throws TarMalformatException {
            this.rawHeader = byArray;
            Long l2 = this.readInteger(TarHeaderField.checksum);
            try {
                if (l2 == null) {
                    throw new MissingField(TarHeaderField.checksum);
                }
                long l3 = this.headerChecksum();
                if (l2 != l3) {
                    throw new TarMalformatException(RB.checksum_mismatch.getString(l2.toString(), Long.toString(l3)));
                }
                this.path = this.readString(TarHeaderField.name);
                if (this.path == null) {
                    throw new MissingField(TarHeaderField.name);
                }
                Long l4 = this.readInteger(TarHeaderField.mode);
                if (l4 == null) {
                    throw new MissingField(TarHeaderField.mode);
                }
                this.fileMode = (int)l4.longValue();
                l4 = this.readInteger(TarHeaderField.size);
                if (l4 != null) {
                    this.dataSize = l4;
                }
                if ((l4 = this.readInteger(TarHeaderField.mtime)) == null) {
                    throw new MissingField(TarHeaderField.mtime);
                }
                this.modTime = l4;
            }
            catch (MissingField missingField) {
                throw new TarMalformatException(missingField.getMessage());
            }
            this.entryType = this.readChar(TarHeaderField.typeflag);
            this.ownerName = this.readString(TarHeaderField.uname);
            String string = this.readString(TarHeaderField.prefix);
            if (string != null) {
                this.path = string + '/' + this.path;
            }
            this.ustar = this.isUstar();
        }

        public File generateFile() {
            if (this.entryType != '\u0000' && this.entryType != '0') {
                throw new IllegalStateException(RB.create_only_normal.getString());
            }
            return new File(this.path);
        }

        public char getEntryType() {
            return this.entryType;
        }

        public String getPath() {
            return this.path;
        }

        public void setDataSize(long l2) {
            this.dataSize = l2;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public long getModTime() {
            return this.modTime;
        }

        public int getFileMode() {
            return this.fileMode;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.sdf.format(this.modTime * 1000L) + ' ');
            stringBuilder.append(this.entryType == '\u0000' ? (char)' ' : (char)this.entryType);
            stringBuilder.append(this.ustar ? (char)'*' : ' ');
            stringBuilder.append(" " + StringUtil.toPaddedString(Integer.toOctalString(this.fileMode), 4, ' ', false) + ' ' + StringUtil.toPaddedString(Long.toString(this.dataSize), 11, ' ', false) + "  ");
            stringBuilder.append(StringUtil.toPaddedString(this.ownerName == null ? "-" : this.ownerName, 8, ' ', true));
            stringBuilder.append("  " + this.path);
            return stringBuilder.toString();
        }

        public boolean isUstar() throws TarMalformatException {
            String string = this.readString(TarHeaderField.magic);
            return string != null && string.startsWith("ustar");
        }

        public static int indexOf(byte[] byArray, byte by, int n2, int n3) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (byArray[i2] != by) continue;
                return i2 - n2;
            }
            return -1;
        }

        protected char readChar(TarHeaderField tarHeaderField) throws TarMalformatException {
            String string = this.readString(tarHeaderField);
            return string == null ? (char)'\u0000' : string.charAt(0);
        }

        protected String readString(TarHeaderField tarHeaderField) throws TarMalformatException {
            int n2 = tarHeaderField.getStart();
            int n3 = tarHeaderField.getStop();
            int n4 = TarEntryHeader.indexOf(this.rawHeader, (byte)0, n2, n3);
            switch (n4) {
                case 0: {
                    return null;
                }
                case -1: {
                    n4 = n3 - n2;
                    break;
                }
            }
            try {
                return new String(this.rawHeader, n2, n4);
            }
            catch (Throwable throwable) {
                throw new TarMalformatException(RB.bad_header_value.getString(tarHeaderField.toString()));
            }
        }

        protected Long readInteger(TarHeaderField tarHeaderField) throws TarMalformatException {
            String string = this.readString(tarHeaderField);
            if (string == null) {
                return null;
            }
            try {
                return Long.valueOf(string, 8);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TarMalformatException(RB.bad_numeric_header_value.getString(tarHeaderField.toString(), numberFormatException.toString()));
            }
        }

        protected long headerChecksum() {
            long l2 = 0L;
            for (int i2 = 0; i2 < 512; ++i2) {
                boolean bl = i2 >= TarHeaderField.checksum.getStart() && i2 < TarHeaderField.checksum.getStop();
                l2 += bl ? 32L : (long)(0xFF & this.rawHeader[i2]);
            }
            return l2;
        }

        protected static class MissingField
        extends Exception {
            private TarHeaderField field;

            public MissingField(TarHeaderField tarHeaderField) {
                this.field = tarHeaderField;
            }

            @Override
            public String getMessage() {
                return RB.header_field_missing.getString(this.field.toString());
            }
        }
    }
}

