/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.IntHashSet;

public class OrderedIntHashSet
extends IntHashSet {
    public OrderedIntHashSet() {
        this(8);
    }

    public OrderedIntHashSet(int n2) throws IllegalArgumentException {
        super(n2);
        this.isList = true;
    }

    public OrderedIntHashSet(int[] nArray) {
        super(nArray.length);
        this.isList = true;
        this.addAll(nArray);
    }

    public OrderedIntHashSet(int[] nArray, int[] nArray2) {
        super(nArray.length + nArray2.length);
        this.isList = true;
        this.addAll(nArray);
        this.addAll(nArray2);
    }

    public boolean insert(int n2, int n3) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(n3)) {
            return false;
        }
        if (n2 < this.size()) {
            super.insertRow(n2);
        }
        return this.add(n3);
    }

    @Override
    public boolean remove(int n2) {
        return (Boolean)super.remove(n2, 0L, null, null, false, true);
    }

    public void removeEntry(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        int n3 = this.intKeyTable[n2];
        super.remove(n3, 0L, null, null, false, true);
    }

    public int get(int n2) {
        this.checkRange(n2);
        return this.intKeyTable[n2];
    }

    public int getIndex(int n2) {
        return this.getLookup(n2);
    }

    public int getOrderedStartMatchCount(int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length && n2 < this.size() && this.get(n2) == nArray[n2]; ++n2) {
        }
        return n2;
    }

    public boolean addAll(OrderedIntHashSet orderedIntHashSet) {
        int n2 = this.size();
        int n3 = orderedIntHashSet.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = orderedIntHashSet.get(i2);
            this.add(n4);
        }
        return n2 != this.size();
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

