/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<K, Long>> entries;

    public LongValueHashMap() {
        this(8);
    }

    public LongValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 3, 2, false);
    }

    public LongValueHashMap(int n2, ObjectComparator objectComparator) {
        this(n2);
        this.comparator = objectComparator;
    }

    public long get(Object object) throws NoSuchElementException {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public long get(Object object, int n2) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n3 = this.getLookup(object);
        if (n3 != -1) {
            return this.longValueTable[n3];
        }
        return n2;
    }

    public boolean get(Object object, long[] lArray) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            lArray[0] = this.longValueTable[n2];
            return true;
        }
        return false;
    }

    public Object getKey(long l2) {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(false);
        while (baseHashIterator.hasNext()) {
            long l3 = baseHashIterator.nextLong();
            if (l3 != l2) continue;
            return this.objectKeyTable[baseHashIterator.getLookup()];
        }
        return null;
    }

    public boolean put(Object object, long l2) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.addOrUpdate(0L, l2, object, null);
        return n2 != this.size();
    }

    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.remove(0L, 0L, object, null, false, false);
        return n2 != this.size();
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.containsKey(object);
    }

    public void putAll(LongValueHashMap longValueHashMap) {
        Iterator iterator = longValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            this.put(e2, longValueHashMap.get(e2));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values<Long>();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Long>
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            longValueHashMap.getClass();
            return longValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            longValueHashMap.getClass();
            return longValueHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return LongValueHashMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return LongValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return LongValueHashMap.this.toArray(TArray, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<K, Long> next() {
            Object object = super.next();
            Long l2 = LongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Object, Long>(object, l2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Long>>
    implements Set<Map.Entry<K, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

