/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<K, Integer>> entries;

    public IntValueHashMap() {
        this(8);
    }

    public IntValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 3, 1, false);
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsValue(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n2) {
        return super.containsValue(n2);
    }

    public int get(Object object) throws NoSuchElementException {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public int get(Object object, int n2) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n3 = this.getLookup(object);
        if (n3 != -1) {
            return this.intValueTable[n3];
        }
        return n2;
    }

    public boolean get(Object object, int[] nArray) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            nArray[0] = this.intValueTable[n2];
            return true;
        }
        return false;
    }

    public Object getKey(int n2) {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(false);
        while (baseHashIterator.hasNext()) {
            int n3 = baseHashIterator.nextInt();
            if (n3 != n2) continue;
            return this.objectKeyTable[baseHashIterator.getLookup()];
        }
        return null;
    }

    public boolean put(Object object, int n2) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n3 = this.size();
        super.addOrUpdate(0L, n2, object, null);
        return n3 != this.size();
    }

    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.remove(0L, 0L, object, null, false, false);
        return n2 != this.size();
    }

    public void putAll(Map<? extends K, ? extends Integer> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Integer n2 = map.get(e2);
            int n3 = n2;
            this.put(e2, n3);
        }
    }

    public void putAll(IntValueHashMap intValueHashMap) {
        Iterator iterator = intValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            this.put(e2, intValueHashMap.get(e2));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    class Values
    extends AbstractReadOnlyCollection<Integer> {
        Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            intValueHashMap.getClass();
            return intValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    class KeySet
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public PrimitiveIterator<K> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            intValueHashMap.getClass();
            return intValueHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return IntValueHashMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return IntValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return IntValueHashMap.this.toArray(TArray, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<K, Long> next() {
            Object object = super.next();
            Integer n2 = IntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Object, Integer>(object, n2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Integer>>
    implements Set<Map.Entry<K, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

