/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyLongValueHashMap
extends BaseHashMap
implements Map<Integer, Long> {
    private Set<Integer> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Integer, Long>> entries;

    public IntKeyLongValueHashMap() {
        this(8);
    }

    public IntKeyLongValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 1, 2, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsKey(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n2) {
        return super.containsKey(n2);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return super.containsValue(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n2) {
        return super.containsValue(n2);
    }

    @Override
    public Long get(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            try {
                long l2 = this.get(n2);
                return l2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public long get(int n2) throws NoSuchElementException {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            return this.longValueTable[n3];
        }
        throw new NoSuchElementException();
    }

    public long get(int n2, long l2) {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            return this.longValueTable[n3];
        }
        return l2;
    }

    public boolean get(int n2, long[] lArray) {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            lArray[0] = this.longValueTable[n3];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Integer n2, Long l2) {
        if (n2 == null || l2 == null) {
            throw new NullPointerException();
        }
        int n3 = this.size();
        super.addOrUpdate(n2.intValue(), l2, null, null);
        if (n3 == this.size()) {
            return null;
        }
        return l2;
    }

    @Override
    public boolean put(int n2, long l2) {
        int n3 = this.size();
        super.addOrUpdate(n2, l2, null, null);
        return n3 != this.size();
    }

    @Override
    public Long remove(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return (Long)super.remove(n2, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int n2) {
        Long l2 = (Long)super.remove(n2, 0L, null, null, false, false);
        return l2 != null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            Long l2 = map.get(n2);
            long l3 = l2;
            this.put(n3, l3);
        }
    }

    public void putAll(IntKeyIntValueHashMap intKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            int n2 = primitiveIterator.nextInt();
            int n3 = intKeyIntValueHashMap.get(n2);
            this.put(n2, n3);
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public long[] valuesToArray(long[] lArray) {
        return this.toLongArray(lArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return intKeyLongValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return intKeyLongValueHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(true);
        }

        @Override
        public Map.Entry<Integer, Long> next() {
            Integer n2 = super.nextInt();
            Long l2 = IntKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Integer, Long>(n2, l2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Long>>
    implements Set<Map.Entry<Integer, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

