/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

public final class InOutUtil {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 8192;
    public static final long DEFAULT_COPY_AMOUNT = Long.MAX_VALUE;

    private InOutUtil() {
    }

    public static int readLine(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        int n3 = 0;
        while ((n2 = inputStream.read()) != -1) {
            ++n3;
            outputStream.write(n2);
            if (n2 != 10) continue;
            break;
        }
        return n3;
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(hsqlByteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        return hsqlByteArrayOutputStream.toByteArray();
    }

    public static Serializable deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        HsqlByteArrayInputStream hsqlByteArrayInputStream = new HsqlByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(hsqlByteArrayInputStream);
        return (Serializable)objectInputStream.readObject();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, Long.MAX_VALUE, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, l2, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l2, int n2) throws IOException {
        int n3;
        int n4 = (int)Math.min((long)n2, l2);
        byte[] byArray = new byte[n4];
        long l3 = 0L;
        while (l3 < l2 && -1 != (n3 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n3);
            l3 = (long)n3 > Long.MAX_VALUE - l3 ? Long.MAX_VALUE : (l3 += (long)n3);
            if (l3 >= l2) {
                return l3;
            }
            n4 = (int)Math.min((long)n2, l2 - l3);
        }
        return l3;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return InOutUtil.copy(reader, writer, Long.MAX_VALUE, 8192);
    }

    public static long copy(Reader reader, Writer writer, long l2) throws IOException {
        return InOutUtil.copy(reader, writer, l2, 8192);
    }

    public static long copy(Reader reader, Writer writer, long l2, int n2) throws IOException {
        int n3;
        int n4 = (int)Math.min((long)n2, l2);
        char[] cArray = new char[n4];
        long l3 = 0L;
        while (l3 < l2 && -1 != (n3 = reader.read(cArray, 0, n4))) {
            writer.write(cArray, 0, n3);
            l3 = (long)n3 > Long.MAX_VALUE - l3 ? Long.MAX_VALUE : (l3 += (long)n3);
            if (l3 >= l2) {
                return l3;
            }
            n4 = (int)Math.min((long)n2, l2 - l3);
        }
        return l3;
    }
}

