/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;

public final class DoubleLongIndex
implements LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private long[] keys;
    private long[] values;
    private long targetSearchValue;

    public DoubleLongIndex(int n2) {
        this.capacity = n2;
        this.keys = new long[n2];
        this.values = new long[n2];
    }

    @Override
    public long getLongKey(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n2];
    }

    @Override
    public long getLongValue(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n2];
    }

    @Override
    public void setLongValue(int n2, long l2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.values[n2] = l2;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public long getTotalValues() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.count; ++i2) {
            l2 += this.values[i2];
        }
        return l2;
    }

    public void setSize(int n2) {
        this.count = n2;
    }

    @Override
    public boolean addUnsorted(long l2, long l3) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && l2 < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.keys[this.count] = l2;
        this.values[this.count] = l3;
        ++this.count;
        return true;
    }

    @Override
    public int add(long l2, long l3) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l2;
        int n2 = this.binarySlotSearch(true);
        if (this.count != n2) {
            this.moveRows(n2, n2 + 1, this.count - n2);
        }
        this.keys[n2] = l2;
        this.values[n2] = l3;
        ++this.count;
        return n2;
    }

    @Override
    public long lookup(long l2) throws NoSuchElementException {
        int n2 = this.findFirstEqualKeyIndex(l2);
        if (n2 == -1) {
            throw new NoSuchElementException();
        }
        return this.getLongValue(n2);
    }

    @Override
    public long lookup(long l2, long l3) {
        int n2 = this.findFirstEqualKeyIndex(l2);
        if (n2 == -1) {
            return l3;
        }
        return this.getLongValue(n2);
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, 0L);
        this.count = 0;
        this.sorted = true;
    }

    @Override
    public LongLookup duplicate() {
        DoubleLongIndex doubleLongIndex = new DoubleLongIndex(this.capacity);
        this.copyTo(doubleLongIndex);
        return doubleLongIndex;
    }

    public int findFirstGreaterEqualKeyIndex(long l2) {
        int n2 = this.findFirstGreaterEqualSlotIndex(l2);
        return n2 == this.count ? -1 : n2;
    }

    public int findFirstEqualKeyIndex(long l2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l2;
        return this.binaryFirstSearch();
    }

    public int findFirstGreaterEqualSlotIndex(long l2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = l2;
        return this.binarySlotSearch(false);
    }

    @Override
    public boolean compactLookupAsIntervals() {
        int n2;
        if (this.size() == 0) {
            return false;
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int n3 = 0;
        for (n2 = 1; n2 < this.count; ++n2) {
            long l2 = this.keys[n3] + this.values[n3];
            if (l2 == this.keys[n2]) {
                int n4 = n3;
                this.values[n4] = this.values[n4] + this.values[n2];
                continue;
            }
            this.keys[++n3] = this.keys[n2];
            this.values[n3] = this.values[n2];
        }
        for (n2 = n3 + 1; n2 < this.count; ++n2) {
            this.keys[n2] = 0L;
            this.values[n2] = 0L;
        }
        if (this.count != n3 + 1) {
            this.setSize(n3 + 1);
            return true;
        }
        return false;
    }

    private int binaryFirstSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.count;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
            n6 = n4;
        }
        return n6 == this.count ? -1 : n6;
    }

    private int binarySlotSearch(boolean bl) {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 <= 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    @Override
    public void sort() {
        if (this.count <= 16384) {
            this.fastQuickSortRecursive();
        } else {
            this.fastQuickSort();
        }
    }

    private void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32768);
        int n2 = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n3 = doubleIntIndex.peekKey();
            int n4 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n4 - n3 < n2) continue;
            int n5 = this.partition(n3, n4);
            doubleIntIndex.push(n3, n5 - 1);
            doubleIntIndex.push(n5 + 1, n4);
        }
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private int partition(int n2, int n3) {
        int n4 = n2 + n3 >>> 1;
        if (this.keys[n4] < this.keys[n2 + n4 >>> 1]) {
            this.swap(n4, n2 + n4 >>> 1);
        }
        if (this.keys[n3 + n4 >>> 1] < this.keys[n2 + n4 >>> 1]) {
            this.swap(n3 + n4 >>> 1, n2 + n4 >>> 1);
        }
        if (this.keys[n3 + n4 >>> 1] < this.keys[n4]) {
            this.swap(n3 + n4 >>> 1, n4);
        }
        long l2 = this.keys[n4];
        int n5 = n2 - 1;
        int n6 = n3;
        this.swap(n4, n3);
        while (true) {
            if (this.keys[++n5] < l2) {
                continue;
            }
            while (l2 < this.keys[--n6]) {
            }
            if (n6 < n5) break;
            this.swap(n5, n6);
        }
        this.swap(n5, n3);
        return n5;
    }

    private void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n2, int n3) {
        int n4 = 16;
        if (n3 - n2 > n4) {
            int n5 = n3 + n2 >>> 1;
            if (this.lessThan(n5, n2)) {
                this.swap(n2, n5);
            }
            if (this.lessThan(n3, n2)) {
                this.swap(n2, n3);
            }
            if (this.lessThan(n3, n5)) {
                this.swap(n5, n3);
            }
            int n6 = n3 - 1;
            this.swap(n5, n6);
            n5 = n2;
            int n7 = n6;
            while (true) {
                if (this.lessThan(++n5, n7)) {
                    continue;
                }
                while (this.lessThan(n7, --n6)) {
                }
                if (n6 < n5) break;
                this.swap(n5, n6);
            }
            this.swap(n5, n3 - 1);
            this.quickSort(n2, n6);
            this.quickSort(n5 + 1, n3);
        }
    }

    private void insertionSort(int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 > n2 && this.lessThan(i2, n4 - 1); --n4) {
            }
            if (i2 == n4) continue;
            this.moveAndInsertRow(i2, n4);
        }
    }

    private void moveAndInsertRow(int n2, int n3) {
        long l2 = this.keys[n2];
        long l3 = this.values[n2];
        this.moveRows(n3, n3 + 1, n2 - n3);
        this.keys[n3] = l2;
        this.values[n3] = l3;
    }

    private void swap(int n2, int n3) {
        long l2 = this.keys[n2];
        long l3 = this.values[n2];
        this.keys[n2] = this.keys[n3];
        this.values[n2] = this.values[n3];
        this.keys[n3] = l2;
        this.values[n3] = l3;
    }

    private int compare(int n2) {
        if (this.targetSearchValue > this.keys[n2]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n2]) {
            return -1;
        }
        return 0;
    }

    private boolean lessThan(int n2, int n3) {
        return this.keys[n2] < this.keys[n3];
    }

    private void moveRows(int n2, int n3, int n4) {
        System.arraycopy(this.keys, n2, this.keys, n3, n4);
        System.arraycopy(this.values, n2, this.values, n3, n4);
    }

    private void doubleCapacity() {
        this.keys = (long[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (long[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void copyTo(DoubleLongIndex doubleLongIndex) {
        System.arraycopy(this.keys, 0, doubleLongIndex.keys, 0, this.count);
        System.arraycopy(this.values, 0, doubleLongIndex.values, 0, this.count);
        doubleLongIndex.setSize(this.count);
    }

    @Override
    public boolean addUnsorted(LongLookup longLookup) {
        if (!this.ensureCapacityToAdd(longLookup.size())) {
            return false;
        }
        this.sorted = false;
        for (int i2 = 0; i2 < longLookup.size(); ++i2) {
            long l2 = longLookup.getLongKey(i2);
            long l3 = longLookup.getLongValue(i2);
            this.addUnsorted(l2, l3);
        }
        return true;
    }

    private boolean ensureCapacityToAdd(int n2) {
        if (this.count + n2 > this.capacity) {
            while (this.count + n2 > this.capacity) {
                this.doubleCapacity();
            }
        }
        return true;
    }
}

