/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.lib.StringConverter;

public class DataOutputStream
extends BufferedOutputStream
implements DataOutput {
    byte[] tempBuffer = new byte[8];

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream, 8);
    }

    @Override
    public final void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    @Override
    public final void writeInt(int n2) throws IOException {
        int n3 = 0;
        this.tempBuffer[n3++] = (byte)(n2 >>> 24);
        this.tempBuffer[n3++] = (byte)(n2 >>> 16);
        this.tempBuffer[n3++] = (byte)(n2 >>> 8);
        this.tempBuffer[n3++] = (byte)n2;
        this.write(this.tempBuffer, 0, n3);
    }

    @Override
    public final void writeLong(long l2) throws IOException {
        this.writeInt((int)(l2 >>> 32));
        this.writeInt((int)l2);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        int n3 = 0;
        this.tempBuffer[n3++] = (byte)(n2 >>> 8);
        this.tempBuffer[n3++] = (byte)n2;
        this.write(this.tempBuffer, 0, n3);
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            int n3 = 0;
            this.tempBuffer[n3++] = (byte)(c2 >>> 8);
            this.tempBuffer[n3++] = (byte)c2;
            this.write(this.tempBuffer, 0, n3);
        }
    }

    public void writeChars(char[] cArray) throws IOException {
        this.writeChars(cArray, cArray.length);
    }

    public void writeChars(char[] cArray, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            int n3 = 0;
            this.tempBuffer[n3++] = (byte)(c2 >>> 8);
            this.tempBuffer[n3++] = (byte)c2;
            this.write(this.tempBuffer, 0, n3);
        }
    }

    public long write(Reader reader, long l2) throws IOException {
        ReaderInputStream readerInputStream = new ReaderInputStream(reader);
        return this.write(readerInputStream, l2 * 2L) / 2L;
    }

    public long write(InputStream inputStream, long l2) throws IOException {
        byte[] byArray = new byte[1024];
        long l3 = 0L;
        while (true) {
            long l4;
            if ((l4 = l2 - l3) > (long)byArray.length) {
                l4 = byArray.length;
            }
            if ((l4 = (long)inputStream.read(byArray, 0, (int)l4)) < 1L) break;
            this.write(byArray, 0, (int)l4);
            l3 += l4;
        }
        return l3;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        int n2 = bl ? 1 : 0;
        this.write(n2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        int n3 = 0;
        this.tempBuffer[n3++] = (byte)(n2 >> 8);
        this.tempBuffer[n3++] = (byte)n2;
        this.write(this.tempBuffer, 0, n3);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.out.write((byte)string.charAt(i2));
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        int n2 = string.length();
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        int n3 = StringConverter.getUTFSize(string);
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeChar(n3);
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n3);
        StringConverter.stringToUTFBytes(string, hsqlByteArrayOutputStream);
        this.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
    }
}

