/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ClosableByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableByteArrayOutputStream() {
        this(32);
    }

    public ClosableByteArrayOutputStream(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new byte[n2];
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        this.checkClosed();
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n4));
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        this.checkFreed();
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized byte[] toByteArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n2 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
        }
        this.count = n2;
    }

    public synchronized ByteArrayInputStream toByteArrayInputStream() throws IOException {
        this.checkFreed();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf, 0, this.count);
        this.free();
        return byteArrayInputStream;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    public synchronized String toString(String string) throws IOException, UnsupportedEncodingException {
        this.checkFreed();
        return new String(this.buf, 0, this.count, string);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("stream buffer is freed.");
        }
    }

    protected byte[] copyOf(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        return byArray2;
    }
}

