/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Comparator;

public final class ArraySort {
    public static int searchFirst(Object[] objectArray, int n2, int n3, Object object, Comparator comparator) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n3;
        while (n4 < n5) {
            int n7 = n4 + n5 >>> 1;
            int n8 = comparator.compare(object, objectArray[n7]);
            if (n8 < 0) {
                n5 = n7;
                continue;
            }
            if (n8 > 0) {
                n4 = n7 + 1;
                continue;
            }
            n5 = n7;
            n6 = n7;
        }
        return n6 == n3 ? -n4 - 1 : n6;
    }

    public static int deDuplicate(Object[] objectArray, int n2, Comparator comparator) {
        int n3 = 0;
        if (n2 < 2) {
            return n2;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            int n4 = comparator.compare(objectArray[n3], objectArray[i2]);
            if (n4 == 0) continue;
            objectArray[++n3] = objectArray[i2];
        }
        return n3 + 1;
    }

    public static void sort(Object[] objectArray, int n2, Comparator comparator) {
        if (n2 < 2) {
            return;
        }
        ArraySort.quickSort(objectArray, comparator, 0, n2 - 1);
        ArraySort.insertionSort(objectArray, comparator, 0, n2 - 1);
    }

    static void quickSort(Object[] objectArray, Comparator comparator, int n2, int n3) {
        int n4 = 16;
        if (n3 - n2 > n4) {
            int n5 = n3 + n2 >>> 1;
            if (comparator.compare(objectArray[n5], objectArray[n2]) < 0) {
                ArraySort.swap(objectArray, n2, n5);
            }
            if (comparator.compare(objectArray[n3], objectArray[n2]) < 0) {
                ArraySort.swap(objectArray, n2, n3);
            }
            if (comparator.compare(objectArray[n3], objectArray[n5]) < 0) {
                ArraySort.swap(objectArray, n5, n3);
            }
            int n6 = n3 - 1;
            ArraySort.swap(objectArray, n5, n6);
            n5 = n2;
            int n7 = n6;
            while (true) {
                if (comparator.compare(objectArray[++n5], objectArray[n7]) < 0) {
                    continue;
                }
                while (comparator.compare(objectArray[n7], objectArray[--n6]) < 0) {
                }
                if (n6 < n5) break;
                ArraySort.swap(objectArray, n5, n6);
            }
            ArraySort.swap(objectArray, n5, n3 - 1);
            ArraySort.quickSort(objectArray, comparator, n2, n6);
            ArraySort.quickSort(objectArray, comparator, n5 + 1, n3);
        }
    }

    public static void insertionSort(Object[] objectArray, Comparator comparator, int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 > n2 && comparator.compare(objectArray[i2], objectArray[n4 - 1]) < 0; --n4) {
            }
            if (i2 == n4) continue;
            ArraySort.moveAndInsertRow(objectArray, i2, n4);
        }
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    private static void moveAndInsertRow(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        ArraySort.moveRows(objectArray, n3, n3 + 1, n2 - n3);
        objectArray[n3] = object;
    }

    private static void moveRows(Object[] objectArray, int n2, int n3, int n4) {
        System.arraycopy(objectArray, n2, objectArray, n3, n4);
    }
}

