/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;

public class JDBCXAConnectionWrapper
extends JDBCConnection {
    private JDBCXAResource xaResource;

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.validateNotWithinTransaction();
        super.setAutoCommit(bl);
    }

    @Override
    public void commit() throws SQLException {
        this.validateNotWithinTransaction();
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint(string);
    }

    @Override
    public void setTransactionIsolation(int n2) throws SQLException {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(n2);
    }

    public JDBCXAConnectionWrapper(JDBCXAResource jDBCXAResource, JDBCXAConnection jDBCXAConnection, JDBCConnection jDBCConnection) throws SQLException {
        super(jDBCConnection, jDBCXAConnection);
        jDBCXAResource.setConnection(this);
        this.xaResource = jDBCXAResource;
    }

    private void validateNotWithinTransaction() throws SQLException {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }
}

