/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCColumnMetaData;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private ResultMetaData resultMetaData;
    private boolean useColumnName;
    private boolean translateTTIType;
    private int columnCount;

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        if (type.isCharacterType()) {
            return type.getCollation().isCaseSensitive();
        }
        return false;
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].isSearchable();
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return (type.typeCode == 3 || type.typeCode == 2) && type.scale > 0;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].getNullability();
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.isNumberType();
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.displaySize();
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        this.checkColumn(n2--);
        String string = this.resultMetaData.columnLabels[n2];
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.resultMetaData.columns[n2].getNameString();
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        String string;
        this.checkColumn(n2--);
        if (this.useColumnName && (string = this.resultMetaData.columns[n2].getNameString()) != null && string.length() > 0) {
            return string;
        }
        string = this.resultMetaData.columnLabels[n2];
        return string == null ? this.resultMetaData.columns[n2].getNameString() : string;
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getSchemaNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.getJDBCPrecision();
    }

    @Override
    public int getScale(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.getJDBCScale();
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getTableNameString();
        return string == null ? "" : string;
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getCatalogNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.getNameString();
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        this.checkColumn(n2);
        return !this.resultMetaData.columns[--n2].isWriteable();
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n2] > -1;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n2] > -1;
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return type.getJDBCClassName();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCResultSetMetaData(ResultMetaData resultMetaData, boolean bl, boolean bl2, JDBCConnection jDBCConnection) throws SQLException {
        this.init(resultMetaData, jDBCConnection);
    }

    void init(ResultMetaData resultMetaData, JDBCConnection jDBCConnection) throws SQLException {
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.useColumnName = true;
        if (jDBCConnection == null) {
            return;
        }
        this.useColumnName = jDBCConnection.isUseColumnName;
        this.translateTTIType = jDBCConnection.isTranslateTTIType;
    }

    private void checkColumn(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n2));
        }
    }

    private Type translateType(Type type) {
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        return type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (this.columnCount == 0) {
            stringBuilder.append("[columnCount=0]");
            return stringBuilder.toString();
        }
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            JDBCColumnMetaData jDBCColumnMetaData = this.getColumnMetaData(i2 + 1);
            stringBuilder.append('\n');
            stringBuilder.append("   column_");
            stringBuilder.append(i2 + 1);
            stringBuilder.append('=');
            stringBuilder.append(jDBCColumnMetaData);
            if (i2 + 1 >= this.columnCount) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append('\n');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    JDBCColumnMetaData getColumnMetaData(int n2) {
        JDBCColumnMetaData jDBCColumnMetaData = new JDBCColumnMetaData();
        try {
            jDBCColumnMetaData.catalogName = this.getCatalogName(n2);
            jDBCColumnMetaData.columnClassName = this.getColumnClassName(n2);
            jDBCColumnMetaData.columnDisplaySize = this.getColumnDisplaySize(n2);
            jDBCColumnMetaData.columnLabel = this.getColumnLabel(n2);
            jDBCColumnMetaData.columnName = this.getColumnName(n2);
            jDBCColumnMetaData.columnType = this.getColumnType(n2);
            jDBCColumnMetaData.isAutoIncrement = this.isAutoIncrement(n2);
            jDBCColumnMetaData.isCaseSensitive = this.isCaseSensitive(n2);
            jDBCColumnMetaData.isCurrency = this.isCurrency(n2);
            jDBCColumnMetaData.isDefinitelyWritable = this.isDefinitelyWritable(n2);
            jDBCColumnMetaData.isNullable = this.isNullable(n2);
            jDBCColumnMetaData.isReadOnly = this.isReadOnly(n2);
            jDBCColumnMetaData.isSearchable = this.isSearchable(n2);
            jDBCColumnMetaData.isSigned = this.isSigned(n2);
            jDBCColumnMetaData.isWritable = this.isWritable(n2);
            jDBCColumnMetaData.precision = this.getPrecision(n2);
            jDBCColumnMetaData.scale = this.getScale(n2);
            jDBCColumnMetaData.schemaName = this.getSchemaName(n2);
            jDBCColumnMetaData.tableName = this.getTableName(n2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return jDBCColumnMetaData;
    }
}

