/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.hsqldb.jdbc.pool.JDBCPooledDataSource;

public class JDBCPool
implements DataSource,
Referenceable,
ConnectionEventListener,
StatementEventListener,
Wrapper {
    AtomicIntegerArray states;
    JDBCPooledConnection[] connections;
    JDBCPooledDataSource source = new JDBCPooledDataSource();
    volatile boolean closed;

    @Override
    public Connection getConnection() throws SQLException {
        int n2 = 300;
        if (this.source.loginTimeout != 0) {
            n2 = this.source.loginTimeout * 10;
        }
        if (this.closed) {
            throw new SQLException("connection pool is closed");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < this.states.length(); ++i3) {
                if (this.states.compareAndSet(i3, 1, 2)) {
                    return this.connections[i3].getConnection();
                }
                if (!this.states.compareAndSet(i3, 0, 2)) continue;
                try {
                    JDBCPooledConnection jDBCPooledConnection = (JDBCPooledConnection)this.source.getPooledConnection();
                    jDBCPooledConnection.addConnectionEventListener(this);
                    jDBCPooledConnection.addStatementEventListener(this);
                    this.connections[i3] = jDBCPooledConnection;
                    return this.connections[i3].getConnection();
                }
                catch (SQLException sQLException) {
                    this.states.set(i3, 0);
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        String string3 = this.getUser();
        if (string == null || string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string3 == null) {
            this.setUser(string);
            this.setPassword(string2);
        } else if (!string3.equals(string)) {
            throw JDBCUtil.invalidArgument("user name does not match");
        }
        return this.getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.source.getDatabase()));
        reference.add(new StringRefAddr("user", this.source.getUser()));
        reference.add(new StringRefAddr("password", this.source.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.source.loginTimeout)));
        reference.add(new StringRefAddr("poolSize", Integer.toString(this.connections.length)));
        return reference;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] != pooledConnection) continue;
            this.states.set(i2, 1);
            break;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] != pooledConnection) continue;
            this.states.set(i2, 2);
            this.connections[i2] = null;
            this.states.set(i2, 0);
            break;
        }
    }

    @Override
    public void statementClosed(StatementEvent statementEvent) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent statementEvent) {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.source.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n2) throws SQLException {
        this.source.setLoginTimeout(n2);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    public String getDescription() {
        return "org.hsqldb.jdbc.JDBCPool max size " + this.connections.length;
    }

    public String getDataSourceName() {
        return "org.hsqldb.jdbc.JDBCPool";
    }

    public String getDatabaseName() {
        return this.source.getUrl();
    }

    public String getDatabase() {
        return this.source.getDatabase();
    }

    public String getUrl() {
        return this.source.getUrl();
    }

    public String getURL() {
        return this.source.getUrl();
    }

    public String getUser() {
        return this.source.getUser();
    }

    public void setDatabaseName(String string) {
        this.source.setDatabaseName(string);
    }

    public void setDatabase(String string) {
        this.source.setDatabase(string);
    }

    public void setUrl(String string) {
        this.source.setUrl(string);
    }

    public void setURL(String string) {
        this.source.setUrl(string);
    }

    public void setPassword(String string) {
        this.source.setPassword(string);
    }

    public void setUser(String string) {
        this.source.setUser(string);
    }

    public void setProperties(Properties properties) {
        this.source.setProperties(properties);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    public JDBCPool() {
        this(10);
    }

    public JDBCPool(int n2) {
        this.connections = new JDBCPooledConnection[n2];
        this.states = new AtomicIntegerArray(n2);
    }

    public void close(int n2) throws SQLException {
        if (n2 < 0 || n2 > 60) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Thread.sleep(1000 * n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] == null) continue;
            this.connections[i2].release();
        }
        Arrays.fill(this.connections, null);
    }

    static interface RefState {
        public static final int empty = 0;
        public static final int available = 1;
        public static final int allocated = 2;
    }
}

