/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    @Override
    public synchronized void registerOutParameter(int n2, int n3) throws SQLException {
        this.checkGetParameterIndex(n2);
        if (this.parameterModes[--n2] == 1) {
            throw JDBCUtil.invalidArgument();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.resultIn.mode == 43 && this.resultIn.getChainedResult() != null) {
            this.getMoreResults();
        }
        return super.getResultSet();
    }

    @Override
    public synchronized void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2, n3);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int n2) throws SQLException {
        return (String)this.getColumnInType(n2, Type.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public synchronized byte getByte(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public synchronized short getShort(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public synchronized int getInt(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public synchronized long getLong(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public synchronized float getFloat(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public synchronized double getDouble(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n3 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n3, RoundingMode.DOWN);
        }
        return bigDecimal;
    }

    @Override
    public synchronized byte[] getBytes(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public synchronized Date getDate(int n2) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Time getTime(int n2) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n2, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Object getObject(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type = this.parameterTypes[n2 - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 94: {
                return this.getTimeWithZone(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case 95: {
                return this.getTimestampWithZone(n2);
            }
            case 60: 
            case 61: {
                return this.getBytes(n2);
            }
            case 14: {
                boolean bl = this.getBoolean(n2);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n2);
            }
            case 30: {
                return this.getBlob(n2);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n2, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n2, type);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type type = this.parameterMetaData.columnTypes[n2 - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n2, type);
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type = this.parameterMetaData.columnTypes[n2 - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.parameterValues[n2 - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    @Override
    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l2 = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l2 = HsqlDateTime.convertMillisToCalendar(calendar, l2);
        }
        return new Date(l2);
    }

    @Override
    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n2, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l2 = (long)DateTimeType.normaliseTime(timeData.getSeconds()) * 1000L;
        if (!this.parameterMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l2 = HsqlDateTime.convertMillisToCalendar(calendar2, l2);
            l2 = HsqlDateTime.getNormalisedTime(l2);
        }
        return new Time(l2);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l2 = timestampData.getSeconds() * 1000L;
        if (!this.parameterMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l2 = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l2);
            }
        }
        comparable = new Timestamp(l2);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    @Override
    public synchronized void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.registerOutParameter(n2, n3);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParameterIndex(string), uRL);
    }

    @Override
    public synchronized void setNull(String string, int n2) throws SQLException {
        this.setNull(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParameterIndex(string), bl);
    }

    @Override
    public synchronized void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParameterIndex(string), by);
    }

    @Override
    public synchronized void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParameterIndex(string), s);
    }

    @Override
    public synchronized void setInt(String string, int n2) throws SQLException {
        this.setInt(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void setLong(String string, long l2) throws SQLException {
        this.setLong(this.findParameterIndex(string), l2);
    }

    @Override
    public synchronized void setFloat(String string, float f2) throws SQLException {
        this.setFloat(this.findParameterIndex(string), f2);
    }

    @Override
    public synchronized void setDouble(String string, double d2) throws SQLException {
        this.setDouble(this.findParameterIndex(string), d2);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setString(String string, String string2) throws SQLException {
        this.setString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParameterIndex(string), date);
    }

    @Override
    public synchronized void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParameterIndex(string), time);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n2);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n2, int n3) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n2, n3);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n2) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParameterIndex(string), object);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(string), reader, n2);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setNull(String string, int n2, String string2) throws SQLException {
        this.setNull(this.findParameterIndex(string), n2, string2);
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findParameterIndex(string));
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameterIndex(string));
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findParameterIndex(string));
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findParameterIndex(string));
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameterIndex(string));
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameterIndex(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameterIndex(string), map);
    }

    @Override
    public synchronized Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameterIndex(string));
    }

    @Override
    public synchronized Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setRowId(String string, RowId rowId) throws SQLException {
        super.setRowId(this.findParameterIndex(string), rowId);
    }

    @Override
    public synchronized void setNString(String string, String string2) throws SQLException {
        super.setNString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public synchronized void setNClob(String string, NClob nClob) throws SQLException {
        super.setNClob(this.findParameterIndex(string), nClob);
    }

    @Override
    public synchronized void setClob(String string, Reader reader, long l2) throws SQLException {
        super.setClob(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        super.setBlob(this.findParameterIndex(string), inputStream, l2);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader, long l2) throws SQLException {
        super.setNClob(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        super.setSQLXML(this.findParameterIndex(string), sQLXML);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(string));
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized String getNString(String string) throws SQLException {
        return this.getNString(this.findParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setBlob(String string, Blob blob) throws SQLException {
        super.setBlob(this.findParameterIndex(string), blob);
    }

    @Override
    public synchronized void setClob(String string, Clob clob) throws SQLException {
        super.setClob(this.findParameterIndex(string), clob);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum ASCII input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setAsciiStream(string, inputStream, (int)l2);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum Binary input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setBinaryStream(string, inputStream, (int)l2);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum character input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setCharacterStream(string, reader, (int)l2);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        super.setAsciiStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        super.setBinaryStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader) throws SQLException {
        super.setCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setClob(String string, Reader reader) throws SQLException {
        super.setClob(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream) throws SQLException {
        super.setBlob(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader) throws SQLException {
        super.setNClob(this.findParameterIndex(string), reader);
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findParameterIndex(string), clazz);
    }

    public JDBCCallableStatement(JDBCConnection jDBCConnection, String string, int n2, int n3, int n4) throws HsqlException, SQLException {
        super(jDBCConnection, string, n2, n3, n4, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] stringArray = this.parameterMetaData.columnLabels;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2 == null || string2.isEmpty()) continue;
                this.parameterNameMap.put(string2, i2);
            }
        }
    }

    @Override
    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] objectArray = this.resultIn.getParameterData();
            System.arraycopy(objectArray, 0, this.parameterValues, 0, this.parameterValues.length);
        }
    }

    int findParameterIndex(String string) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        int n2 = this.parameterNameMap.get((Object)string, -1);
        if (n2 >= 0) {
            return n2 + 1;
        }
        n2 = this.parameterNameMap.get((Object)string.toUpperCase(Locale.ENGLISH), -1);
        if (n2 >= 0) {
            return n2 + 1;
        }
        throw JDBCUtil.sqlException(421, string);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int n2, Type type) throws SQLException {
        this.checkGetParameterIndex(n2);
        Type type2 = this.parameterTypes[--n2];
        Object object = this.parameterValues[n2];
        if (this.trackNull(object)) {
            return null;
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (HsqlException hsqlException) {
                String string = object instanceof Number || object instanceof String || object instanceof java.util.Date ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                throw JDBCUtil.sqlException(5561, string2);
            }
        }
        return object;
    }

    private Object getTimestampWithZone(int n2) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (timestampData == null) {
            return null;
        }
        return Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    private Object getTimeWithZone(int n2) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n2, Type.SQL_TIME_WITH_TIME_ZONE);
        if (timeData == null) {
            return null;
        }
        return Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.fetchResult();
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet;
        }
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw JDBCUtil.sqlException(1254);
    }
}

