/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;

public class IndexStats {
    public static final IndexStats[] emptyArray = new IndexStats[0];
    public static final int sizes = 1;
    public static final int checkSpaces = 2;
    public static final int checkRows = 3;
    public static final int checkIndexSpaces = 4;
    public static final int setVersion = 5;
    public static final int findRoots = 6;
    public static final int fixAll = 8;
    public Index index;
    public PersistentStore store;
    public boolean hasErrors;
    public long errorCount;
    public long loopCount;
    public long goodRowCount;
    public boolean reindexed;
    HsqlArrayList unorderedList = new HsqlArrayList();

    public static Result newEmptyResult() {
        Result result = Result.newDoubleColumnResult("TABLE_OR_INDEX_NAME", "INFO");
        return result;
    }

    public void addTableStats(Result result) {
        String[] stringArray = new String[]{"TABLE " + ((Table)this.index.getTable()).getName().getSchemaQualifiedStatementName(), "rows " + this.store.elementCount()};
        result.addRow(stringArray);
    }

    public void addStats(Result result) {
        String[] stringArray = new String[]{this.index.getName().getStatementName(), "readable rows " + this.goodRowCount};
        result.addRow(stringArray);
        if (this.errorCount != 0L) {
            stringArray = new String[]{"", "error rows " + this.errorCount};
            result.addRow(stringArray);
        }
        if (this.loopCount != 0L) {
            stringArray = new String[]{"", "loop rows " + this.loopCount};
            result.addRow(stringArray);
        }
        for (int i2 = 0; i2 < this.unorderedList.size(); ++i2) {
            String[] stringArray2 = new String[]{"", (String)this.unorderedList.get(i2)};
            result.addRow(stringArray2);
        }
    }

    public void addReindexedStats(Result result) {
        String[] stringArray = new String[]{this.index.getName().getStatementName(), "reindexed"};
        result.addRow(stringArray);
    }
}

