/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexStats;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.OrderedLongHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;

public class IndexAVLCheck {
    public static Result checkAllTables(Session session, int n2) {
        Result result = IndexStats.newEmptyResult();
        HsqlArrayList hsqlArrayList = session.database.schemaManager.getAllTables(true);
        int n3 = hsqlArrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Table table = (Table)hsqlArrayList.get(i2);
            if (!table.isCached()) continue;
            IndexAVLCheck.checkTable(session, table, result, n2);
        }
        return result;
    }

    public static Result checkTable(Session session, Table table, int n2) {
        Result result = IndexStats.newEmptyResult();
        if (!table.isCached()) {
            return result;
        }
        IndexAVLCheck.checkTable(session, table, result, n2);
        return result;
    }

    public static void checkTable(Session session, Table table, Result result, int n2) {
        int n3;
        RowStoreAVL rowStoreAVL = (RowStoreAVL)table.database.persistentStoreCollection.getStore(table);
        IndexStats[] indexStatsArray = rowStoreAVL.checkIndexes(session, n2);
        indexStatsArray[0].addTableStats(result);
        for (n3 = 0; n3 < indexStatsArray.length; ++n3) {
            indexStatsArray[n3].addStats(result);
        }
        if (n2 == 8) {
            int n4;
            n3 = 0;
            for (n4 = 0; n4 < indexStatsArray.length; ++n4) {
                if (!indexStatsArray[n4].hasErrors) continue;
                n3 = 1;
            }
            if (n3 != 0) {
                IndexAVLCheck.reindexTable(session, table, rowStoreAVL, indexStatsArray);
                for (n4 = 0; n4 < indexStatsArray.length; ++n4) {
                    if (!indexStatsArray[n4].reindexed) continue;
                    indexStatsArray[n4].addReindexedStats(result);
                }
            }
        }
    }

    public static void reindexTable(Session session, Table table, PersistentStore persistentStore, IndexStats[] indexStatsArray) {
        int n2;
        Index index = null;
        boolean bl = false;
        for (n2 = 0; n2 < indexStatsArray.length; ++n2) {
            if (indexStatsArray[n2].hasErrors) continue;
            index = table.getIndex(n2);
            break;
        }
        if (index == null) {
            session.database.logger.logSevereEvent("could not recreate damaged indexes for table: " + table.getName().statementName, null);
            return;
        }
        for (n2 = 0; n2 < indexStatsArray.length; ++n2) {
            if (!indexStatsArray[n2].hasErrors) continue;
            Index index2 = table.getIndex(n2);
            persistentStore.reindex(session, index2, index);
            indexStatsArray[n2].reindexed = true;
            bl = true;
        }
        if (bl) {
            session.database.logger.logSevereEvent("recreated damaged indexes for table: " + table.getName().statementName, null);
        }
    }

    public static class IndexAVLProbe {
        static final int maxDepth = 16;
        final int fileBlockItemCount;
        final int cacheScale;
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        final NodeAVLDisk rootNode;
        IntKeyHashMap bitMaps;
        IntKeyHashMap bitMapsPos;
        OrderedLongHashSet badRows;
        OrderedLongHashSet loopedRows;
        OrderedLongHashSet ignoreRows;
        HsqlArrayList unorderedRows = new HsqlArrayList();
        int branchPosition;
        int leafPosition;
        long errorRowCount;
        long rowCount;
        long loopCount;
        boolean printErrors = false;

        public IndexAVLProbe(Session session, PersistentStore persistentStore, IndexAVL indexAVL, NodeAVL nodeAVL) {
            DataFileCache dataFileCache = persistentStore.getCache();
            this.fileBlockItemCount = dataFileCache == null ? 0 : persistentStore.getCache().spaceManager.getFileBlockItemCount();
            this.cacheScale = dataFileCache == null ? 0 : persistentStore.getCache().getDataFileScale();
            this.session = session;
            this.store = persistentStore;
            this.index = indexAVL;
            this.rootNode = dataFileCache == null ? null : (NodeAVLDisk)nodeAVL;
        }

        public IndexStats getStats() {
            IndexStats indexStats = new IndexStats();
            indexStats.index = this.index;
            indexStats.store = this.store;
            indexStats.errorCount = this.errorRowCount;
            indexStats.loopCount = this.loopCount;
            indexStats.goodRowCount = this.rowCount;
            indexStats.unorderedList = this.unorderedRows;
            indexStats.hasErrors = this.hasErrors();
            return indexStats;
        }

        public boolean hasErrors() {
            return this.errorRowCount != 0L || this.loopCount != 0L || !this.unorderedRows.isEmpty();
        }

        public void probe() {
            if (this.index == null) {
                return;
            }
            if (this.rootNode == null) {
                return;
            }
            if (this.fileBlockItemCount == 0) {
                return;
            }
            this.bitMaps = new IntKeyHashMap();
            this.bitMapsPos = new IntKeyHashMap();
            this.badRows = new OrderedLongHashSet();
            this.loopedRows = new OrderedLongHashSet();
            this.ignoreRows = new OrderedLongHashSet();
            this.unorderedRows = new HsqlArrayList();
            RowAVL rowAVL = this.rootNode.getRow(this.store);
            this.setSpaceForRow(rowAVL);
            this.getNodesFrom(0, this.rootNode, true);
            if (!this.hasErrors()) {
                this.checkIndexOrder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkIndexOrder() {
            int n2 = 0;
            this.store.readLock();
            try {
                NodeAVL nodeAVL;
                NodeAVL nodeAVL2 = null;
                for (nodeAVL = this.index.getAccessor(this.store); nodeAVL != null; nodeAVL = nodeAVL.getLeft(this.store)) {
                    nodeAVL2 = nodeAVL;
                }
                nodeAVL = nodeAVL2;
                while (nodeAVL2 != null) {
                    int n3;
                    n2 += this.checkNodes(nodeAVL2, this.unorderedRows);
                    NodeAVL nodeAVL3 = this.index.next(this.store, nodeAVL2);
                    if (nodeAVL3 != null && (n3 = this.index.compareRowForInsertOrDelete(this.session, nodeAVL3.getRow(this.store), nodeAVL2.getRow(this.store), true, 0)) <= 0) {
                        if (n2 < 10) {
                            this.unorderedRows.add("broken index order ");
                        }
                        ++n2;
                    }
                    nodeAVL2 = nodeAVL3;
                }
            }
            finally {
                this.store.readUnlock();
            }
        }

        int checkNodes(NodeAVL nodeAVL, HsqlArrayList hsqlArrayList) {
            NodeAVLDisk nodeAVLDisk = (NodeAVLDisk)nodeAVL.getLeft(this.store);
            NodeAVLDisk nodeAVLDisk2 = (NodeAVLDisk)nodeAVL.getRight(this.store);
            int n2 = 0;
            if (nodeAVLDisk != null && nodeAVLDisk.iBalance == -2) {
                hsqlArrayList.add("broken index - deleted");
                ++n2;
            }
            if (nodeAVLDisk2 != null && nodeAVLDisk2.iBalance == -2) {
                hsqlArrayList.add("broken index -deleted");
                ++n2;
            }
            if (nodeAVLDisk != null && nodeAVL.getPos() != nodeAVLDisk.getParentPos()) {
                hsqlArrayList.add("broken index - no parent");
                ++n2;
            }
            if (nodeAVLDisk2 != null && nodeAVL.getPos() != nodeAVLDisk2.getParentPos()) {
                hsqlArrayList.add("broken index - no parent");
                ++n2;
            }
            return n2;
        }

        public TableBase getCurrentTable() {
            return this.index.getTable();
        }

        public long getErrorCount() {
            return this.errorRowCount;
        }

        public IntKeyHashMap getBitMaps() {
            return this.bitMaps;
        }

        public OrderedLongHashSet getBadRowPosList() {
            return this.badRows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNodesFrom(int n2, NodeAVLDisk nodeAVLDisk, boolean bl) {
            NodeAVLDisk nodeAVLDisk2;
            if (nodeAVLDisk == null) {
                return;
            }
            long l2 = nodeAVLDisk.getPos();
            if (!this.recordRowPos(l2)) {
                this.loopedRows.add(l2);
                return;
            }
            ++this.rowCount;
            if (!bl) {
                this.ignoreRows.add(l2);
            }
            long l3 = nodeAVLDisk.getLeftPos();
            try {
                if (this.badRows.contains(l3)) {
                    return;
                }
                NodeAVLDisk nodeAVLDisk3 = (NodeAVLDisk)nodeAVLDisk.getLeft(this.store);
                if (nodeAVLDisk3 != null) {
                    RowAVL rowAVL = nodeAVLDisk3.getRow(this.store);
                    if (this.setSpaceForRow(rowAVL)) {
                        this.getNodesFrom(n2 + 1, nodeAVLDisk3, true);
                        if (nodeAVLDisk3.getParentPos() != l2) {
                            nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(l3);
                    }
                }
            }
            catch (HsqlException hsqlException) {
                RowInputBinary rowInputBinary = (RowInputBinary)hsqlException.info;
                if (rowInputBinary != null) {
                    rowInputBinary.ignoreDataErrors = true;
                    try {
                        nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getLeft(this.store);
                        this.getNodesFrom(n2 + 1, nodeAVLDisk2, false);
                    }
                    catch (Throwable throwable) {
                        this.badRows.add((int)l3);
                    }
                    finally {
                        rowInputBinary.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable throwable) {
                ++this.errorRowCount;
            }
            long l4 = nodeAVLDisk.getRightPos();
            try {
                if (this.badRows.contains(l4)) {
                    return;
                }
                nodeAVLDisk2 = (NodeAVLDisk)nodeAVLDisk.getRight(this.store);
                if (nodeAVLDisk2 != null) {
                    RowAVL rowAVL = nodeAVLDisk2.getRow(this.store);
                    if (this.setSpaceForRow(rowAVL)) {
                        this.getNodesFrom(n2 + 1, nodeAVLDisk2, true);
                        if (nodeAVLDisk2.getParentPos() != l2) {
                            NodeAVLDisk nodeAVLDisk4 = (NodeAVLDisk)nodeAVLDisk.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(l4);
                    }
                }
            }
            catch (HsqlException hsqlException) {
                RowInputBinary rowInputBinary = (RowInputBinary)hsqlException.info;
                if (rowInputBinary != null) {
                    rowInputBinary.ignoreDataErrors = true;
                    try {
                        NodeAVLDisk nodeAVLDisk5 = (NodeAVLDisk)nodeAVLDisk.getRight(this.store);
                        this.getNodesFrom(n2 + 1, nodeAVLDisk5, false);
                    }
                    catch (Throwable throwable) {
                        this.badRows.add(l4);
                    }
                    finally {
                        rowInputBinary.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable throwable) {
                ++this.errorRowCount;
            }
        }

        boolean setSpaceForRow(Row row) {
            long l2 = row.getPos();
            int n2 = row.getStorageSize() / this.cacheScale;
            boolean bl = true;
            while (n2 > 0) {
                BitMap bitMap;
                int n3;
                int n4 = (int)(l2 / (long)this.fileBlockItemCount);
                int n5 = (int)(l2 % (long)this.fileBlockItemCount);
                int n6 = this.fileBlockItemCount - n5;
                if (n6 > n2) {
                    n6 = n2;
                }
                if ((n3 = (bitMap = this.getBitMap(n4)).countSet(n5, n6)) > 0) {
                    if (this.printErrors) {
                        System.out.println("index scan - row duplicate in file block " + n4 + " offset " + n5);
                    }
                    bl = false;
                } else {
                    bitMap.setRange(n5, n6);
                }
                n2 -= n6;
                l2 += (long)n6;
            }
            return bl;
        }

        BitMap getBitMap(int n2) {
            BitMap bitMap = (BitMap)this.bitMaps.get(n2);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMaps.put(n2, bitMap);
            }
            return bitMap;
        }

        boolean recordRowPos(long l2) {
            int n2 = (int)(l2 / (long)this.fileBlockItemCount);
            int n3 = (int)(l2 % (long)this.fileBlockItemCount);
            BitMap bitMap = this.getPosSet(n2);
            if (bitMap.isSet(n3)) {
                return false;
            }
            bitMap.set(n3);
            return true;
        }

        BitMap getPosSet(int n2) {
            BitMap bitMap = (BitMap)this.bitMapsPos.get(n2);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMapsPos.put(n2, bitMap);
            }
            return bitMap;
        }
    }
}

