/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();

    public TransactionManagerMV2PL(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 1;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public void setGlobalChangeTimestamp(long l2) {
        this.globalChangeTimestamp.set(l2);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    @Override
    public void setTransactionControl(Session session, int n2) {
        super.setTransactionControl(session, n2);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        this.writeLock.lock();
        try {
            int n2;
            int n3 = session.rowActionList.size();
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            for (n2 = 0; n2 < n3; ++n2) {
                RowAction rowAction = (RowAction)session.rowActionList.get(n2);
                rowAction.prepareCommit(session);
            }
            n2 = 1;
            return n2 != 0;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] objectArray;
            int n2;
            int n3 = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])session.rowActionList.get(n2);
                objectArray.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n2 = session.rowActionList.size();
            if (n2 > n3) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, n3, n2, session.actionTimestamp);
                this.finaliseRows(session, objectArray, n3, n2);
                session.rowActionList.setSize(n3);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, 0, n3, session.actionTimestamp);
                this.finaliseRows(session, objectArray, 0, n3);
            } else {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n2) {
        long l2 = session.sessionContext.savepointTimestamps.get(n2);
        Integer n3 = (Integer)session.sessionContext.savepoints.get(n2);
        int n4 = n3;
        while (session.sessionContext.savepoints.size() > n2 + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n4, l2);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n2, long l2) {
        int n3 = session.rowActionList.size();
        if (n2 == n3) {
            return;
        }
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i2);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                rowAction.rollback(session, l2);
                int n4 = rowAction.mergeRollback(session, l2);
                if (rowAction.type == 3) {
                    if (rowAction.deleteComplete) continue;
                    rowAction.deleteComplete = true;
                }
                rowAction.store.rollbackRow(session, row, n4, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(n2);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = persistentStore.addDeleteActionToRow(session, row, nArray, true);
        if (table.isTemp) {
            persistentStore.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return rowAction;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(rowAction);
    }

    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n2, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.isTemp) {
            return true;
        }
        return rowAction.canRead(session, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l2 = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long l3 = 0L;
            Object[] objectArray = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l3 = this.committedTransactionTimestamps.getFirst();
                if (l3 >= l2) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(objectArray, 0, objectArray.length, l3);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((statement = this.updateCurrentStatement(session, statement)) == null) {
                return;
            }
            boolean bl = this.setWaitedSessionsTPL(session, statement);
            if (bl) {
                session.isPreTransaction = true;
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            if (session.isTransaction) {
                session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetSession(Session session, Session session2, long l2, int n2) {
        super.resetSession(session, session2, l2, n2);
    }

    private void endTransaction(Session session) {
        long l2 = session.transactionTimestamp;
        int n2 = this.liveTransactionTimestamps.indexOf(l2);
        if (n2 >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionTimestamps.remove(n2);
            this.mergeExpiredTransactions(session);
        }
    }
}

