/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public void setGlobalChangeTimestamp(long l2) {
        this.globalChangeTimestamp.set(l2);
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int n2) {
        super.setTransactionControl(session, n2);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int n2 = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (int i2 = 0; i2 < n2; ++i2) {
                RowAction rowAction = (RowAction)session.rowActionList.get(i2);
                rowAction.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n2) {
        long l2 = session.sessionContext.savepointTimestamps.get(n2);
        Integer n3 = (Integer)session.sessionContext.savepoints.get(n2);
        int n4 = n3;
        while (session.sessionContext.savepoints.size() > n2 + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n4, l2);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    @Override
    public void rollbackPartial(Session session, int n2, long l2) {
        int n3 = session.rowActionList.size();
        if (n2 == n3) {
            return;
        }
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i2);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            rowAction.rollback(session, l2);
            int n4 = rowAction.mergeRollback(session, l2);
            rowAction.store.rollbackRow(session, row, n4, this.txModel);
        }
        session.rowActionList.setSize(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction;
        Row row2 = row;
        synchronized (row2) {
            rowAction = RowAction.addDeleteAction(session, table, persistentStore, row, nArray);
        }
        persistentStore.delete(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return rowAction;
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return;
        }
        session.rowActionList.add(rowAction);
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            this.beginTransactionCommon(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((statement = this.updateCurrentStatement(session, statement)) == null) {
                return;
            }
            boolean bl = this.setWaitedSessionsTPL(session, statement);
            if (bl) {
                session.isPreTransaction = true;
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        if (session.isTransaction) {
            session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        } else {
            this.beginTransactionCommon(session);
        }
    }

    public void removeTransactionInfo(long l2) {
    }

    @Override
    public void resetSession(Session session, Session session2, long l2, int n2) {
        super.resetSession(session, session2, l2, n2);
    }

    private void endTransaction(Session session) {
        if (session.isTransaction) {
            this.transactionCount.decrementAndGet();
        }
    }
}

