/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    Routine procedure;
    Expression[] arguments = Expression.emptyArray;
    ResultMetaData resultMetaData;

    StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(10, 2003, session.getCurrentSchemaHsqlName());
        this.statementReturnType = 2;
        if (expression.opType == 27) {
            FunctionSQLInvoked functionSQLInvoked = (FunctionSQLInvoked)expression;
            if (functionSQLInvoked.routine.returnsTable) {
                this.procedure = functionSQLInvoked.routine;
                this.arguments = functionSQLInvoked.nodes;
            } else {
                this.expression = expression;
            }
        } else {
            this.expression = expression;
        }
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (this.procedure != null) {
            session.getGrantee().checkAccess(this.procedure);
        }
        this.isTransactionStatement = this.readTableNames.length > 0 || this.writeTableNames.length > 0;
    }

    StatementProcedure(Session session, Routine routine, Expression[] expressionArray, ParserDQL.CompileContext compileContext) {
        super(10, 2003, session.getCurrentSchemaHsqlName());
        if (routine.maxDynamicResults > 0) {
            this.statementReturnType = 0;
        }
        this.procedure = routine;
        this.arguments = expressionArray;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        session.getGrantee().checkAccess(routine);
        if (routine.isPSM()) {
            this.isTransactionStatement = this.readTableNames.length > 0 || this.writeTableNames.length > 0;
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
        result.setStatementType(this.statementReturnType);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getProcedureResult(Session session) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n2;
        Object[] objectArray2 = ValuePool.emptyObjectArray;
        if (this.procedure.isPSM()) {
            n2 = this.arguments.length;
            if (this.procedure.getMaxDynamicResults() > 0) {
                ++n2;
            }
        } else {
            n2 = this.procedure.javaMethod.getParameterTypes().length;
            if (this.procedure.javaMethodWithConnection) {
                --n2;
            }
        }
        if (n2 > 0) {
            objectArray2 = new Object[n2];
        }
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            objectArray = this.arguments[i2];
            if (objectArray == null) continue;
            object2 = this.procedure.getParameter(i2).getDataType();
            object = objectArray.getValue(session);
            objectArray2[i2] = ((Type)object2).convertToType(session, object, objectArray.getDataType());
        }
        session.sessionContext.pushRoutineInvocation();
        Result result = Result.updateZeroResult;
        try {
            session.sessionContext.routineArguments = objectArray2;
            session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
            if (this.procedure.isPSM()) {
                result = this.executePSMProcedure(session);
            } else {
                object2 = session.getInternalConnection();
                result = this.executeJavaProcedure(session, (Connection)object2);
            }
            objectArray = session.sessionContext.routineArguments;
        }
        finally {
            session.sessionContext.popRoutineInvocation();
            if (!this.procedure.isPSM()) {
                session.releaseInternalConnection();
            }
        }
        if (result.isError()) {
            return result;
        }
        for (int i3 = 0; i3 < this.procedure.getParameterCount(); ++i3) {
            int n3;
            object = this.procedure.getParameter(i3);
            byte by = ((ColumnBase)object).getParameterMode();
            if (by == 1) continue;
            if (this.arguments[i3].isDynamicParam()) {
                n3 = this.arguments[i3].parameterIndex;
                session.sessionContext.dynamicArguments[n3] = objectArray[i3];
                continue;
            }
            n3 = this.arguments[i3].getColumnIndex();
            session.sessionContext.routineVariables[n3] = objectArray[i3];
        }
        Result result2 = result;
        result = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        if (this.procedure.returnsTable()) {
            result.addChainedResult(result2);
        } else if (objectArray.length > this.arguments.length) {
            result2 = (Result)objectArray[this.arguments.length];
            result.addChainedResult(result2);
        }
        return result;
    }

    Result executePSMProcedure(Session session) {
        int n2 = this.procedure.getVariableCount();
        int n3 = this.procedure.getCursorCount();
        session.sessionContext.routineVariables = new Object[n2];
        session.sessionContext.routineCursors = new Result[n3];
        Result result = this.procedure.statement.execute(session);
        if (result.isError()) {
            return result;
        }
        return result;
    }

    Result executeJavaProcedure(Session session, Connection connection) {
        Result result = Result.updateZeroResult;
        Object[] objectArray = session.sessionContext.routineArguments;
        Object[] objectArray2 = this.procedure.convertArgsToJava(session, objectArray);
        if (this.procedure.javaMethodWithConnection) {
            objectArray2[0] = connection;
        }
        result = this.procedure.invokeJavaMethod(session, objectArray2);
        this.procedure.convertArgsToSQL(session, objectArray, objectArray2);
        return result;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object object = this.expression.getValue(session);
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result result = Result.newSingleColumnResult(this.resultMetaData);
        Object[] objectArray = this.expression.getDataType().isArrayType() ? new Object[]{object} : (object instanceof Object[] ? (Object[])object : new Object[]{object});
        result.getNavigator().add(objectArray);
        return result;
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        OrderedHashSet orderedHashSet = null;
        if (this.expression != null) {
            orderedHashSet = this.expression.collectAllSubqueries(orderedHashSet);
        }
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            orderedHashSet = this.arguments[i2].collectAllSubqueries(orderedHashSet);
        }
        if (orderedHashSet == null || orderedHashSet.size() == 0) {
            return TableDerived.emptyArray;
        }
        TableDerived[] tableDerivedArray = new TableDerived[orderedHashSet.size()];
        orderedHashSet.toArray(tableDerivedArray);
        for (int i3 = 0; i3 < this.subqueries.length; ++i3) {
            tableDerivedArray[i3].prepareTable(session);
        }
        return tableDerivedArray;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 10: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
                ColumnBase columnBase = new ColumnBase(null, null, null, "@p0");
                columnBase.setType(this.expression.getDataType());
                resultMetaData.columns[0] = columnBase;
                resultMetaData.prepareData();
                this.resultMetaData = resultMetaData;
                return resultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementProcedure");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        ResultMetaData resultMetaData = super.getParametersMetaData();
        for (int i2 = 0; i2 < resultMetaData.columnLabels.length; ++i2) {
            ColumnSchema columnSchema = this.parameters[i2].getColumn();
            if (columnSchema == null || columnSchema.getName() == null) continue;
            resultMetaData.columnLabels[i2] = columnSchema.getNameString();
        }
        return resultMetaData;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForRead());
        } else {
            int n2;
            for (n2 = 0; n2 < this.subqueries.length; ++n2) {
                if (this.subqueries[n2].queryExpression == null) continue;
                this.subqueries[n2].queryExpression.getBaseTableNames(orderedHashSet);
            }
            for (n2 = 0; n2 < this.routines.length; ++n2) {
                orderedHashSet.addAll(this.routines[n2].getTableNamesForRead());
            }
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForWrite());
        }
    }
}

