/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int n2, Expression expression) {
        super(n2, 2007, null);
        switch (n2) {
            case 62: 
            case 1211: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 62: {
                return this.sql;
            }
            case 1211: {
                stringBuilder.append(this.expression.getSQL());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        BaseHashMap baseHashMap = null;
        if (this.expression != null) {
            baseHashMap = this.expression.collectAllSubqueries((OrderedHashSet)baseHashMap);
        }
        if (baseHashMap == null || baseHashMap.size() == 0) {
            return TableDerived.emptyArray;
        }
        TableDerived[] tableDerivedArray = new TableDerived[baseHashMap.size()];
        ((OrderedHashSet)baseHashMap).toArray(tableDerivedArray);
        for (int i2 = 0; i2 < this.subqueries.length; ++i2) {
            tableDerivedArray[i2].prepareTable(session);
        }
        return tableDerivedArray;
    }

    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("STATEMENT");
        return stringBuilder.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 62: 
            case 1211: {
                Result result = this.expression.getResult(session);
                if (result.isData()) {
                    RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, result.getNavigator());
                    result.setNavigator(rowSetNavigatorData);
                }
                return result;
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    String describeImpl(Session session) {
        return this.getSQL();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n2;
        for (n2 = 0; n2 < this.subqueries.length; ++n2) {
            if (this.subqueries[n2].queryExpression == null) continue;
            this.subqueries[n2].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n2 = 0; n2 < this.routines.length; ++n2) {
            orderedHashSet.addAll(this.routines[n2].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }
}

