/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementCompound;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public abstract class Statement {
    static final int META_RESET_VIEWS = 1;
    static final int META_RESET_STATEMENTS = 2;
    static final Statement[] emptyArray = new Statement[0];
    final int type;
    int group;
    boolean isLogged = true;
    boolean isValid = true;
    int statementReturnType = 1;
    HsqlNameManager.HsqlName schemaName;
    Routine root;
    StatementCompound parent;
    boolean isError;
    boolean isTransactionStatement;
    boolean isExplain;
    String sql;
    long id;
    long compileTimestamp;
    HsqlNameManager.HsqlName[] readTableNames = HsqlNameManager.HsqlName.emptyArray;
    HsqlNameManager.HsqlName[] writeTableNames = HsqlNameManager.HsqlName.emptyArray;
    OrderedHashSet references;
    int cursorPropertiesRequest;
    ExpressionColumn[] parameters;
    ResultMetaData parameterMetaData = ResultMetaData.emptyParamMetaData;
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";

    public abstract Result execute(Session var1);

    public void setParameters(ExpressionColumn[] expressionColumnArray) {
    }

    Statement(int n2) {
        this.type = n2;
    }

    Statement(int n2, int n3) {
        this.type = n2;
        this.group = n3;
    }

    public final boolean isError() {
        return this.isError;
    }

    public boolean isTransactionStatement() {
        return this.isTransactionStatement;
    }

    public boolean isAutoCommitStatement() {
        return false;
    }

    public void setCompileTimestamp(long l2) {
        this.compileTimestamp = l2;
    }

    public long getCompileTimestamp() {
        return this.compileTimestamp;
    }

    public final void setSQL(String string) {
        this.sql = string;
    }

    public String getSQL() {
        return this.sql;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public final void setDescribe() {
        this.isExplain = true;
    }

    public abstract String describe(Session var1);

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.schemaName;
    }

    public final void setSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.schemaName = hsqlName;
    }

    public final void setID(long l2) {
        this.id = l2;
    }

    public final long getID() {
        return this.id;
    }

    public final int getType() {
        return this.type;
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isLogged() {
        return this.isLogged;
    }

    public void clearVariables() {
    }

    public void resolve(Session session) {
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForRead() {
        return this.readTableNames;
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        return this.writeTableNames;
    }

    public boolean isCatalogLock(int n2) {
        switch (this.group) {
            case 2002: {
                if (this.type == 5) {
                    return false;
                }
                if (this.writeTableNames.length == 0) {
                    return false;
                }
                return n2 == 2;
            }
            case 2001: {
                return n2 == 2;
            }
            case 2012: 
            case 2014: {
                return true;
            }
        }
        return false;
    }

    public boolean isCatalogChange() {
        switch (this.group) {
            case 2001: 
            case 2002: 
            case 2012: {
                return true;
            }
        }
        return false;
    }

    public void setParent(StatementCompound statementCompound) {
        this.parent = statementCompound;
    }

    public void setRoot(Routine routine) {
        this.root = routine;
    }

    public boolean hasGeneratedColumns() {
        return false;
    }

    public ResultMetaData generatedResultMetaData() {
        return null;
    }

    public void setGeneratedColumnInfo(int n2, ResultMetaData resultMetaData) {
    }

    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    public int getResultProperties() {
        return 0;
    }

    public int getStatementReturnType() {
        return this.statementReturnType;
    }

    public int getCursorPropertiesRequest() {
        return this.cursorPropertiesRequest;
    }

    public void setCursorPropertiesRequest(int n2) {
        this.cursorPropertiesRequest = n2;
    }

    public void clearStructures(Session session) {
    }

    void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
    }

    void setParameterMetaData() {
        int n2 = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            int n3 = i2 + n2;
            this.parameterMetaData.columnLabels[n3] = PCOL_PREFIX + (i2 + 1);
            this.parameterMetaData.columnTypes[n3] = this.parameters[i2].dataType;
            if (this.parameters[i2].dataType == null) {
                throw Error.error(5567);
            }
            byte by = 1;
            if (this.parameters[i2].column != null && this.parameters[i2].column.getParameterMode() != 0) {
                by = this.parameters[i2].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[n3] = by;
            this.parameterMetaData.paramNullable[n3] = this.parameters[i2].column == null ? (byte)1 : this.parameters[i2].column.getNullability();
        }
    }
}

