/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class RoutineSchema
implements SchemaObject {
    static RoutineSchema[] emptyArray = new RoutineSchema[0];
    Routine[] routines = Routine.emptyArray;
    int routineType;
    private HsqlNameManager.HsqlName name;

    public RoutineSchema(int n2, HsqlNameManager.HsqlName hsqlName) {
        this.routineType = n2;
        this.name = hsqlName;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i2 = 0; i2 < this.routines.length; ++i2) {
            orderedHashSet.addAll(this.routines[i2].getReferences());
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet<Routine> orderedHashSet = new OrderedHashSet<Routine>();
        orderedHashSet.addAll(this.routines);
        return orderedHashSet;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        for (int i2 = 0; i2 < this.routines.length; ++i2) {
            hsqlArrayList.add(this.routines[i2].getSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void addSpecificRoutine(HsqlNameManager hsqlNameManager, Routine routine, boolean bl) {
        int n2 = routine.getParameterSignature();
        Type[] typeArray = routine.getParameterTypes();
        int n3 = this.routines.length;
        for (int i2 = 0; i2 < this.routines.length; ++i2) {
            if (this.routines[i2].parameterTypes.length != typeArray.length) continue;
            if (this.routineType == 17 && !bl) {
                throw Error.error(5605);
            }
            if (this.routines[i2].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean bl2 = true;
            for (int i3 = 0; i3 < typeArray.length; ++i3) {
                if (this.routines[i2].parameterTypes[i3].equals(typeArray[i3])) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            if (bl) {
                routine.setSpecificName(this.routines[i2].getSpecificName());
                n3 = i2;
                break;
            }
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            HsqlNameManager.HsqlName hsqlName = hsqlNameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(hsqlName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        if (n3 == this.routines.length) {
            this.routines = (Routine[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        }
        this.routines[n3] = routine;
    }

    public void removeSpecificRoutine(Routine routine) {
        for (int i2 = 0; i2 < this.routines.length; ++i2) {
            if (this.routines[i2] != routine) continue;
            this.routines = (Routine[])ArrayUtil.toAdjustedArray(this.routines, null, i2, -1);
            break;
        }
    }

    public Routine[] getSpecificRoutines() {
        return this.routines;
    }

    public Routine getSpecificRoutine(Type[] typeArray) {
        Routine routine = this.findSpecificRoutine(typeArray);
        if (routine == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
            stringBuilder.append("(");
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(",");
                }
                if (typeArray[i2] == null) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(typeArray[i2].getNameString());
            }
            stringBuilder.append(")");
            throw Error.error(5609, stringBuilder.toString());
        }
        return routine;
    }

    public Routine findSpecificRoutine(Type[] typeArray) {
        int n2 = -1;
        block0: for (int i2 = 0; i2 < this.routines.length; ++i2) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            if (this.routines[i2].isAggregate() && typeArray.length == 1) {
                if (typeArray[0] == null) {
                    return this.routines[i2];
                }
                n5 = typeArray[0].precedenceDegree(this.routines[i2].parameterTypes[0]);
                if (n5 < -128) {
                    if (n2 == -1 || (n4 = typeArray[0].precedenceDegree(this.routines[n2].parameterTypes[0])) == (n3 = typeArray[0].precedenceDegree(this.routines[i2].parameterTypes[0])) || n3 >= n4) continue;
                    n2 = i2;
                    continue;
                }
                if (n5 == 0) {
                    return this.routines[i2];
                }
                n2 = i2;
                continue;
            }
            if (this.routines[i2].parameterTypes.length != typeArray.length) continue;
            if (typeArray.length == 0) {
                return this.routines[i2];
            }
            for (n5 = 0; n5 < typeArray.length; ++n5) {
                if (typeArray[n5] == null) continue;
                n4 = typeArray[n5].precedenceDegree(this.routines[i2].parameterTypes[n5]);
                if (n4 < -128) continue block0;
                if (n4 != 0 || n6 != n5) continue;
                n6 = n5 + 1;
            }
            if (n6 == typeArray.length) {
                return this.routines[i2];
            }
            if (n2 == -1) {
                n2 = i2;
                continue;
            }
            for (n5 = 0; n5 < typeArray.length; ++n5) {
                if (typeArray[n5] == null || (n4 = typeArray[n5].precedenceDegree(this.routines[n2].parameterTypes[n5])) == (n3 = typeArray[n5].precedenceDegree(this.routines[i2].parameterTypes[n5]))) continue;
                if (n3 >= n4) continue block0;
                n2 = i2;
                continue block0;
            }
        }
        return n2 < 0 ? null : this.routines[n2];
    }

    public Routine getSpecificRoutine(int n2) {
        for (int i2 = 0; i2 < this.routines.length; ++i2) {
            if (this.routines[i2].parameterTypes.length != n2) continue;
            return this.routines[i2];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }
}

