/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileStatement(int n2) {
        Statement statement = this.compilePart(n2);
        if (this.token.tokenType == 1014) {
            if (statement.getSchemaName() == null) {
                statement.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return statement;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String string, Result result) {
        HsqlArrayList<Statement> hsqlArrayList = new HsqlArrayList<Statement>();
        Statement statement = null;
        this.reset(this.session, string);
        while (this.token.tokenType != 1014) {
            try {
                this.lastError = null;
                statement = this.compilePart(result.getExecuteProperties());
            }
            catch (HsqlException hsqlException) {
                if (this.lastError != null && this.lastError.getLevel() > hsqlException.getLevel()) {
                    throw this.lastError;
                }
                throw hsqlException;
            }
            if (!statement.isExplain && statement.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            hsqlArrayList.add(statement);
        }
        if (hsqlArrayList.size() > 1 && this.database.sqlRestrictExec) {
            throw Error.error(1252);
        }
        int n2 = result.getStatementType();
        if (n2 != 0) {
            int n3 = statement.getGroup();
            if (n3 == 2003) {
                if (n2 == 1) {
                    throw Error.error(1253);
                }
            } else if (n2 == 2 && this.database.sqlRestrictExec) {
                throw Error.error(1254);
            }
        }
        return hsqlArrayList;
    }

    private Statement compilePart(int n2) {
        Statement statement;
        this.compileContext.reset();
        this.setPartPosition(this.getPosition());
        if (this.token.tokenType == 1015) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 337: 
            case 936: {
                statement = this.compileCursorSpecification(RangeGroup.emptyArray, n2, false);
                break;
            }
            case 325: {
                RangeGroup[] rangeGroupArray = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(rangeGroupArray);
                statement = this.compileShortCursorSpecification(n2);
                break;
            }
            case 145: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 319: {
                statement = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 176: {
                statement = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 84: {
                statement = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 311: {
                statement = this.compileTruncateStatement();
                break;
            }
            case 799: {
                statement = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 28: {
                statement = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 268: {
                statement = this.compileSet();
                break;
            }
            case 128: {
                statement = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 281: {
                statement = this.compileStartTransaction();
                break;
            }
            case 47: {
                statement = this.compileCommit();
                break;
            }
            case 255: {
                statement = this.compileRollback();
                break;
            }
            case 260: {
                statement = this.compileSavepoint();
                break;
            }
            case 247: {
                statement = this.compileReleaseSavepoint();
                break;
            }
            case 59: {
                statement = this.compileCreate();
                break;
            }
            case 4: {
                statement = this.compileAlter();
                break;
            }
            case 93: {
                statement = this.compileDrop();
                break;
            }
            case 130: 
            case 253: {
                statement = this.compileGrantOrRevoke();
                break;
            }
            case 599: {
                statement = this.compileComment();
                break;
            }
            case 634: {
                statement = this.compileLock();
                break;
            }
            case 50: {
                statement = this.compileConnect();
                break;
            }
            case 89: {
                statement = this.compileDisconnect();
                break;
            }
            case 662: {
                statement = this.compileScript(false);
                break;
            }
            case 664: {
                statement = this.compileShutdown();
                break;
            }
            case 585: {
                statement = this.compileBackup();
                break;
            }
            case 595: {
                statement = this.compileCheckpoint();
                break;
            }
            case 613: {
                int n3 = this.getPosition();
                this.read();
                statement = this.token.tokenType == 651 ? this.compileExplainPlan() : this.compileExplainReferences();
                statement.setSQL(this.getLastPart(n3));
                break;
            }
            case 82: {
                statement = this.compileDeclare();
                break;
            }
            case 650: {
                statement = this.compilePerform();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (statement.type) {
            case 14: 
            case 66: 
            case 1093: 
            case 1151: {
                break;
            }
            default: {
                statement.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 941) {
            this.read();
        } else if (this.token.tokenType == 1014) {
            // empty if block
        }
        return statement;
    }

    private Statement compileDeclare() {
        Statement statement = this.compileDeclareLocalTableOrNull();
        if (statement != null) {
            return statement;
        }
        ColumnSchema[] columnSchemaArray = this.readLocalVariableDeclarationOrNull();
        if (columnSchemaArray != null) {
            Object[] objectArray = new Object[]{columnSchemaArray};
            statement = new StatementSession(1127, objectArray);
            return statement;
        }
        statement = this.compileDeclareCursorOrNull(RangeGroup.emptyArray, false);
        if (statement == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return statement;
    }

    private Statement compileScript(boolean bl) {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        Boolean bl2 = Boolean.FALSE;
        HsqlNameManager.HsqlName hsqlName = null;
        TimestampData timestampData = null;
        this.readThis(662);
        if (bl) {
            this.readThis(120);
            if (this.readIfThis(605)) {
                switch (this.token.tokenType) {
                    case 540: {
                        this.read();
                        n3 = 540;
                        break;
                    }
                    case 331: {
                        this.read();
                        this.readThis(399);
                        if (this.readIfThis(124)) {
                            this.readThis(298);
                            hsqlNameArray = this.readQuotedString();
                            timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(this.session, hsqlNameArray, Type.SQL_VARCHAR_DEFAULT);
                        } else {
                            timestampData = DateTimeType.epochTimestamp;
                        }
                        n3 = 331;
                        break;
                    }
                    case 399: {
                        this.read();
                        n3 = 399;
                        break;
                    }
                    default: {
                        n3 = 2;
                    }
                }
                if (this.readIfThis(337)) {
                    this.readThis(46);
                    this.readThis(468);
                    bl2 = Boolean.TRUE;
                }
                this.readThis(301);
                n2 = 605;
            } else if (this.readIfThis(294)) {
                hsqlNameArray = this.readTableName();
                if (hsqlNameArray.isView() || hsqlNameArray.isTemp()) {
                    throw Error.error(5501);
                }
                hsqlName = hsqlNameArray.getName();
                this.readThis(399);
                if (this.readIfThis(337)) {
                    this.readThis(46);
                    this.readThis(468);
                    bl2 = Boolean.TRUE;
                }
                this.readThis(301);
                n2 = 294;
                n3 = 399;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (this.token.tokenType == 1011) {
            if (n2 == 0) {
                n2 = 605;
                n3 = 2;
            }
            string = this.readQuotedString();
        } else if (n2 == 0) {
            n2 = 605;
            n3 = 540;
        } else {
            throw this.unexpectedTokenRequire("PATH");
        }
        hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string, n2, n3, bl2, hsqlName, timestampData};
        return new StatementCommand(1004, objectArray, null, hsqlNameArray);
    }

    private Statement compileConnect() {
        String string = null;
        this.read();
        this.readThis(321);
        this.checkIsSimpleName();
        String string2 = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(649);
            string = this.readPassword();
        }
        Expression[] expressionArray = new Expression[]{new ExpressionValue(string2, Type.SQL_VARCHAR), new ExpressionValue(string, Type.SQL_VARCHAR)};
        StatementSession statementSession = new StatementSession(this.session, this.compileContext, 81, expressionArray);
        return statementSession;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 628: {
                this.read();
                this.readThis(519);
                HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{hsqlName};
                return new StatementCommand(1034, objectArray);
            }
            case 250: {
                this.read();
                this.readThis(640);
                this.readThis(259);
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2};
                return new StatementCommand(1046, objectArray);
            }
            case 294: {
                int n3;
                this.read();
                this.readThis(557);
                switch (this.token.tokenType) {
                    case 640: {
                        n3 = 4;
                        break;
                    }
                    case 593: {
                        n3 = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n3)};
                return new StatementCommand(1035, objectArray);
            }
            case 446: {
                int n4;
                this.read();
                this.readThis(454);
                switch (this.token.tokenType) {
                    case 502: {
                        this.read();
                        this.readThis(386);
                        n4 = 2;
                        break;
                    }
                    case 528: {
                        this.read();
                        n4 = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{ValuePool.getInt(n4)};
                return new StatementCommand(1053, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object object;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String string = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 310) {
            object = Boolean.TRUE;
        } else if (this.token.tokenType == 114) {
            object = Boolean.FALSE;
        } else {
            this.checkIsValue();
            object = this.token.tokenValue;
        }
        this.read();
        Object[] objectArray = new Object[]{string, object};
        return new StatementCommand(1039, objectArray);
    }

    private Statement compileSet() {
        this.read();
        switch (this.token.tokenType) {
            case 369: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(72, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(this.session, this.compileContext, 72, expressionArray);
            }
            case 519: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(80, objectArray);
                }
                if (expression.isUnresolvedParam()) {
                    expression.setDataType(this.session, Type.SQL_VARCHAR_DEFAULT);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                switch (expression.getType()) {
                    case 1: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 28: {
                        if (((FunctionSQL)expression).isValueFunction()) break;
                        throw Error.error(2200);
                    }
                    default: {
                        throw Error.error(2200);
                    }
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(this.session, this.compileContext, 80, expressionArray);
            }
            case 190: {
                Object[] objectArray;
                this.read();
                this.readThis(379);
                HsqlArrayList<Object[]> hsqlArrayList = null;
                if (this.readIfThis(120)) {
                    hsqlArrayList = new HsqlArrayList<Object[]>();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 924) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{null, Boolean.FALSE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 379: {
                Object[] objectArray;
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null || !expression.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList<Object[]> hsqlArrayList = null;
                if (this.readIfThis(120)) {
                    hsqlArrayList = new HsqlArrayList<Object[]>();
                    while (true) {
                        objectArray = this.readSchemaObjectName(14);
                        hsqlArrayList.add(objectArray);
                        if (this.token.tokenType != 924) break;
                        this.read();
                    }
                }
                objectArray = new Object[]{expression, Boolean.TRUE, hsqlArrayList};
                return new StatementSession(83, objectArray);
            }
            case 297: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 512: {
                this.read();
                return this.compileSetRole();
            }
            case 530: {
                this.read();
                return this.compileSessionSettings();
            }
            case 548: {
                this.read();
                Object[] objectArray = this.processTransactionCharacteristics();
                if (objectArray[0] == null && objectArray[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(85, objectArray);
            }
            case 583: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1114, objectArray);
            }
            case 655: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(82, objectArray);
            }
            case 621: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1048, objectArray);
            }
            case 638: {
                this.read();
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2};
                return new StatementSession(1116, objectArray);
            }
            case 83: {
                int n3;
                this.read();
                this.readThis(294);
                this.readThis(557);
                switch (this.token.tokenType) {
                    case 640: {
                        n3 = 4;
                        break;
                    }
                    case 593: {
                        n3 = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n3)};
                return new StatementCommand(1035, objectArray);
            }
            case 294: {
                return this.compileSetTable();
            }
            case 677: {
                this.read();
                int n4 = 0;
                if (this.token.tokenType == 310) {
                    n4 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    n4 = 0;
                    this.read();
                } else {
                    n4 = this.readInteger();
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (this.token.tokenType == 641) {
                        this.read();
                    } else {
                        n4 *= 1000;
                    }
                }
                Object[] objectArray = new Object[]{n4};
                return new StatementCommand(1033, objectArray, null, null);
            }
            case 649: {
                Boolean bl = Boolean.FALSE;
                this.read();
                if (this.readIfThis(609)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{null, string, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string2 = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 628: {
                this.read();
                this.readThis(519);
                HsqlNameManager.HsqlName hsqlName = this.token.tokenType == 83 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{null, hsqlName};
                return new StatementCommand(1092, objectArray);
            }
            case 617: {
                return this.compileSetFilesProperty();
            }
            case 605: {
                return this.compileSetDatabaseProperty();
            }
            case 653: {
                return this.compileSetProperty();
            }
        }
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] objectArray = new Object[]{table.getName(), null, null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 535: {
                this.read();
                return this.compileTableSource(table);
            }
            case 502: {
                this.read();
                boolean bl = false;
                if (this.token.tokenType == 569) {
                    this.read();
                } else {
                    this.readThis(205);
                    bl = true;
                }
                objectArray[1] = bl;
                return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 655: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                objectArray[1] = bl;
                return new StatementCommand(1155, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 625: {
                this.read();
                this.checkIsValue();
                String string = this.token.tokenString;
                this.read();
                objectArray[1] = string;
                objectArray[2] = 5;
                return new StatementCommand(1154, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 557: {
                int n2;
                this.read();
                switch (this.token.tokenType) {
                    case 640: {
                        n2 = 4;
                        break;
                    }
                    case 593: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                switch (table.getTableType()) {
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                objectArray[1] = n2;
                return new StatementCommand(1158, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 598: {
                this.read();
                this.readThis(204);
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                this.readThis(936);
                this.readSimpleColumnNames(orderedHashSet, table, false);
                this.readThis(922);
                int[] nArray = table.getColumnIndexes(orderedHashSet);
                objectArray[1] = nArray;
                return new StatementCommand(1159, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 189: {
                this.read();
                this.readThis(536);
                objectArray = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1160, objectArray, null, hsqlNameArray);
            }
            case 536: 
        }
        this.read();
        Integer n3 = this.readIntegerObject();
        objectArray = new Object[]{table.getName(), n3};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1161, objectArray, null, hsqlNameArray);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 584: {
                this.read();
                this.readThis(126);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] objectArray = new Object[]{routine};
                return new StatementCommand(1036, objectArray, null, null);
            }
            case 379: {
                Boolean bl = null;
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.read();
                if (this.readIfThis(190)) {
                    this.readThis(485);
                    bl = Boolean.FALSE;
                } else if (this.readIfThis(485)) {
                    this.readThis(536);
                    bl = Boolean.TRUE;
                }
                if (bl == null) {
                    bl = Boolean.TRUE;
                }
                Object[] objectArray = new Object[]{string, bl};
                return new StatementCommand(1047, objectArray, null, null);
            }
            case 83: {
                return this.compileSetDefault();
            }
            case 612: {
                this.read();
                this.readThis(768);
                boolean bl = this.readIfThis(275);
                this.readThis(454);
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2, bl};
                return new StatementCommand(1016, objectArray, null, null);
            }
            case 619: {
                this.read();
                Integer n3 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n3};
                return new StatementCommand(1037, objectArray, null, null);
            }
            case 649: {
                this.read();
                switch (this.token.tokenType) {
                    case 40: {
                        this.read();
                        this.readThis(126);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] objectArray = new Object[]{routine};
                        return new StatementCommand(1040, objectArray, null, null);
                    }
                    case 609: {
                        this.read();
                        String string = this.readQuotedString();
                        Object[] objectArray = new Object[]{string};
                        return new StatementCommand(1057, objectArray, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 656: {
                this.read();
                this.readThis(623);
                boolean bl = this.processTrueOrFalse();
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(1049, objectArray, null, null);
            }
            case 275: {
                this.read();
                int n4 = 1050;
                Boolean bl = Boolean.TRUE;
                Integer n5 = 0;
                String string = null;
                switch (this.token.tokenType) {
                    case 507: {
                        this.read();
                        this.readThis(107);
                        string = "sql.restrict_exec";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 632: {
                        this.read();
                        this.readThis(475);
                        string = "sql.live_object";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 468: {
                        this.read();
                        string = "sql.enforce_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 657: {
                        this.read();
                        this.readThis(468);
                        string = "sql.regular_names";
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 236: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_refs";
                        break;
                    }
                    case 534: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_size";
                        break;
                    }
                    case 673: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.enforce_types";
                        break;
                    }
                    case 668: {
                        this.read();
                        if (this.readIfThis(84)) {
                            string = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(319);
                            string = "sql.enforce_tdc_update";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 303: {
                        this.read();
                        this.readThis(672);
                        this.readThis(673);
                        bl = this.processTrueOrFalseObject();
                        string = "jdbc.translate_tti_types";
                        break;
                    }
                    case 38: {
                        this.read();
                        this.readThis(631);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.char_literal";
                        break;
                    }
                    case 718: {
                        this.read();
                        this.readThis(473);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.concat_nulls";
                        break;
                    }
                    case 473: {
                        this.read();
                        if (this.readIfThis(423)) {
                            string = "sql.nulls_first";
                        } else {
                            this.readThis(208);
                            string = "sql.nulls_order";
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 315: {
                        this.read();
                        this.readThis(473);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.unique_nulls";
                        break;
                    }
                    case 53: {
                        this.read();
                        this.readThis(311);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.convert_trunc";
                        break;
                    }
                    case 17: {
                        this.read();
                        this.readThis(518);
                        n5 = this.readIntegerObject();
                        string = "sql.avg_scale";
                        break;
                    }
                    case 92: {
                        this.read();
                        this.readThis(643);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.double_nan";
                        break;
                    }
                    case 637: {
                        this.read();
                        this.readThis(152);
                        this.readThis(767);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.longvar_is_lob";
                        break;
                    }
                    case 621: {
                        this.read();
                        bl = this.processTrueOrFalseObject();
                        string = "sql.ignore_case";
                        break;
                    }
                    case 667: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            string = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            string = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            string = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            string = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            string = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 819: {
                        this.read();
                        this.readThis(625);
                        this.readThis(468);
                        bl = this.processTrueOrFalseObject();
                        string = "sql.sys_index_names";
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{string, bl, n5};
                return new StatementCommand(n4, objectArray, null, null);
            }
            case 670: {
                this.read();
                this.readThis(294);
                this.readThis(402);
                String string = this.readQuotedString();
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1051, objectArray, null, null);
            }
            case 548: {
                this.read();
                if (this.readIfThis(255)) {
                    this.readThis(204);
                    if (this.readIfThis(624)) {
                        Boolean bl = this.processTrueOrFalseObject();
                        StatementCommand statementCommand = new StatementCommand(1055, new Object[]{bl}, null, null);
                        return statementCommand;
                    }
                    this.readThis(602);
                    Boolean bl = this.processTrueOrFalseObject();
                    StatementCommand statementCommand = new StatementCommand(1054, new Object[]{bl}, null, null);
                    return statementCommand;
                }
                this.readThis(603);
                int n6 = 0;
                switch (this.token.tokenType) {
                    case 776: {
                        this.read();
                        n6 = 2;
                        break;
                    }
                    case 777: {
                        this.read();
                        n6 = 1;
                        break;
                    }
                    case 635: {
                        this.read();
                        n6 = 0;
                        break;
                    }
                }
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] objectArray = new Object[]{ValuePool.getInt(n6)};
                StatementCommand statementCommand = new StatementCommand(1052, objectArray, null, hsqlNameArray);
                return statementCommand;
            }
            case 315: {
                this.read();
                this.readThis(467);
                if (!this.isUndelimitedSimpleName()) {
                    throw this.unexpectedToken();
                }
                String string = this.token.tokenString;
                this.read();
                if (string.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(string, Charset.unquotedIdentifier) || !Charset.startsWith(string, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1056, objectArray, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int n2 = 0;
        Boolean bl = null;
        Integer n3 = null;
        Boolean bl2 = null;
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 40: {
                this.read();
                long l2 = this.readBigint();
                long l3 = -1L;
                n2 = 1014;
                hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
                if (this.readIfThis(924)) {
                    l3 = this.readBigint();
                }
                Object[] objectArray = new Object[]{l2, l3};
                return new StatementCommand(n2, objectArray, null, hsqlNameArray);
            }
            case 592: {
                this.read();
                if (this.readIfThis(534)) {
                    n3 = this.readIntegerObject();
                    n2 = 1013;
                } else {
                    this.readThis(259);
                    n3 = this.readIntegerObject();
                    n2 = 1012;
                }
                if (!this.readIfThis(190)) break;
                this.readThis(40);
                bl2 = Boolean.TRUE;
                break;
            }
            case 518: {
                this.read();
                n3 = this.readIntegerObject();
                n2 = 1025;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 536: {
                this.read();
                if (this.token.tokenType == 310) {
                    bl = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 114) {
                    bl = Boolean.FALSE;
                    this.read();
                } else {
                    n3 = this.readIntegerObject();
                }
                n2 = 1031;
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 767: {
                this.read();
                if (this.readIfThis(518)) {
                    n3 = this.readIntegerObject();
                    n2 = 1017;
                } else {
                    this.readThis(601);
                    n2 = 1018;
                    bl = this.processTrueOrFalseObject();
                }
                hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 607: {
                this.read();
                n2 = 1015;
                n3 = this.readIntegerObject();
                break;
            }
            case 780: {
                this.read();
                if (this.readIfThis(534)) {
                    n3 = this.readIntegerObject();
                } else {
                    bl = this.processTrueOrFalseObject();
                }
                n2 = 1022;
                break;
            }
            case 585: {
                this.read();
                n2 = 1011;
                this.readThis(439);
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 768: {
                this.read();
                if (this.readIfThis(534)) {
                    n2 = 1021;
                    n3 = this.readIntegerObject();
                    break;
                }
                n2 = 1020;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 669: {
                this.read();
                this.readThis(494);
                n2 = 1032;
                n3 = this.readIntegerObject();
                break;
            }
            case 569: {
                this.read();
                this.readThis(608);
                n2 = 1033;
                int n4 = 0;
                if (this.token.tokenType == 310) {
                    n4 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 114) {
                    n4 = 0;
                    this.read();
                } else {
                    n4 = this.readInteger();
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (this.token.tokenType == 641) {
                        this.read();
                    } else {
                        n4 *= 1000;
                    }
                }
                n3 = n4;
                break;
            }
            case 662: {
                this.read();
                this.readThis(618);
                if (this.token.tokenType == 670) {
                    this.read();
                    n3 = 0;
                } else {
                    this.readThis(601);
                    n3 = 3;
                }
                n2 = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl == null ? (Constable)n3 : (Constable)bl, bl2};
        return new StatementCommand(n2, objectArray, null, hsqlNameArray);
    }

    Object[] processTransactionCharacteristics() {
        int n2 = 0;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 502: {
                    if (objectArray[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 205) {
                        this.read();
                        bl = true;
                    } else {
                        this.readThis(569);
                        bl = false;
                    }
                    objectArray[0] = bl;
                    continue block10;
                }
                case 446: {
                    if (objectArray[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(454);
                    switch (this.token.tokenType) {
                        case 528: {
                            this.read();
                            n2 = 8;
                            break;
                        }
                        case 502: {
                            this.read();
                            if (this.token.tokenType == 386) {
                                this.read();
                                n2 = 2;
                                break;
                            }
                            if (this.token.tokenType == 559) {
                                this.read();
                                n2 = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 504: {
                            this.read();
                            this.readThis(502);
                            n2 = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    objectArray[1] = n2;
                    continue block10;
                }
                case 924: {
                    if (objectArray[0] == null && objectArray[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!bl && n2 == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return objectArray;
    }

    private Statement compileCommit() {
        boolean bl = false;
        this.read();
        this.readIfThis(568);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(371);
        }
        String string = bl ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(14, new Object[]{bl});
        statementSession.setSQL(string);
        return statementSession;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(548);
        Object[] objectArray = this.processTransactionCharacteristics();
        StatementSession statementSession = new StatementSession(86, objectArray);
        return statementSession;
    }

    private Statement compileLock() {
        this.read();
        if (this.readIfThis(369)) {
            return this.compileLockCatalog();
        }
        this.readThis(294);
        return this.compileLockTable();
    }

    private Statement compileLockCatalog() {
        boolean bl = this.processTrueOrFalse();
        int n2 = bl ? 1111 : 1112;
        HsqlNameManager.HsqlName[] hsqlNameArray = bl ? this.database.schemaManager.getCatalogAndBaseTableNames() : null;
        StatementSession statementSession = new StatementSession(n2, null, hsqlNameArray);
        return statementSession;
    }

    private Statement compileLockTable() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
        while (true) {
            hsqlNameArray = this.readTableName(true);
            switch (this.token.tokenType) {
                case 502: {
                    this.read();
                    orderedHashSet.add(hsqlNameArray.getName());
                    break;
                }
                case 569: {
                    this.read();
                    orderedHashSet2.add(hsqlNameArray.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(hsqlNameArray);
        orderedHashSet.removeAll(hsqlNameArray);
        HsqlNameManager.HsqlName[] hsqlNameArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(hsqlNameArray2);
        StatementSession statementSession = new StatementSession(1113, hsqlNameArray2, hsqlNameArray);
        return statementSession;
    }

    private Statement compileRollback() {
        boolean bl = false;
        String string = null;
        this.read();
        if (this.token.tokenType == 568) {
            this.read();
        }
        if (this.token.tokenType == 301) {
            this.read();
            this.readThis(260);
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            Object[] objectArray = new Object[]{string};
            StatementSession statementSession = new StatementSession(1118, objectArray);
            return statementSession;
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 190) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(371);
        }
        String string2 = bl ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession statementSession = new StatementSession(66, new Object[]{bl});
        statementSession.setSQL(string2);
        return statementSession;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(67, objectArray);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(260);
        String string = this.token.tokenString;
        this.read();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(61, objectArray);
    }

    private Statement compileSessionSettings() {
        switch (this.token.tokenType) {
            case 375: {
                this.read();
                this.readThis(11);
                this.readThis(548);
                Object[] objectArray = this.processTransactionCharacteristics();
                return new StatementSession(82, objectArray);
            }
            case 16: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    throw Error.error(5584);
                }
                expression.resolveTypes(this.session, null);
                if (expression.isUnresolvedParam()) {
                    expression.dataType = Type.SQL_VARCHAR;
                }
                if (expression.dataType == null || !expression.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] expressionArray = new Expression[]{expression, null};
                return new StatementSession(this.session, this.compileContext, 81, expressionArray);
            }
            case 250: {
                this.read();
                this.readThis(640);
                this.readThis(259);
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2};
                return new StatementSession(1117, objectArray);
            }
            case 615: {
                this.read();
                String string = this.parseSQLFeatureValue();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{string, bl};
                return new StatementSession(1115, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression expression;
        if (this.token.tokenType == 191) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            expression = this.XreadValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(4100);
            }
            if (!expression.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        return new StatementSession(this.session, this.compileContext, 79, new Expression[]{expression});
    }

    private Statement compileSetTimeZone() {
        Expression expression;
        this.readThis(571);
        if (this.token.tokenType == 167) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            expression = this.XreadIntervalValueExpression();
            List list = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
            ExpressionColumn.checkColumnsResolved(list);
            expression.resolveTypes(this.session, null);
            if (expression.dataType == null) {
                throw Error.error(5563);
            }
            if (expression.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        return new StatementSession(this.session, this.compileContext, 76, new Expression[]{expression});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int n2 = 2;
        this.read();
        switch (this.token.tokenType) {
            case 622: {
                n2 = 1;
                this.read();
                break;
            }
            case 600: {
                n2 = 3;
                this.read();
                break;
            }
            case 662: {
                n2 = 4;
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 941) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        Object[] objectArray = new Object[]{n2};
        StatementCommand statementCommand = new StatementCommand(1003, objectArray, null, null);
        return statementCommand;
    }

    private Statement compileBackup() {
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        this.read();
        this.readThis(605);
        this.readThis(301);
        String string = this.readQuotedString();
        string = string.trim();
        if (string.isEmpty()) {
            throw this.unexpectedToken(string);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 589: {
                    if (bl != null) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 662: {
                    if (bl2 != null) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 601: {
                    if (bl3 != null) {
                        throw this.unexpectedToken();
                    }
                    bl3 = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 193: {
                    this.read();
                    if (this.token.tokenType == 601) {
                        if (bl3 != null) {
                            throw this.unexpectedToken();
                        }
                        bl3 = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 589) {
                        if (bl != null) {
                            throw this.unexpectedToken();
                        }
                        bl = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 11: {
                    if (bl4 != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(617);
                    bl4 = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        if (bl4 == null) {
            bl4 = Boolean.FALSE;
        }
        if (bl2.booleanValue() && !bl.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = bl != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] objectArray = new Object[]{string, bl, bl2, bl3, bl4};
        StatementCommand statementCommand = new StatementCommand(1001, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    private Statement compilePerform() {
        this.read();
        switch (this.token.tokenType) {
            case 40: {
                this.read();
                boolean bl = false;
                HsqlNameManager.HsqlName hsqlName = null;
                Integer n2 = 3;
                Integer n3 = -1;
                switch (this.token.tokenType) {
                    case 2: {
                        this.read();
                        bl = true;
                    }
                    case 294: {
                        this.readThis(294);
                        if (bl) {
                            this.readThis(625);
                            break;
                        }
                        hsqlName = this.readTableName().getName();
                        this.readThis(625);
                    }
                }
                if (this.readIfThis(5)) {
                    this.readThis("FIX");
                    n2 = 8;
                }
                Object[] objectArray = new Object[]{hsqlName, n2, n3};
                HsqlNameManager.HsqlName[] hsqlNameArray = bl ? this.database.schemaManager.getCatalogAndBaseTableNames() : this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
                return new StatementCommand(1006, objectArray, null, hsqlNameArray);
            }
            case 139: {
                this.read();
                return this.compileImportScript();
            }
            case 614: {
                return this.compileExport();
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileExport() {
        this.read();
        return this.compileScript(true);
    }

    private Statement compileImportScript() {
        int n2 = 2;
        Boolean bl = Boolean.FALSE;
        this.readThis(662);
        if (this.token.tokenType == 331) {
            this.readThis(331);
            bl = Boolean.TRUE;
        }
        this.readThis(399);
        this.readThis(124);
        String string = this.readQuotedString();
        if (!bl.booleanValue()) {
            n2 = this.readLoadMode();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{string, n2, bl};
        return new StatementCommand(1005, objectArray, null, hsqlNameArray);
    }

    private int readLoadMode() {
        int n2 = -1;
        switch (this.token.tokenType) {
            case 397: {
                n2 = 2;
                this.read();
                break;
            }
            case 665: {
                n2 = 1;
                this.read();
                break;
            }
            case 40: {
                n2 = 4;
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(204);
        this.readThis(611);
        return n2;
    }

    private Statement compileCheckpoint() {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 607) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 941) {
            this.read();
        }
        if (this.token.tokenType != 1014) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{bl};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        return statementCommand;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] hsqlNameArray = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] objectArray = new Object[]{Boolean.FALSE};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray, null, hsqlNameArray);
        statementCommand.setCompileTimestamp(database.txManager.getGlobalChangeTimestamp());
        statementCommand.setSQL("CHECKPOINT");
        return statementCommand;
    }

    private Statement compileDisconnect() {
        this.read();
        String string = "DISCONNECT";
        StatementSession statementSession = new StatementSession(22, null);
        return statementSession;
    }

    private Statement compileExplainPlan() {
        this.readThis(651);
        this.readThis(120);
        Statement statement = this.compilePart(0);
        statement.setDescribe();
        return new StatementCommand(1151, new Object[]{statement});
    }

    private Statement compileExplainReferences() {
        int n2;
        boolean bl = false;
        this.readThis(236);
        if (!this.readIfThis(301)) {
            this.readThis(124);
            bl = true;
        }
        switch (this.token.tokenType) {
            case 294: 
            case 567: {
                this.read();
                n2 = 3;
                break;
            }
            case 273: {
                this.read();
                this.readThis(513);
                n2 = 24;
                break;
            }
            case 414: 
            case 557: {
                this.read();
                n2 = 13;
                break;
            }
            case 527: {
                this.read();
                n2 = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        SchemaObject schemaObject = this.readSchemaObjectName(n2);
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        return new StatementCommand(1150, new Object[]{hsqlName, bl});
    }

    private StatementCommand compileTableSource(Table table) {
        String string;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = new Object[5];
        objectArray[0] = table.getName();
        if (!table.isText()) {
            object = Error.error(321);
        }
        if (this.token.tokenType == 204) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.TRUE;
            return new StatementCommand(1156, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 648) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.FALSE;
            return new StatementCommand(1156, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
        }
        if (this.token.tokenType == 620) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 1013) {
            string = this.token.tokenString;
            this.read();
        } else {
            string = this.readQuotedString();
        }
        if (!bl && this.token.tokenType == 410) {
            bl2 = true;
            this.read();
        }
        object = this.getLastPart();
        objectArray[2] = string;
        objectArray[3] = bl2;
        objectArray[4] = bl;
        int n2 = bl ? 1157 : 1156;
        return new StatementCommand(n2, objectArray, null, new HsqlNameManager.HsqlName[]{table.getName()});
    }
}

