/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression[] expressionArray, boolean bl) {
        super(30);
        this.nodes = expressionArray;
        this.ordinality = bl;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        if (this.isTable) {
            stringBuilder.append("TABLE").append(' ');
        } else {
            stringBuilder.append("UNNEST").append(' ');
        }
        stringBuilder.append(this.nodes[0].describe(session, n2));
        return stringBuilder.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            this.nodes[n2].resolveTypes(session, this);
        }
        if (this.nodes.length == 1 && this.nodes[0].dataType.isRowType()) {
            if (this.ordinality) {
                throw Error.error(5581, "ORDINALITY");
            }
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.table.prepareTable(session);
            this.table.columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
            this.isTable = true;
            return;
        }
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2].dataType.isArrayType()) continue;
            throw Error.error(5563, "UNNEST");
        }
        n2 = this.ordinality ? this.nodes.length + 1 : this.nodes.length;
        this.nodeDataTypes = new Type[n2];
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            this.nodeDataTypes[i2] = this.nodes[i2].dataType.collectionBaseType();
            if (this.nodeDataTypes[i2] != null && this.nodeDataTypes[i2] != Type.SQL_ALL_TYPES) continue;
            throw Error.error(5567, "UNNEST");
        }
        if (this.ordinality) {
            this.nodeDataTypes[this.nodes.length] = Type.SQL_INTEGER;
        }
        this.table.prepareTable(session);
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.table.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] objectArray = this.table.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        if (this.isTable) {
            this.insertTableValues(session, persistentStore);
        } else {
            this.insertArrayValues(session, persistentStore);
        }
    }

    private void insertTableValues(Session session, PersistentStore persistentStore) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator rowSetNavigator = result.navigator;
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            Object[] objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray);
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2, false);
            try {
                persistentStore.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore persistentStore) {
        int n2;
        Object[][] objectArrayArray = new Object[this.nodes.length][];
        for (n2 = 0; n2 < objectArrayArray.length; ++n2) {
            Object[] objectArray = (Object[])this.nodes[n2].getValue(session);
            if (objectArray == null) {
                objectArray = ValuePool.emptyObjectArray;
            }
            objectArrayArray[n2] = objectArray;
        }
        n2 = 0;
        while (true) {
            boolean bl = false;
            Object[] objectArray = new Object[this.nodeDataTypes.length];
            for (int i2 = 0; i2 < objectArrayArray.length; ++i2) {
                if (n2 >= objectArrayArray[i2].length) continue;
                objectArray[i2] = objectArrayArray[i2][n2];
                bl = true;
            }
            if (!bl) break;
            if (this.ordinality) {
                objectArray[this.nodes.length] = ValuePool.getInt(n2 + 1);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
            try {
                persistentStore.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

