/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class ExpressionOp
extends Expression {
    static final ExpressionOp limitOneExpression = new ExpressionOp(95, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), (Expression)new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER));

    ExpressionOp(int n2, Expression[] expressionArray) {
        super(n2);
        switch (this.opType) {
            case 90: {
                this.nodes = expressionArray;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(int n2, Expression expression, Expression expression2) {
        super(n2);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 37: 
            case 92: 
            case 93: 
            case 95: 
            case 96: {
                return;
            }
            case 88: {
                this.dataType = expression.dataType;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(Expression expression, Type type) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.dataType = type;
        this.alias = expression.alias;
    }

    ExpressionOp(Expression expression, Type type, Expression expression2) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.dataType = type;
        this.alias = expression.alias;
    }

    ExpressionOp(Expression expression) {
        super(expression.dataType.isDateTimeTypeWithZone() ? 91 : 92);
        switch (expression.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, expression.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, expression.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, expression.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, expression.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        this.alias = expression.alias;
    }

    public static Expression getCastExpression(Session session, Expression expression, Type type) {
        if (expression.getType() == 1) {
            Object object = type.castToType(session, expression.getValue(session), expression.getDataType());
            return new ExpressionValue(object, type);
        }
        return new ExpressionOp(expression, type);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String string2 = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 37: {
                stringBuilder.append(' ').append("LIKE").append(' ');
                stringBuilder.append(string).append(' ').append(string2).append(' ');
                break;
            }
            case 91: {
                stringBuilder.append(' ').append("CAST").append('(');
                stringBuilder.append(string).append(' ').append("AS").append(' ');
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(')');
                break;
            }
            case 93: {
                stringBuilder.append(' ').append("CASEWHEN").append('(');
                stringBuilder.append(string).append(',').append(string2).append(')');
                break;
            }
            case 96: {
                stringBuilder.append(string).append(',').append(string2);
                break;
            }
            case 95: {
                if (string != null) {
                    stringBuilder.append(' ').append("OFFSET").append(' ');
                    stringBuilder.append(string).append(' ');
                }
                if (string2 == null) break;
                stringBuilder.append(' ').append("FETCH").append(' ');
                stringBuilder.append("FIRST");
                stringBuilder.append(string2).append(' ').append(string2).append(' ');
                stringBuilder.append("ROWS").append(' ').append("ONLY");
                stringBuilder.append(' ');
                break;
            }
            case 92: {
                stringBuilder.append(string).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    stringBuilder.append("LOCAL").append(' ');
                    break;
                }
                stringBuilder.append("TIME").append(' ').append("ZONE");
                stringBuilder.append(' ');
                stringBuilder.append(string2);
                break;
            }
            case 90: {
                stringBuilder.append("CONCAT_WS").append(936);
                stringBuilder.append(string);
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    stringBuilder.append(',').append(this.nodes[i2].getSQL());
                }
                stringBuilder.append(922);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuilder.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
            case 37: {
                stringBuilder.append("LIKE").append(' ').append("ARG ");
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(' ');
                break;
            }
            case 26: {
                stringBuilder.append("VALUE").append(' ').append("LIST ");
                for (n3 = 0; n3 < this.nodes.length; ++n3) {
                    stringBuilder.append(this.nodes[n3].describe(session, n2 + 1));
                    stringBuilder.append(' ');
                }
                return stringBuilder.toString();
            }
            case 91: {
                stringBuilder.append("CAST").append(' ');
                stringBuilder.append(this.dataType.getTypeDefinition());
                stringBuilder.append(' ');
                break;
            }
            case 93: {
                stringBuilder.append("CASEWHEN").append(' ');
                break;
            }
            case 90: {
                stringBuilder.append("CONCAT_WS").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg_left=[");
            stringBuilder.append(this.nodes[0].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuilder.append(" arg_right=[");
            stringBuilder.append(this.nodes[1].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List list, boolean bl) {
        if (this.opType == 1) {
            return list;
        }
        switch (this.opType) {
            case 93: {
                bl = false;
                break;
            }
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            list = this.nodes[i2].resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n2;
        switch (this.opType) {
            case 93: {
                break;
            }
            default: {
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    if (this.nodes[n2] == null) continue;
                    this.nodes[n2].resolveTypes(session, this);
                }
            }
        }
        block3 : switch (this.opType) {
            case 1: {
                break;
            }
            case 37: {
                this.dataType = this.nodes[0].dataType;
                if (this.nodes[0].opType != 1 || this.nodes[1] != null && this.nodes[1].opType != 1) break;
                this.setAsConstantValue(session, expression);
                break;
            }
            case 91: {
                Expression expression2 = this.nodes[0];
                Type type = expression2.dataType;
                if (type != null && !this.dataType.canConvertFrom(type)) {
                    throw Error.error(5561);
                }
                if (expression2.opType == 1) {
                    this.setAsConstantValue(session, expression);
                    break;
                }
                if (this.nodes[0].opType != 8) break;
                expression2.dataType = this.dataType;
                break;
            }
            case 92: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        if (this.nodes[1].opType == 1) {
                            this.nodes[1].valueData = Type.SQL_INTERVAL_HOUR_TO_MINUTE.castToType(session, this.nodes[1].valueData, this.nodes[1].dataType);
                            this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                        } else {
                            throw Error.error(5563);
                        }
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block3;
                    }
                }
                throw Error.error(5563);
            }
            case 93: {
                this.resolveTypesForCaseWhen(session, expression);
                break;
            }
            case 90: {
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    this.nodes[n2].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 96: {
                this.resolveTypesForAlternative(session);
                break;
            }
            case 95: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        throw Error.error(5567);
                    }
                    if (!this.nodes[0].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                if (this.nodes[1] == null) break;
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType.isIntegralType()) break;
                throw Error.error(5563);
            }
            case 88: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
    }

    void resolveTypesForAlternative(Session session) {
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        }
        if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.exprSubType == 91) {
            if (this.nodes[1].dataType == null) {
                this.nodes[1].dataType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
            }
            this.dataType = this.nodes[1].dataType;
            if (!this.nodes[1].dataType.equals(this.nodes[0].dataType)) {
                this.nodes[0] = new ExpressionOp(this.nodes[0], this.dataType);
            }
        } else {
            this.dataType = Type.getAggregateType(this.nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(this.nodes[1].dataType, this.dataType);
        }
    }

    void resolveTypesForCaseWhen(Session session, Expression expression) {
        this.nodes[1].resolveTypes(session, this);
        Expression expression2 = this;
        while (expression2.opType == 93) {
            this.dataType = expression2.exprSubType == 91 ? expression2.nodes[1].dataType : Type.getAggregateType(expression2.nodes[1].dataType, this.dataType);
            if (expression2.nodes[1].nodes[1].opType == 93) {
                expression2 = expression2.nodes[1].nodes[1];
                continue;
            }
            expression2 = expression2.nodes[1].nodes[0];
        }
        expression2 = this;
        while (expression2.opType == 93) {
            if (expression2.nodes[1].dataType == null) {
                expression2.nodes[1].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[1].dataType == null) {
                expression2.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[0].dataType == null) {
                expression2.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expression2.nodes[1].nodes[1].opType == 93) {
                expression2 = expression2.nodes[1].nodes[1];
                continue;
            }
            expression2 = expression2.nodes[1].nodes[0];
        }
        expression2 = this;
        while (expression2.opType == 93) {
            expression2.nodes[0].resolveTypes(session, expression2);
            if (expression2.nodes[0].isUnresolvedParam()) {
                expression2.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expression2.nodes[1].nodes[0].resolveTypes(session, expression2.nodes[1]);
            if (expression2.nodes[1].nodes[1].opType != 93) {
                expression2.nodes[1].nodes[1].resolveTypes(session, expression2.nodes[1]);
            }
            expression2 = expression2.nodes[1].nodes[1];
        }
        if (!(expression != null && expression.opType == 96 || this.dataType != null && this.dataType.typeCode != 0)) {
            throw Error.error(5567);
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 37: {
                Object object;
                boolean bl = this.nodes[1] != null;
                int n2 = Integer.MAX_VALUE;
                if (this.dataType.isBinaryType()) {
                    Object object2;
                    BinaryData binaryData = (BinaryData)this.nodes[0].getValue(session);
                    if (binaryData == null) {
                        return null;
                    }
                    if (bl) {
                        object2 = (BinaryData)this.nodes[1].getValue(session);
                        if (object2 == null) {
                            return null;
                        }
                        if (((BinaryData)object2).length(session) != 1L) {
                            throw Error.error(3412);
                        }
                        n2 = ((BinaryData)object2).getBytes()[0];
                    }
                    object2 = binaryData.getBytes();
                    byte[] byArray = new byte[((byte[])object2).length];
                    boolean bl2 = false;
                    int n3 = 0;
                    int n4 = 0;
                    for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                        if (object2[i2] == n2) {
                            if (bl2) {
                                ++n3;
                                byArray[n4++] = (byte)object2[i2];
                                bl2 = false;
                                continue;
                            }
                            bl2 = true;
                            if (i2 != ((Object)object2).length - 1) continue;
                            throw Error.error(3458);
                        }
                        if (object2[i2] == 95 || object2[i2] == 37) {
                            if (!bl2) break;
                            ++n3;
                            byArray[n4++] = (byte)object2[i2];
                            bl2 = false;
                            continue;
                        }
                        if (bl2) {
                            throw Error.error(3458);
                        }
                        byArray[n4++] = (byte)object2[i2];
                    }
                    byArray = (byte[])ArrayUtil.resizeArrayIfDifferent(byArray, n4);
                    return new BinaryData(byArray, false);
                }
                String string = (String)Type.SQL_VARCHAR.convertToType(session, this.nodes[0].getValue(session), this.nodes[0].getDataType());
                if (string == null) {
                    return null;
                }
                if (bl) {
                    object = (String)Type.SQL_VARCHAR.convertToType(session, this.nodes[1].getValue(session), this.nodes[1].getDataType());
                    if (object == null) {
                        return null;
                    }
                    if (((String)object).length() != 1) {
                        throw Error.error(3439);
                    }
                    n2 = ((String)object).getBytes()[0];
                }
                object = string.toCharArray();
                char[] cArray = new char[((char[])object).length];
                boolean bl3 = false;
                int n5 = 0;
                int n6 = 0;
                for (int i3 = 0; i3 < ((char[])object).length; ++i3) {
                    if (object[i3] == n2) {
                        if (bl3) {
                            ++n5;
                            cArray[n6++] = (char)object[i3];
                            bl3 = false;
                            continue;
                        }
                        bl3 = true;
                        if (i3 != ((Object)object).length - 1) continue;
                        throw Error.error(3458);
                    }
                    if (object[i3] == 95 || object[i3] == 37) {
                        if (!bl3) break;
                        ++n5;
                        cArray[n6++] = (char)object[i3];
                        bl3 = false;
                        continue;
                    }
                    if (bl3) {
                        throw Error.error(3458);
                    }
                    cArray[n6++] = (char)object[i3];
                }
                return new String(cArray, 0, n6);
            }
            case 94: {
                return this.nodes[0].getValue(session);
            }
            case 88: {
                if (this.nodes[0].dataType.isCharacterType()) {
                    Object object = this.nodes[1].getValue(session);
                    if (object == null) {
                        return null;
                    }
                    CharacterType characterType = (CharacterType)this.nodes[1].dataType;
                    long l2 = ((CharacterType)this.nodes[1].dataType).size(session, object);
                    characterType = (CharacterType)this.nodes[0].dataType;
                    object = this.nodes[0].getValue(session);
                    if (object == null) {
                        return null;
                    }
                    return characterType.substring(session, object, 0L, l2, true, false);
                }
                BinaryData binaryData = (BinaryData)this.nodes[1].getValue(session);
                if (binaryData == null) {
                    return null;
                }
                long l3 = binaryData.length(session);
                BinaryType binaryType = (BinaryType)this.nodes[0].dataType;
                binaryData = (BinaryData)this.nodes[0].getValue(session);
                if (binaryData == null) {
                    return null;
                }
                return binaryType.substring(session, binaryData, 0L, l3, true);
            }
            case 91: {
                Object object = this.dataType.castToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraintArray = this.dataType.userTypeModifier.getConstraints();
                    for (int i4 = 0; i4 < constraintArray.length; ++i4) {
                        constraintArray[i4].checkCheckConstraint(session, null, null, object);
                    }
                }
                return object;
            }
            case 93: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(bl)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 90: {
                String string = (String)this.nodes[0].getValue(session);
                if (string == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (int i5 = 1; i5 < this.nodes.length; ++i5) {
                    String string2 = (String)this.nodes[i5].getValue(session);
                    if (string2 == null) continue;
                    if (bl) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    bl = true;
                }
                return stringBuilder.toString();
            }
            case 92: {
                Object object;
                Object object3 = this.nodes[0].getValue(session);
                Object object4 = object = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (object3 == null) {
                    return null;
                }
                if (this.nodes[1] != null && object == null) {
                    return null;
                }
                long l4 = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(object);
                return ((DateTimeType)this.dataType).changeZone(session, object3, this.nodes[0].dataType, (int)l4, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }
}

