/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionTable;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class ExpressionLogical
extends Expression {
    boolean noOptimisation;
    boolean isQuantified;
    boolean isTerminal;

    ExpressionLogical(int n2) {
        super(n2);
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(boolean bl) {
        super(1);
        this.dataType = Type.SQL_BOOLEAN;
        this.valueData = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    ExpressionLogical(RangeVariable rangeVariable, int n2, RangeVariable rangeVariable2, int n3) {
        super(40);
        ExpressionColumn expressionColumn = new ExpressionColumn(rangeVariable, n2);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(rangeVariable2, n3);
        this.nodes = new Expression[2];
        this.nodes[0] = expressionColumn;
        this.nodes[1] = expressionColumn2;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(Expression expression, Expression expression2) {
        super(40);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        this.setEqualityMode();
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int n2, Expression expression, Expression expression2) {
        super(n2);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.setEqualityMode();
                break;
            }
            case 46: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int n2, Expression expression, Expression expression2, Expression expression3) {
        super(n2);
        this.nodes = new Expression[3];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        this.nodes[2] = expression3;
    }

    ExpressionLogical(int n2, Expression expression) {
        super(n2);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        switch (this.opType) {
            case 39: 
            case 47: 
            case 48: 
            case 55: 
            case 66: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.opType == 47 && this.nodes[0].opType == 2) {
            this.isSingleColumnNull = true;
        }
        if (this.opType == 48 && this.nodes[0].isSingleColumnNull) {
            this.isSingleColumnNotNull = true;
        }
    }

    ExpressionLogical(ColumnSchema columnSchema) {
        super(48);
        this.nodes = new Expression[1];
        this.dataType = Type.SQL_BOOLEAN;
        Expression expression = new ExpressionColumn(columnSchema);
        expression = new ExpressionLogical(47, expression);
        this.nodes[0] = expression;
    }

    void setEqualityMode() {
        block11: {
            block10: {
                if (this.nodes[0].opType != 2) break block10;
                this.nodes[0].nullability = 0;
                switch (this.nodes[1].opType) {
                    case 2: {
                        this.isColumnCondition = true;
                        if (this.opType == 40) {
                            this.isColumnEqual = true;
                        }
                        this.nodes[1].nullability = 0;
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.isSingleColumnCondition = true;
                        if (this.opType == 40) {
                            this.isSingleColumnEqual = true;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            if (this.nodes[1].opType == 2) {
                this.nodes[1].nullability = 0;
                switch (this.nodes[0].opType) {
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.isSingleColumnCondition = true;
                        if (this.opType != 40) break;
                        this.isSingleColumnEqual = true;
                        break;
                    }
                }
            }
        }
    }

    static ExpressionLogical newNotNullCondition(Expression expression) {
        expression = new ExpressionLogical(47, expression);
        return new ExpressionLogical(48, expression);
    }

    static Expression andExpressions(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        if (EXPR_FALSE.equals(expression) || EXPR_FALSE.equals(expression2)) {
            return new ExpressionBoolean(false);
        }
        if (expression == expression2) {
            return expression;
        }
        return new ExpressionLogical(49, expression, expression2);
    }

    static Expression orExpressions(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        if (expression == expression2) {
            return expression;
        }
        return new ExpressionLogical(50, expression, expression2);
    }

    public void addLeftColumnsForAllAny(RangeVariable rangeVariable, OrderedIntHashSet orderedIntHashSet) {
        if (this.nodes.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.nodes[0].nodes.length; ++i2) {
            int n2 = this.nodes[0].nodes[i2].getColumnIndex();
            if (n2 < 0 || this.nodes[0].nodes[i2].getRangeVariable() != rangeVariable) {
                orderedIntHashSet.clear();
                return;
            }
            orderedIntHashSet.add(n2);
        }
    }

    @Override
    public void setSubType(int n2) {
        this.exprSubType = n2;
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.isQuantified = true;
        }
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        if (this.opType == 1) {
            return super.getSQL();
        }
        String string = ExpressionLogical.getContextSQL(this.nodes[0]);
        String string2 = ExpressionLogical.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 48: {
                if (this.nodes[0].opType == 47) {
                    stringBuilder.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return stringBuilder.toString();
                }
                if (this.nodes[0].opType == 67) {
                    stringBuilder.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                    return stringBuilder.toString();
                }
                stringBuilder.append("NOT").append(' ').append(string);
                return stringBuilder.toString();
            }
            case 67: {
                stringBuilder.append(string).append(' ').append("IS").append(' ').append("NOT").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(string2);
                return stringBuilder.toString();
            }
            case 47: {
                stringBuilder.append(string).append(' ').append("IS").append(' ').append("NULL");
                return stringBuilder.toString();
            }
            case 66: {
                stringBuilder.append(' ').append("UNIQUE").append(' ');
                break;
            }
            case 55: {
                stringBuilder.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 40: {
                stringBuilder.append(string).append('=').append(string2);
                return stringBuilder.toString();
            }
            case 41: 
            case 42: {
                stringBuilder.append(string).append(">=").append(string2);
                return stringBuilder.toString();
            }
            case 43: {
                stringBuilder.append(string).append('>').append(string2);
                return stringBuilder.toString();
            }
            case 44: {
                stringBuilder.append(string).append('<').append(string2);
                return stringBuilder.toString();
            }
            case 45: {
                stringBuilder.append(string).append("<=").append(string2);
                return stringBuilder.toString();
            }
            case 46: {
                if ("NULL".equals(string2)) {
                    stringBuilder.append(string).append(" IS NOT ").append(string2);
                } else {
                    stringBuilder.append(string).append("!=").append(string2);
                }
                return stringBuilder.toString();
            }
            case 49: {
                stringBuilder.append(string).append(' ').append("AND").append(' ').append(string2);
                return stringBuilder.toString();
            }
            case 50: {
                stringBuilder.append(string).append(' ').append("OR").append(' ').append(string2);
                return stringBuilder.toString();
            }
            case 54: {
                stringBuilder.append(string).append(' ').append("IN").append(' ').append(string2);
                return stringBuilder.toString();
            }
            case 68: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(string2);
                return stringBuilder.toString();
            }
            case 69: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(492).append(string2);
                return stringBuilder.toString();
            }
            case 70: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(125).append(string2);
                return stringBuilder.toString();
            }
            case 71: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(315).append(string2);
                return stringBuilder.toString();
            }
            case 72: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(315).append(' ').append(492).append(string2);
                return stringBuilder.toString();
            }
            case 73: {
                stringBuilder.append(string).append(' ').append("MATCH").append(' ').append(315).append(' ').append(125).append(string2);
                return stringBuilder.toString();
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuilder.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
            case 48: {
                if (this.nodes[0].opType == 67) {
                    stringBuilder.append("DISTINCT");
                    return stringBuilder.toString();
                }
                stringBuilder.append("NOT");
                break;
            }
            case 67: {
                stringBuilder.append("NOT").append(' ').append("DISTINCT");
                break;
            }
            case 40: {
                stringBuilder.append("EQUAL");
                break;
            }
            case 41: 
            case 42: {
                stringBuilder.append("GREATER_EQUAL");
                break;
            }
            case 43: {
                stringBuilder.append("GREATER");
                break;
            }
            case 44: {
                stringBuilder.append("SMALLER");
                break;
            }
            case 45: {
                stringBuilder.append("SMALLER_EQUAL");
                break;
            }
            case 46: {
                stringBuilder.append("NOT_EQUAL");
                break;
            }
            case 49: {
                stringBuilder.append("AND");
                break;
            }
            case 50: {
                stringBuilder.append("OR");
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                stringBuilder.append("MATCH");
                break;
            }
            case 47: {
                stringBuilder.append("IS").append(' ').append("NULL");
                break;
            }
            case 66: {
                stringBuilder.append("UNIQUE");
                break;
            }
            case 55: {
                stringBuilder.append("EXISTS");
                break;
            }
            case 56: {
                stringBuilder.append("OVERLAPS");
                break;
            }
            case 59: {
                stringBuilder.append("CONTAINS");
                break;
            }
            case 60: {
                stringBuilder.append("EQUALS");
                break;
            }
            case 61: {
                stringBuilder.append("OVERLAPS");
                break;
            }
            case 62: {
                stringBuilder.append("PRECEDES");
                break;
            }
            case 63: {
                stringBuilder.append("SUCCEEDS");
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg_left=[");
            stringBuilder.append(this.nodes[0].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuilder.append(" arg_right=[");
            stringBuilder.append(this.nodes[1].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        if (this.isQuantified && this.nodes[1].opType == 30 && this.nodes[1] instanceof ExpressionTable && this.nodes[1].nodes[0].opType == 8) {
            this.nodes[0].resolveTypes(session, this);
            this.nodes[1].nodes[0].dataType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].resolveTypes(session, this);
        }
        block0 : switch (this.opType) {
            case 1: {
                break;
            }
            case 67: {
                this.changeToRowExpression(0);
                this.changeToRowExpression(1);
                this.resolveRowTypes();
                this.checkRowComparison();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                this.resolveTypesForComparison(session, expression);
                break;
            }
            case 49: {
                Object object;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session, expression);
                        break;
                    }
                    Object object2 = this.nodes[0].getValue(session);
                    if (object2 != null && !Boolean.FALSE.equals(object2)) break;
                    this.setAsConstantValue(Boolean.FALSE, expression);
                    break;
                }
                if (this.nodes[1].opType != 1 || (object = this.nodes[1].getValue(session)) != null && !Boolean.FALSE.equals(object)) break;
                this.setAsConstantValue(Boolean.FALSE, expression);
                break;
            }
            case 50: {
                Object object;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session, expression);
                        break;
                    }
                    Object object3 = this.nodes[0].getValue(session);
                    if (!Boolean.TRUE.equals(object3)) break;
                    this.setAsConstantValue(Boolean.TRUE, expression);
                    break;
                }
                if (this.nodes[1].opType != 1 || !Boolean.TRUE.equals(object = this.nodes[1].getValue(session))) break;
                this.setAsConstantValue(Boolean.TRUE, expression);
                break;
            }
            case 39: 
            case 47: {
                switch (this.nodes[0].opType) {
                    case 25: {
                        Expression[] expressionArray = this.nodes[0].nodes;
                        Expression expression2 = null;
                        for (int i3 = 0; i3 < expressionArray.length; ++i3) {
                            ExpressionLogical expressionLogical = new ExpressionLogical(47, expressionArray[i3]);
                            if (this.opType == 39) {
                                expressionLogical = new ExpressionLogical(48, (Expression)expressionLogical);
                            }
                            expression2 = ExpressionLogical.andExpressions(expression2, expressionLogical);
                        }
                        this.opType = 49;
                        this.nodes = expression2.nodes;
                        this.resolveTypes(session, expression);
                        break block0;
                    }
                    case 22: 
                    case 23: {
                        break block0;
                    }
                }
                if (this.nodes[0].isUnresolvedParam()) {
                    if (session.database.sqlEnforceTypes) {
                        throw Error.error(5563);
                    }
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.opType == 39) {
                    ExpressionLogical expressionLogical = new ExpressionLogical(47, this.nodes[0]);
                    this.nodes[0] = expressionLogical;
                    this.opType = 48;
                    this.resolveTypes(session, expression);
                    break;
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session, expression);
                break;
            }
            case 48: {
                if (this.nodes[0].isUnresolvedParam()) {
                    this.nodes[0].dataType = Type.SQL_BOOLEAN;
                    break;
                }
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[0].dataType.isBooleanType()) {
                        this.setAsConstantValue(session, expression);
                        break;
                    }
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null || !this.nodes[0].dataType.isBooleanType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 56: {
                this.resolveTypesForOverlaps();
                break;
            }
            case 54: {
                this.resolveTypesForIn(session);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 66: {
                this.nodes[0].table.getFullIndex(session);
                break;
            }
            case 55: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
    }

    private void resolveTypesForLogicalOp() {
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5571);
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25) {
            throw Error.error(5565);
        }
        if (Type.SQL_BOOLEAN != this.nodes[0].dataType || Type.SQL_BOOLEAN != this.nodes[1].dataType) {
            throw Error.error(5568);
        }
    }

    private void resolveTypesForComparison(Session session, Expression expression) {
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.resolveTypesForAllAny(session);
            this.checkRowComparison();
            return;
        }
        int n2 = this.nodes[0].getDegree();
        int n3 = this.nodes[1].getDegree();
        if (n2 > 1 || n3 > 1) {
            if (n2 != n3) {
                throw Error.error(5564);
            }
            this.resolveRowTypes();
            this.checkRowComparison();
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (!this.nodes[0].dataType.canCompareDirect(this.nodes[1].dataType) && !this.convertDateTime(session)) {
            if (this.nodes[0].dataType.isBitType() || this.nodes[0].dataType.isBooleanType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isBitType() || this.nodes[1].dataType.isBooleanType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isNumberType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                    this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                }
            } else if (this.nodes[1].dataType.isNumberType()) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                    this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                }
            } else if (this.nodes[0].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0]);
                }
            } else if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
            } else {
                throw Error.error(5562);
            }
        }
        if (this.opType != 40 && this.opType != 46 && (this.nodes[0].dataType.isArrayType() || this.nodes[0].dataType.isLobType() || this.nodes[1].dataType.isLobType())) {
            throw Error.error(5534);
        }
        if (this.nodes[0].opType == 14 && this.nodes[1].opType == 1) {
            this.isTerminal = true;
        }
        if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
            throw Error.error(5562);
        }
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session, expression);
        } else if (session.database.sqlSyntaxDb2 && this.nodes[0].dataType.typeComparisonGroup == 12) {
            if (this.nodes[0].opType == 1) {
                this.nodes[1].dataType.convertToTypeLimits(session, this.nodes[0].valueData);
            }
            if (this.nodes[1].opType == 1) {
                this.nodes[0].dataType.convertToTypeLimits(session, this.nodes[1].valueData);
            }
        }
    }

    private void changeToRowExpression(int n2) {
        switch (this.nodes[n2].opType) {
            case 22: 
            case 25: {
                break;
            }
            default: {
                this.nodes[n2] = new Expression(25, new Expression[]{this.nodes[n2]});
                this.nodes[n2].nodeDataTypes = new Type[]{this.nodes[n2].nodes[0].dataType};
            }
        }
    }

    private void resolveRowTypes() {
        for (int i2 = 0; i2 < this.nodes[0].nodeDataTypes.length; ++i2) {
            Type type = this.nodes[0].nodeDataTypes[i2];
            Type type2 = this.nodes[1].nodeDataTypes[i2];
            if (type == null) {
                type = this.nodes[0].nodeDataTypes[i2] = type2;
            } else if (this.nodes[1].dataType == null) {
                type2 = this.nodes[1].nodeDataTypes[i2] = type;
            }
            if (type == null || type2 == null) {
                throw Error.error(5567);
            }
            if (type.typeComparisonGroup != type2.typeComparisonGroup) {
                throw Error.error(5562);
            }
            if (!type.isDateTimeType() || !(type.isDateTimeTypeWithZone() ^ type2.isDateTimeTypeWithZone())) continue;
            this.nodes[0].nodes[i2] = new ExpressionOp(this.nodes[0].nodes[i2]);
            this.nodes[0].nodeDataTypes[i2] = this.nodes[0].nodes[i2].dataType;
        }
    }

    void checkRowComparison() {
        if (this.opType == 40 || this.opType == 46) {
            return;
        }
        for (int i2 = 0; i2 < this.nodes[0].nodeDataTypes.length; ++i2) {
            Type type = this.nodes[0].nodeDataTypes[i2];
            Type type2 = this.nodes[1].nodeDataTypes[i2];
            if (!type.isArrayType() && !type.isLobType() && !type2.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private boolean convertDateTime(Session session) {
        int n2 = 0;
        int n3 = 1;
        if (!this.nodes[n2].dataType.isDateTimeType()) {
            if (this.nodes[n3].dataType.isDateTimeType()) {
                n2 = 1;
                n3 = 0;
            } else {
                return false;
            }
        }
        if (this.nodes[n2].dataType.isDateTimeTypeWithZone()) {
            return false;
        }
        if (this.nodes[n3].dataType.isCharacterType()) {
            if (this.nodes[n3].opType == 1) {
                block8: {
                    try {
                        this.nodes[n3].valueData = this.nodes[n2].dataType.castToType(session, this.nodes[n3].valueData, this.nodes[n3].dataType);
                        this.nodes[n3].dataType = this.nodes[n2].dataType;
                    }
                    catch (HsqlException hsqlException) {
                        if (this.nodes[n2].dataType != Type.SQL_DATE) break block8;
                        this.nodes[n3].valueData = Type.SQL_TIMESTAMP.castToType(session, this.nodes[n3].valueData, this.nodes[n3].dataType);
                        this.nodes[n3].dataType = Type.SQL_TIMESTAMP;
                    }
                }
                return true;
            }
            this.nodes[n3] = new ExpressionOp(this.nodes[n3], this.nodes[n2].dataType);
            this.nodes[n3].resolveTypes(session, this);
            return true;
        }
        return false;
    }

    void resolveTypesForOverlaps() {
        if (this.nodes[0].nodes[0].isUnresolvedParam()) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[0].isUnresolvedParam()) {
            this.nodes[1].nodes[0].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (this.nodes[0].nodes[0].dataType == null) {
            this.nodes[0].nodes[0].dataType = Type.SQL_TIMESTAMP;
            this.nodes[1].nodes[0].dataType = Type.SQL_TIMESTAMP;
        }
        if (this.nodes[0].nodes[1].isUnresolvedParam()) {
            this.nodes[0].nodes[1].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[1].isUnresolvedParam()) {
            this.nodes[1].nodes[1].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[1].nodes[0].dataType, this.nodes[1].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        this.nodes[0].nodeDataTypes[0] = this.nodes[0].nodes[0].dataType;
        this.nodes[0].nodeDataTypes[1] = this.nodes[0].nodes[1].dataType;
        this.nodes[1].nodeDataTypes[0] = this.nodes[1].nodes[0].dataType;
        this.nodes[1].nodeDataTypes[1] = this.nodes[1].nodes[1].dataType;
    }

    void resolveTypesForAllAny(Session session) {
        int n2 = this.nodes[0].getDegree();
        if (n2 == 1 && this.nodes[0].opType != 25) {
            this.nodes[0] = new Expression(25, new Expression[]{this.nodes[0]});
        }
        if (this.nodes[1].opType == 26) {
            this.nodes[1].prepareTable(session, this.nodes[0], n2);
            this.nodes[1].table.prepareTable(session);
        }
        if (this.nodes[1].nodeDataTypes == null) {
            this.nodes[1].prepareTable(session, this.nodes[0], n2);
        }
        if (n2 != this.nodes[1].nodeDataTypes.length) {
            throw Error.error(5564);
        }
        if (this.nodes[1].opType == 26) {
            // empty if block
        }
        if (this.nodes[0].nodeDataTypes == null) {
            this.nodes[0].nodeDataTypes = new Type[this.nodes[0].nodes.length];
        }
        for (int i2 = 0; i2 < this.nodes[0].nodeDataTypes.length; ++i2) {
            Type type = this.nodes[0].nodes[i2].dataType;
            if (type == null) {
                type = this.nodes[1].nodeDataTypes[i2];
            }
            if (type == null) {
                throw Error.error(5567);
            }
            if (type.typeComparisonGroup != this.nodes[1].nodeDataTypes[i2].typeComparisonGroup) {
                throw Error.error(5563);
            }
            this.nodes[0].nodeDataTypes[i2] = type;
            this.nodes[0].nodes[i2].dataType = type;
        }
    }

    void resolveTypesForIn(Session session) {
        this.resolveTypesForAllAny(session);
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 31: {
                return this.dataType.negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
            case 39: 
            case 47: {
                switch (this.nodes[0].opType) {
                    case 22: 
                    case 23: 
                    case 25: {
                        Object[] objectArray = this.nodes[0].getRowValue(session);
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            if (!(objectArray[i2] == null ? this.opType == 39 : this.opType == 47)) continue;
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                }
                return this.nodes[0].getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 56: {
                Object[] objectArray = this.nodes[0].getRowValue(session);
                Object[] objectArray2 = this.nodes[1].getRowValue(session);
                return DateTimeType.overlaps(session, objectArray, this.nodes[0].nodeDataTypes, objectArray2, this.nodes[1].nodeDataTypes);
            }
            case 54: {
                return this.testInCondition(session);
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.testMatchCondition(session);
            }
            case 67: {
                return this.testNotDistinctCondition(session);
            }
            case 66: {
                this.nodes[0].materialise(session);
                return this.nodes[0].table.hasUniqueNotNullRows(session) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return this.testExistsCondition(session);
            }
            case 48: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                return bl == null ? null : (bl != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 49: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.FALSE.equals(bl)) {
                    return Boolean.FALSE;
                }
                Boolean bl2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(bl2)) {
                    return Boolean.FALSE;
                }
                if (bl == null || bl2 == null) {
                    return null;
                }
                return Boolean.TRUE;
            }
            case 50: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(bl)) {
                    return Boolean.TRUE;
                }
                Boolean bl3 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(bl3)) {
                    return Boolean.TRUE;
                }
                if (bl == null || bl3 == null) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (this.exprSubType == 52 || this.exprSubType == 51) {
                    return this.testAllAnyCondition(session);
                }
                Object object = this.nodes[0].getValue(session);
                Object object2 = this.nodes[1].getValue(session);
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isArrayType()) {
                    return this.compareValues(session, object, object2);
                }
                if (object instanceof Object[]) {
                    if (object2 != null && !(object2 instanceof Object[])) {
                        throw Error.runtimeError(201, "ExpressionLogical");
                    }
                    return this.compareValues(session, (Object[])object, (Object[])object2);
                }
                if (object2 instanceof Object[]) {
                    object2 = ((Object[])object2)[0];
                }
                return this.compareValues(session, object, object2);
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        int n2 = this.nodes[0].dataType.compare(session, object, object2, this.opType);
        switch (this.opType) {
            case 40: {
                return n2 == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return n2 != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return n2 > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 42: {
                return n2 >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                return n2 <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                return n2 < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean matchValues(Session session, Object[] objectArray, Object[] objectArray2) {
        Type[] typeArray = this.nodes[0].nodeDataTypes;
        int n2 = 0;
        switch (this.opType) {
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                for (int i2 = 0; i2 < this.nodes[0].nodes.length; ++i2) {
                    Object object = objectArray[i2];
                    Object object2 = objectArray2[i2];
                    if ((object != null || this.opType != 69 && this.opType != 72) && (n2 = typeArray[i2].compare(session, object, object2)) != 0) break;
                }
                return n2 == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object[] objectArray, Object[] objectArray2) {
        Type[] typeArray = this.nodes[0].nodeDataTypes;
        int n2 = 0;
        boolean bl = false;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.nodes[0].nodes.length; ++i2) {
            Object object = objectArray[i2];
            Object object2 = objectArray2[i2];
            if (object == null || object2 == null) {
                bl = true;
                continue;
            }
            n2 = typeArray[i2].compare(session, object, object2);
            if (n2 != 0) break;
        }
        switch (this.opType) {
            case 40: 
            case 54: {
                if (n2 == 0) {
                    if (bl) {
                        return null;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 46: {
                if (n2 == 0) {
                    if (bl) {
                        return null;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 43: {
                if (bl) {
                    return null;
                }
                return n2 > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 42: {
                if (bl) {
                    return null;
                }
                return n2 >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                if (bl) {
                    return null;
                }
                return n2 <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                if (bl) {
                    return null;
                }
                return n2 < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testInCondition(Session session) {
        Object[] objectArray = this.nodes[0].getRowValue(session);
        if (objectArray == null) {
            return null;
        }
        if (Expression.countNulls(objectArray) != 0) {
            return null;
        }
        if (this.nodes[1].opType == 26) {
            int n2 = this.nodes[1].nodes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray2 = this.nodes[1].nodes[i2].getRowValue(session);
                if (!Boolean.TRUE.equals(this.compareValues(session, objectArray, objectArray2))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testNotDistinctCondition(Session session) {
        Object[] objectArray = this.nodes[0].getRowValue(session);
        Object[] objectArray2 = this.nodes[1].getRowValue(session);
        if (objectArray == null || objectArray2 == null) {
            return objectArray == objectArray2;
        }
        return this.matchValues(session, objectArray, objectArray2);
    }

    private Boolean testMatchCondition(Session session) {
        Object[] objectArray = this.nodes[0].getRowValue(session);
        if (objectArray == null) {
            return Boolean.TRUE;
        }
        int n2 = ExpressionLogical.countNulls(objectArray);
        if (n2 != 0) {
            switch (this.opType) {
                case 68: 
                case 71: {
                    return Boolean.TRUE;
                }
                case 69: 
                case 72: {
                    if (n2 != objectArray.length) break;
                    return Boolean.TRUE;
                }
                case 70: 
                case 73: {
                    return n2 == objectArray.length ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        switch (this.nodes[1].opType) {
            case 26: {
                int n3 = this.nodes[1].nodes.length;
                boolean bl = false;
                block16: for (int i2 = 0; i2 < n3; ++i2) {
                    Object[] objectArray2 = this.nodes[1].nodes[i2].getRowValue(session);
                    Boolean bl2 = this.matchValues(session, objectArray, objectArray2);
                    if (!bl2.booleanValue()) continue;
                    switch (this.opType) {
                        case 68: 
                        case 69: 
                        case 70: {
                            return Boolean.TRUE;
                        }
                        case 71: 
                        case 72: 
                        case 73: {
                            if (bl) {
                                return Boolean.FALSE;
                            }
                            bl = true;
                            continue block16;
                        }
                    }
                }
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                PersistentStore persistentStore = this.nodes[1].getTable().getRowStore(session);
                this.nodes[1].materialise(session);
                ExpressionLogical.convertToType(session, objectArray, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                if (n2 != 0 && (this.opType == 69 || this.opType == 72)) {
                    boolean bl = false;
                    RowIterator rowIterator = this.nodes[1].getTable().rowIterator(session);
                    while (rowIterator.next()) {
                        Object[] objectArray3 = rowIterator.getCurrent();
                        Boolean bl3 = this.matchValues(session, objectArray, objectArray3);
                        if (bl3 == null || !bl3.booleanValue()) continue;
                        if (this.opType == 69) {
                            return Boolean.TRUE;
                        }
                        if (bl) {
                            return Boolean.FALSE;
                        }
                        bl = true;
                    }
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                RowIterator rowIterator = this.nodes[1].getTable().getFullIndex(session).findFirstRow(session, persistentStore, objectArray);
                boolean bl = rowIterator.next();
                if (!bl) {
                    return Boolean.FALSE;
                }
                switch (this.opType) {
                    case 68: 
                    case 69: 
                    case 70: {
                        return Boolean.TRUE;
                    }
                }
                while (bl = rowIterator.next()) {
                    Object[] objectArray4 = rowIterator.getCurrent();
                    if (!Boolean.TRUE.equals(this.matchValues(session, objectArray, objectArray4))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    private Boolean testExistsCondition(Session session) {
        this.nodes[0].materialise(session);
        return this.nodes[0].getTable().isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAllAnyCondition(Session session) {
        Object[] objectArray = this.nodes[0].getRowValue(session);
        TableDerived tableDerived = this.nodes[1].table;
        tableDerived.materialiseCorrelated(session);
        Boolean bl = this.getAllAnyValue(session, objectArray, tableDerived);
        return bl;
    }

    private Boolean getAllAnyValue(Session session, Object[] objectArray, TableDerived tableDerived) {
        int n2;
        boolean bl = tableDerived.isEmpty(session);
        Index index = tableDerived.getFullIndex(session);
        PersistentStore persistentStore = tableDerived.getRowStore(session);
        int n3 = ExpressionLogical.countNulls(objectArray);
        boolean bl2 = false;
        for (n2 = 0; n2 < tableDerived.columnCount; ++n2) {
            bl2 |= persistentStore.hasNull(n2);
        }
        ExpressionLogical.convertToType(session, objectArray, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
        switch (this.exprSubType) {
            case 52: {
                if (bl) {
                    return Boolean.FALSE;
                }
                if (n3 == objectArray.length) {
                    return null;
                }
                n2 = this.opType == 46 ? 40 : this.opType;
                RowIterator rowIterator = index.findFirstRow(session, persistentStore, objectArray, objectArray.length, 0, n2, false, null);
                switch (this.opType) {
                    case 40: {
                        if (rowIterator.next()) {
                            if (n3 == 0) {
                                return Boolean.TRUE;
                            }
                            return null;
                        }
                        if (n3 == 0) {
                            if (bl2) break;
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                }
                rowIterator = index.firstRow(persistentStore);
                boolean bl3 = false;
                while (rowIterator.next()) {
                    Object[] objectArray2 = rowIterator.getCurrent();
                    Boolean bl4 = this.compareValues(session, objectArray, objectArray2);
                    if (bl4 == null) {
                        bl3 = true;
                        continue;
                    }
                    if (!bl4.booleanValue()) continue;
                    rowIterator.release();
                    return Boolean.TRUE;
                }
                if (bl3) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 51: {
                RowIterator rowIterator;
                if (bl) {
                    return Boolean.TRUE;
                }
                if (n3 == objectArray.length) {
                    return null;
                }
                switch (this.opType) {
                    case 40: {
                        break;
                    }
                    case 46: {
                        if (bl2) break;
                        rowIterator = index.findFirstRow(session, persistentStore, objectArray);
                        if (rowIterator.next()) {
                            return Boolean.FALSE;
                        }
                        if (n3 != 0) break;
                        return Boolean.TRUE;
                    }
                    case 41: 
                    case 42: 
                    case 43: {
                        if (bl2) break;
                        RowIterator rowIterator2 = index.lastRow(session, persistentStore, 0, null);
                        rowIterator2.next();
                        Object[] objectArray3 = rowIterator2.getCurrent();
                        return this.compareValues(session, objectArray, objectArray3);
                    }
                    case 44: 
                    case 45: {
                        if (bl2) break;
                        RowIterator rowIterator3 = index.firstRow(persistentStore);
                        rowIterator3.next();
                        Object[] objectArray4 = rowIterator3.getCurrent();
                        return this.compareValues(session, objectArray, objectArray4);
                    }
                }
                rowIterator = index.firstRow(persistentStore);
                boolean bl5 = false;
                while (rowIterator.next()) {
                    Object[] objectArray5 = rowIterator.getCurrent();
                    Boolean bl6 = this.compareValues(session, objectArray, objectArray5);
                    if (bl6 == null) {
                        bl5 = true;
                        continue;
                    }
                    if (bl6.booleanValue()) continue;
                    rowIterator.release();
                    return Boolean.FALSE;
                }
                if (bl5) {
                    return null;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.runtimeError(201, "ExpressionLogical");
    }

    void distributeOr() {
        if (this.opType != 50) {
            return;
        }
        if (this.nodes[0].opType == 49) {
            this.opType = 49;
            ExpressionLogical expressionLogical = new ExpressionLogical(50, this.nodes[0].nodes[1], this.nodes[1]);
            this.nodes[0].opType = 50;
            this.nodes[0].nodes[1] = this.nodes[1];
            this.nodes[1] = expressionLogical;
        } else if (this.nodes[1].opType == 49) {
            Expression expression = this.nodes[0];
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = expression;
            this.distributeOr();
            return;
        }
        ((ExpressionLogical)this.nodes[0]).distributeOr();
        ((ExpressionLogical)this.nodes[1]).distributeOr();
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        switch (this.opType) {
            case 49: {
                boolean bl = this.nodes[0].isIndexable(rangeVariable) || this.nodes[1].isIndexable(rangeVariable);
                return bl;
            }
            case 50: {
                boolean bl = this.nodes[0].isIndexable(rangeVariable) && this.nodes[1].isIndexable(rangeVariable);
                return bl;
            }
        }
        Expression expression = this.getIndexableExpression(rangeVariable);
        return expression != null;
    }

    @Override
    Expression getIndexableExpression(RangeVariable rangeVariable) {
        switch (this.opType) {
            case 47: {
                return this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVariable) ? this : null;
            }
            case 48: {
                return this.nodes[0].opType == 47 && this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].isIndexable(rangeVariable) ? this : null;
            }
            case 40: {
                if (this.exprSubType == 52) {
                    if (this.nodes[1].isCorrelated()) {
                        return null;
                    }
                    for (int i2 = 0; i2 < this.nodes[0].nodes.length; ++i2) {
                        if (this.nodes[0].nodes[i2].opType != 2 || !this.nodes[0].nodes[i2].isIndexable(rangeVariable)) continue;
                        return this;
                    }
                    return null;
                }
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.exprSubType != 0) {
                    return null;
                }
                if (this.nodes[1].isCorrelated()) {
                    return null;
                }
                if (this.nodes[0].opType == 2 && this.nodes[0].isIndexable(rangeVariable)) {
                    if (this.nodes[1].hasReference(rangeVariable)) {
                        return null;
                    }
                    return this;
                }
                if (this.nodes[0].hasReference(rangeVariable)) {
                    return null;
                }
                if (this.nodes[1].opType == 2 && this.nodes[1].isIndexable(rangeVariable)) {
                    this.swapCondition();
                    return this;
                }
                return null;
            }
            case 50: {
                if (this.isIndexable(rangeVariable)) {
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    boolean isSimpleBound() {
        if (this.opType == 47) {
            return true;
        }
        if (this.nodes[1] != null) {
            if (this.nodes[1].opType == 1) {
                return true;
            }
            if (this.nodes[1].opType == 28 && ((FunctionSQL)this.nodes[1]).isValueFunction()) {
                return true;
            }
        }
        return false;
    }

    boolean convertToSmaller() {
        switch (this.opType) {
            case 41: 
            case 43: {
                this.swapCondition();
                return true;
            }
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    void swapCondition() {
        int n2 = 40;
        switch (this.opType) {
            case 41: 
            case 42: {
                n2 = 45;
                break;
            }
            case 45: {
                n2 = 41;
                break;
            }
            case 44: {
                n2 = 43;
                break;
            }
            case 43: {
                n2 = 44;
                break;
            }
            case 67: {
                n2 = 67;
                break;
            }
            case 40: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        this.opType = n2;
        Expression expression = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = expression;
    }

    boolean reorderComparison(Session session, Expression expression) {
        Expression expression2 = null;
        Expression expression3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        if (this.nodes[0].opType == 32) {
            n2 = 33;
            bl = true;
        } else if (this.nodes[0].opType == 33) {
            n2 = 32;
            bl = true;
        } else if (this.nodes[1].opType == 32) {
            n2 = 33;
        } else if (this.nodes[1].opType == 33) {
            n2 = 32;
        }
        if (n2 == 0) {
            return false;
        }
        if (bl) {
            if (this.nodes[0].nodes[0].opType == 2) {
                expression2 = this.nodes[0].nodes[0];
                expression3 = this.nodes[0].nodes[1];
            } else if (this.nodes[0].nodes[1].opType == 2) {
                bl2 = n2 == 32;
                expression2 = this.nodes[0].nodes[1];
                expression3 = this.nodes[0].nodes[0];
            }
        } else if (this.nodes[1].nodes[0].opType == 2) {
            expression2 = this.nodes[1].nodes[0];
            expression3 = this.nodes[1].nodes[1];
        } else if (this.nodes[1].nodes[1].opType == 2) {
            bl2 = n2 == 32;
            expression2 = this.nodes[1].nodes[1];
            expression3 = this.nodes[1].nodes[0];
        }
        if (expression2 == null) {
            return false;
        }
        Expression expression4 = bl ? this.nodes[1] : this.nodes[0];
        ExpressionArithmetic expressionArithmetic = null;
        if (!bl2) {
            expressionArithmetic = new ExpressionArithmetic(n2, expression4, expression3);
            expressionArithmetic.resolveTypesForArithmetic(session, expression);
        }
        if (bl) {
            if (bl2) {
                this.nodes[1] = expression2;
                this.nodes[0].nodes[1] = expression4;
                ((ExpressionArithmetic)this.nodes[0]).resolveTypesForArithmetic(session, expression);
            } else {
                this.nodes[0] = expression2;
                this.nodes[1] = expressionArithmetic;
            }
        } else if (bl2) {
            this.nodes[0] = expression2;
            this.nodes[1].nodes[1] = expression4;
            ((ExpressionArithmetic)this.nodes[1]).resolveTypesForArithmetic(session, expression);
        } else {
            this.nodes[1] = expression2;
            this.nodes[0] = expressionArithmetic;
        }
        return true;
    }

    @Override
    boolean isConditionRangeVariable(RangeVariable rangeVariable) {
        if (this.nodes[0].getRangeVariable() == rangeVariable) {
            return true;
        }
        return this.nodes[1].getRangeVariable() == rangeVariable;
    }

    @Override
    void getJoinRangeVariables(RangeVariable[] rangeVariableArray, List list) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            this.nodes[i2].getJoinRangeVariables(rangeVariableArray, list);
        }
    }

    @Override
    double costFactor(Session session, RangeVariable rangeVariable, int n2) {
        double d2;
        block0 : switch (this.opType) {
            case 50: {
                return this.nodes[0].costFactor(session, rangeVariable, this.opType) + this.nodes[1].costFactor(session, rangeVariable, this.opType);
            }
            case 54: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                PersistentStore persistentStore = rangeVariable.rangeTable.getRowStore(session);
                d2 = persistentStore.elementCount();
                if (!(d2 < 16.0)) break;
                d2 = 16.0;
                break;
            }
            case 47: 
            case 48: {
                d2 = this.costFactorUnaryColumn(session, rangeVariable);
                break;
            }
            case 40: {
                switch (this.exprSubType) {
                    case 52: {
                        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVariable) {
                            d2 = this.costFactorColumns(session, rangeVariable);
                            d2 *= 1024.0;
                            break block0;
                        }
                    }
                    case 51: {
                        PersistentStore persistentStore = rangeVariable.rangeTable.getRowStore(session);
                        d2 = persistentStore.elementCount();
                        if (d2 < 16.0) {
                            d2 = 16.0;
                        }
                        d2 *= 1024.0;
                        break block0;
                    }
                }
                d2 = this.costFactorColumns(session, rangeVariable);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                d2 = this.costFactorColumns(session, rangeVariable);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        return d2;
    }

    double costFactorUnaryColumn(Session session, RangeVariable rangeVariable) {
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVariable) {
            return this.nodes[0].costFactor(session, rangeVariable, this.opType);
        }
        PersistentStore persistentStore = rangeVariable.rangeTable.getRowStore(session);
        double d2 = persistentStore.elementCount();
        return d2 < 16.0 ? 16.0 : d2;
    }

    double costFactorColumns(Session session, RangeVariable rangeVariable) {
        PersistentStore persistentStore;
        double d2 = 0.0;
        if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVariable) {
            if (!this.nodes[1].hasReference(rangeVariable)) {
                d2 = this.nodes[0].costFactor(session, rangeVariable, this.opType);
            }
        } else if (this.nodes[1].opType == 2 && this.nodes[1].getRangeVariable() == rangeVariable) {
            if (!this.nodes[0].hasReference(rangeVariable)) {
                d2 = this.nodes[1].costFactor(session, rangeVariable, this.opType);
            }
        } else {
            persistentStore = rangeVariable.rangeTable.getRowStore(session);
            d2 = persistentStore.elementCount();
        }
        if (d2 == 0.0) {
            persistentStore = rangeVariable.rangeTable.getRowStore(session);
            d2 = persistentStore.elementCount();
        }
        if (d2 < 16.0) {
            d2 = 16.0;
        }
        return d2;
    }
}

