/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.List;
import org.hsqldb.types.Type;

public class ExpressionAccessor
extends Expression {
    ExpressionAccessor(Expression expression, Expression expression2) {
        super(100);
        this.nodes = new Expression[]{expression, expression2};
    }

    @Override
    public ColumnSchema getColumn() {
        return this.nodes[0].getColumn();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List list, boolean bl) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            list = this.nodes[i2].resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType == null) {
            throw Error.error(5567);
        }
        if (!this.nodes[0].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        this.dataType = this.nodes[0].dataType.collectionBaseType();
        if (this.nodes[1].opType == 8) {
            this.nodes[1].dataType = Type.SQL_INTEGER;
        }
    }

    @Override
    public Object getValue(Session session) {
        Object[] objectArray = (Object[])this.nodes[0].getValue(session);
        if (objectArray == null) {
            return null;
        }
        Number number = (Number)this.nodes[1].getValue(session);
        if (number == null) {
            return null;
        }
        if (number.intValue() < 1 || number.intValue() > objectArray.length) {
            throw Error.error(3490);
        }
        return objectArray[number.intValue() - 1];
    }

    public Object[] getUpdatedArray(Session session, Object[] objectArray, Object object, boolean bl) {
        if (objectArray == null) {
            throw Error.error(3413);
        }
        Number number = (Number)this.nodes[1].getValue(session);
        if (number == null) {
            throw Error.error(3490);
        }
        int n2 = number.intValue() - 1;
        if (n2 < 0) {
            throw Error.error(3490);
        }
        if (n2 >= this.nodes[0].dataType.arrayLimitCardinality()) {
            throw Error.error(3490);
        }
        Object[] objectArray2 = objectArray;
        if (n2 >= objectArray.length) {
            objectArray2 = new Object[n2 + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        } else if (bl) {
            objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[n2] = object;
        return objectArray2;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionAccessor.getContextSQL(this.nodes[0]);
        stringBuilder.append(string).append('[');
        stringBuilder.append(this.nodes[1].getSQL()).append(']');
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("ARRAY ACCESS");
        if (this.getLeftNode() != null) {
            stringBuilder.append(" array=[");
            stringBuilder.append(this.nodes[0].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuilder.append(" array_index=[");
            stringBuilder.append(this.nodes[1].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

