/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.hsqldb.ClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.result.Result;

public class ClientConnectionHTTP
extends ClientConnection {
    static final String ENCODING = "ISO-8859-1";
    static final int IDLENGTH = 12;
    private HttpURLConnection httpConnection = null;

    public ClientConnectionHTTP(String string, int n2, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, int n3) {
        super(string, n2, string2, string3, bl, bl2, string4, string5, n3);
    }

    public ClientConnectionHTTP(ClientConnectionHTTP clientConnectionHTTP) {
        super(clientConnectionHTTP);
    }

    @Override
    protected void initConnection(String string, int n2, boolean bl) {
    }

    @Override
    protected void openConnection(String string, int n2, boolean bl) {
        try {
            URL uRL = null;
            String string2 = "";
            if (!this.path.endsWith("/")) {
                string2 = "/";
            }
            uRL = bl ? new URL("https://" + string + ":" + n2 + this.path + string2 + this.database) : new URL("http://" + string + ":" + n2 + this.path + string2 + this.database);
            this.httpConnection = (HttpURLConnection)uRL.openConnection();
            this.httpConnection.setDefaultUseCaches(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    public synchronized Result execute(Result result) {
        this.openConnection(this.host, this.port, this.isTLS);
        Result result2 = super.execute(result);
        this.closeConnection();
        return result2;
    }

    @Override
    public Result cancel(Result result) {
        ClientConnectionHTTP clientConnectionHTTP = new ClientConnectionHTTP(this);
        return clientConnectionHTTP.execute(result);
    }

    @Override
    protected void write(Result result) throws IOException, HsqlException {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(hsqlByteArrayOutputStream);
        result.write(this, dataOutputStream, this.rowOut);
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setUseCaches(false);
        this.httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
        this.httpConnection.setRequestProperty("Content-Length", String.valueOf(12 + hsqlByteArrayOutputStream.size()));
        this.dataOutput = new DataOutputStream(this.httpConnection.getOutputStream());
        this.dataOutput.writeInt(result.getDatabaseId());
        this.dataOutput.writeLong(result.getSessionId());
        hsqlByteArrayOutputStream.writeTo(this.dataOutput);
        this.dataOutput.flush();
    }

    @Override
    protected Result read() throws IOException, HsqlException {
        this.dataInput = new DataInputStream(new BufferedInputStream(this.httpConnection.getInputStream()));
        this.rowOut.reset();
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.dataInput.close();
        return result;
    }

    @Override
    protected void handshake() {
    }
}

